package org.unitedfront2.web.mail;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;

import javax.servlet.ServletContext;

/**
 * Web AvP[VReLXgŗp {@link XmlTemplateSpringMailSender} łB
 *
 * @author kurokkie
 *
 */
public class WebXmlTemplateSpringMailSender
    extends XmlTemplateSpringMailSender {

    /** ev[gt@C̃x[XfBNg (/WEB-INF/view) */
    public static final String BASE_DIR = "/WEB-INF/view";

    /** {@link ServletContext} */
    private ServletContext servletContext;

    public WebXmlTemplateSpringMailSender(ServletContext servletContext) {
        super();
        this.servletContext = servletContext;
    }

    public WebXmlTemplateSpringMailSender(String mailTemplateName,
            ServletContext servletContext) {
        super(mailTemplateName);
        this.servletContext = servletContext;
    }

    @Override
    protected URL getUrl(Locale locale) throws IllegalArgumentException {
        String path = BASE_DIR + "/" + getMailTemplateName().replace(".", "/")
            + "_" + locale.getLanguage() + ".xml";
        URL input;
        try {
            input = servletContext.getResource(path);
        } catch (MalformedURLException e) {
            logger.error(e);
            throw new IllegalArgumentException(e);
        }
        if (input == null) {
            String message = "The template file '" + path + "' not found.";
            logger.error(message);
            throw new IllegalArgumentException(message);
        }
        return input;
    }
}
