package org.unitedfront2.web.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Repository;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;
import org.unitedfront2.domain.Terminal;
import org.unitedfront2.web.WebUtils;

/**
 * NCAg[ɉăr[ύX邽߂̃C^[Zv^łB
 *
 * @author kurokkie
 *
 */
@Repository(value = "terminalChangeInterceptor")
public class TerminalChangeInterceptor extends HandlerInterceptorAdapter {

    /** [UNGXgۂ̃L[ ( terminal ) */
    public static final String REQUEST_KEY = "terminal";

    /** O */
    protected final Log logger = LogFactory.getLog(getClass());

    /**@NCAgoCłƎf User-Agent NGXgwb_̐K\@*/
    private List<String> mobileUserAgentsRegex = new ArrayList<String>(0);

    /**
     * [̎ނNGXgꂽꍇȀZbVɊi[܂B
     *
     * @param request HTTP NGXg
     * @param response HTTP X|X
     * @param handler nh
     * @return ̃nhsȂ trueAłȂ false
     */
    @Override
    public boolean preHandle(HttpServletRequest request,
            HttpServletResponse response, Object handler) {

        try {
            String requestedTerminal = request.getParameter(REQUEST_KEY);
            if (requestedTerminal == null) {
                return true;
            }

            requestedTerminal = requestedTerminal.toUpperCase(Locale.ENGLISH);
            if (!Terminal.contains(requestedTerminal)) {
                // `ĂȂ[
                if (logger.isWarnEnabled()) {
                    logger.warn("The requested terminal '" + requestedTerminal
                        + "' is not defined.");
                }
                return true;
            }

            Terminal terminal
                = Terminal.valueOf(requestedTerminal);

            HttpSession session = request.getSession();
            session.setAttribute(WebUtils.TERMINAL_PARAM_NAME, terminal);
            return true;
        } finally {
            setTerminal(request);
        }
    }

    private void setTerminal(HttpServletRequest request) {

        HttpSession session = request.getSession(false);

        if (session == null) {
            if (isMobileUserAgent(request)) {
                request.setAttribute(WebUtils.TERMINAL_PARAM_NAME,
                        Terminal.MOBILE);
            } else {
                request.setAttribute(WebUtils.TERMINAL_PARAM_NAME, Terminal.PC);
            }
        } else {
            Object terminal = session.getAttribute(
                    WebUtils.TERMINAL_PARAM_NAME);
            if (terminal != null) {
                request.setAttribute(WebUtils.TERMINAL_PARAM_NAME, terminal);
            } else if (isMobileUserAgent(request)) {
                session.setAttribute(WebUtils.TERMINAL_PARAM_NAME,
                        Terminal.MOBILE);
                request.setAttribute(WebUtils.TERMINAL_PARAM_NAME,
                        Terminal.MOBILE);
            } else {
                session.setAttribute(WebUtils.TERMINAL_PARAM_NAME, Terminal.PC);
                request.setAttribute(WebUtils.TERMINAL_PARAM_NAME, Terminal.PC);
            }
        }
    }

    /**
     * NGXgoC[ł邩ǂ UserAgent wb_画肵܂B
     * @param request HTTP NGXg
     * @return oC[ł trueAłȂ falseAUserAgent sȂ false
     */
    private boolean isMobileUserAgent(HttpServletRequest request) {
        String userAgent = request.getHeader("User-Agent");
        if (userAgent == null) {
            return false;
        }
        for (String s : mobileUserAgentsRegex) {
            if (userAgent.matches(s)) {
                return true;
            }
        }
        return false;
    }

    public void setMobileUserAgentsRegex(List<String> mobileUserAgentsRegex) {
        this.mobileUserAgentsRegex = mobileUserAgentsRegex;
    }
}
