package org.unitedfront2.web.controller.community;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.unitedfront2.domain.communication.Community;
import org.unitedfront2.domain.communication.CommunityTable;
import org.unitedfront2.domain.communication.Message;
import org.unitedfront2.domain.communication.Thread;

/**
 * L폜ANVNXłB
 *
 * @author kurokkie
 *
 */
@Repository(value = "community.entryDeleteAction")
public class EntryDeleteAction extends AbstractAction {

    /** R~jeBe[u */
    @Autowired
    private CommunityTable communityTable;

    @Override
    protected Event doExecute(RequestContext context) {
        Community c = Utils.findCommunity(context, this,
                communityTable, "communityCode");
        Thread t = Utils.findThread(context, this, c, "threadId");
        Message entry = Utils.findEntryAndWriteAccess(context, this, c,
                "threadId", "entryCode");

        entry.delete();

        context.getFlowScope().put("thread", t);
        context.getFlowScope().put("community", c);
        return result(c.getClass().getSimpleName());
    }
}
