package org.unitedfront2.web.controller.blog;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.unitedfront2.domain.communication.Blog;
import org.unitedfront2.domain.communication.BlogEntryExistException;
import org.unitedfront2.domain.communication.BlogTable;
import org.unitedfront2.web.WebUtils;
import org.unitedfront2.web.flow.AccessDeniedException;

/**
 * uO폜ANVNXłB
 *
 * @author kurokkie
 *
 */
@Repository(value = "blog.deleteAction")
public class DeleteAction extends AbstractAction {

    /** uOe[u */
    @Autowired private BlogTable blogTable;

    /**
     * uO폜܂B
     *
     * @param context {@link RequestContext}
     * @return Cxg
     * @throws AccessDeniedException ҏWȂ
     */
    @Override
    protected Event doExecute(RequestContext context)
        throws AccessDeniedException {
        Blog blog = Utils.findAndWriteAccessByCode(context, this, blogTable,
                "code");
        try {
            blog.delete();
        } catch (BlogEntryExistException e) {
            // ʑȂNȂ
            throw new IllegalArgumentException(e);
        }

        context.getFlowScope().put("user", WebUtils.getUser(context));
        return success();
    }
}
