package org.unitedfront2.domain.communication;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitedfront2.domain.DomainFactory;

/**
 * uOL̃t@NgNXłB
 *
 * @author kurokkie
 *
 */
public class BlogEntryTable {

    /** O */
    protected final Log logger = LogFactory.getLog(getClass());

    /** bZ[We[u */
    private MessageTable messageTable;

    /** hCt@Ng */
    private DomainFactory domainFactory;

    /**
     * uOL擾܂B
     *
     * @param id uOL ID
     * @return uOL
     */
    public BlogEntry find(int id) {
        Message entry = messageTable.find(id);
        if (entry == null) {
            return null;
        }
        return domainFactory.prototype(new BlogEntry(entry));
    }

    /**
     * uOL擾܂B
     *
     * @param id uOL ID
     * @return uOL
     * @throws IllegalArgumentException w肵 ID ݂ȂB
     */
    public BlogEntry get(int id) throws IllegalArgumentException {
        BlogEntry entry = find(id);
        if (entry == null) {
            String message = "The blog entry ID '" + id + "' not found.";
            logger.error(message);
            throw new IllegalArgumentException(message);
        }
        return entry;
    }

    /**
     * LR[huOL擾܂B
     *
     * @param code LR[hibZ[WR[hj
     * @return uOLAȂ <code>null</code>
     */
    public BlogEntry findByCode(String code) {
        Message entry = messageTable.findByCode(code);
        if (entry == null) {
            return null;
        }
        return domainFactory.prototype(new BlogEntry(entry));
    }

    public void setMessageTable(MessageTable messageTable) {
        this.messageTable = messageTable;
    }

    public void setDomainFactory(DomainFactory domainFactory) {
        this.domainFactory = domainFactory;
    }
}
