package org.unitedfront2.dao;

import java.util.List;

import org.unitedfront2.domain.communication.Mail;

/**
 * [̃f[^ANZXC^[tF[XłB
 *
 * @author kurokkie
 *
 */
public interface MailDao extends Registerable<Mail>, SimpleFindable<Mail>, Dao {

    @Override
    void register(Mail mail);

    /**
     * [o^܂Bol̐ݒ͔CӂłBM͌ݓœo^܂BR[h͎
     * Ő܂BebZ[Ww肵܂BebZ[WɊɕԐM悪ݒ肳ĂƂĂA[X
     * bh̖ɃbZ[Wݒ肵܂B
     *
     * @param mail [
     * @param parentId e[ ID
     * @ensure ${mail.id} is auto generated.
     * @ensure ${mail.code} is auto generated.
     * @ensure ${mail.sentDate} is current date.
     * @ensure ${mail} equals ${this.find(mail.id)}
     * @ensure ${mail} equals ${this.findThread(parentId).tail}
     */
    void register(Mail mail, int parentId);

    /**
     * R[h烁[擾܂B
     *
     * @param code R[h
     * @return [AȂ <code>null</code>
     */
    Mail findByCode(String code);

    /**
     * [Tu[܂߂XbhƂĎ擾܂Be[ւ̎QƂԂ܂B
     *
     * @param id [ ID
     * @return [XbhAȂꍇ <code>null</code>
     */
    Mail findThread(int id);

    /**
     * [Tu[܂߂XbhƂĎ擾܂Be[ւ̎QƂԂ܂B
     *
     * @param code [R[h
     * @return [XbhAȂꍇ <code>null</code>
     */
    Mail findThreadByCode(String code);

    /**
     * [XgTu[܂߂XbhƂĎ擾܂BXbhōŐV̑M[̑
     * M̍~ƂȂXbh擾܂B
     *
     * @param ownerId L҂̃[U ID
     * @param no JngXbhԍ
     * @param num 擾
     * @require ${start} < ${end}
     * @return [XbhXg
     */
    List<Mail> findThreads(int ownerId, int no, int num);

    /**
     * ${ownerId} [Xbȟ擾܂B
     *
     * @param ownerId L ID
     * @return [Xbȟ
     */
    int countThreads(int ownerId);

    /**
     * ${ownerId} ǃ[̌擾܂B
     *
     * @param ownerId L҂̃[U ID
     * @return ǃ[
     */
    int countUnreadMail(int ownerId);

    /**
     * w肵[̊/ǂύX܂B
     *
     * @param id [ ID
     * @param read ǂɂȂ <code>true</code> AǂɂȂ <code>false</code>
     * @ensure ${this.find(id).read} = ${read}
     */
    void updateRead(int id, boolean read);
}
