/* main.cpp for TOPPERS/ATK(OSEK) */ 

// ECRobot++ API
#include "Lcd.h"
#include "Bluetooth.h"
#include "BTConnection.h"
#include "Clock.h"
#include "GyroSensor.h"
#include "LightSensor.h"
#include "Motor.h"
#include "Nxt.h"
#include "SonarSensor.h"
#include "Speaker.h"
#include "TouchSensor.h"

#include "tsprintf.h"
#include "ETLineTracer.h"
#include "ETLinePos.h"
#include "ETBalanceRunner.h"
#include "ETTailControl.h"
#include "context.h"
#include "ETUtility.h"

using namespace ecrobot;

extern "C"
{
#include "kernel.h"
#include "kernel_id.h"
#include "ecrobot_interface.h"

DeclareTask(TaskMain);
DeclareCounter(SysTimerCnt);//AlarmpKv

// global object instances
Nxt nxt;
Lcd lcd;
Speaker speaker;
Bluetooth bt;
Clock clock;
GyroSensor gyro(PORT_1);
SonarSensor sonar(PORT_2);
LightSensor light(PORT_3);
TouchSensor touch(PORT_4);
Motor motorT(PORT_A);
Motor motorR(PORT_B);
Motor motorL(PORT_C);

ETBalanceRunner runner(motorL,motorR,gyro,nxt);
ETLinePos linepos(light);
ETLineTracer tracer(linepos,runner);
ETTailControl tailcontroler(motorT,0);
ContextStuff::Context context;

/* foCXIptbN֐ */
/* ̊֐STOP܂EXIT{^ꂽɎs܂B */
void ecrobot_device_terminate()
{
	/* ZTA[^Ȃǂ̊efoCX̏I֐
	 * Ŏ邱Ƃł܂B
	 * ˁ@ZTԐFLEDOFFɂ
	 */
	//ecrobot_set_light_sensor_inactive(SENSOR_LIGHT);
	ecrobot_term_bt_connection(); /* BluetoothʐMI */							//ex4
}

// nxtOSEK hook to be invoked from an ISR in category 2
void user_1ms_isr_type2(void)
{
    //  //SleeppKv
    SleeperMonitor();
    //  //AlarmpKv
    StatusType ercd;
    ercd = SignalCounter(SysTimerCnt);
    if (ercd != E_OK) {
        ShutdownOS(ercd);
    }
}

TASK(TaskMain)
{
    //bt.setFriendlyName(DEVICE_NAME);
	BTConnection btConnection(bt, lcd, nxt);
	btConnection.connect(ETBluetoothString::PASS_KEY);
	lcd.clear();
	lcd.putf("s", "Hello World");
	lcd.disp();
    tailcontroler.Init();
    tailcontroler.SetAngle(ETTailControl::ANGLE_STAND_UP);

	// Lu[V
	// WC
	while(!ETUtilityStuff::Istouched(touch,tailcontroler)) {}
    unsigned long offset = ETUtilityStuff::GetOffset(gyro,clock);
	runner.SetGyroOffset(offset);
    //display to LCD
    ETUtilityStuff::DisplayCalibResult(lcd,speaker,"Offset = %d",offset,1000,1);

	// 
	while(!ETUtilityStuff::Istouched(touch,tailcontroler)) {}
    unsigned long white = ETUtilityStuff::GetOffset(light,clock);
	linepos.SetWhite(white);
    //display to LCD
    ETUtilityStuff::DisplayCalibResult(lcd,speaker,"White = %d",white,1200,2);

	// 
	while(!ETUtilityStuff::Istouched(touch,tailcontroler)) {}
    unsigned long black = ETUtilityStuff::GetOffset(light,clock);
	linepos.SetBlack(black);
    //display to LCD
    ETUtilityStuff::DisplayCalibResult(lcd,speaker,"Black = %d",black,1400,3);

    //wait for touch or bluetooth.
    ETUtilityStuff::Waitstart(touch,tailcontroler,ETBluetoothString::CMD_START);

	tailcontroler.SetAngle(ETTailControl::ANGLE_DRIVE);
    context.SetETLineTracer(&tracer);
	TerminateTask();
}

TASK(Task4ms)
{
	if(touch.isPressed()){
//		motorR.setPWM(0);
//		motorL.setPWM(0);
		tracer.Stop();
		tracer.Reset();
		ActivateTask(TaskMain);
		TerminateTask();
		return;
	}
    context.Display(lcd);
    context.CyclicExcute();
    tailcontroler.Control();

	TerminateTask();
}

int __cxa_pure_virtual(){
	// z֐I[o[ChȂŌĂяoꂽ̃G[nh
	// ȂramgpʂƂĂEEE
	return 0;
}

}	// extern "C"
