#include "ETLinePos.h"
#include "LightSensor.h"

namespace ecrobot{

ETLinePos::ETLinePos(LightSensor& light)
	: m_light(light), m_black(276), m_white(459)
{
}
ETLinePos::~ETLinePos(void)
{
}
int ETLinePos::GetLinePos()
{
	static const int range = 100;	// -range <= result <= range ɐK܂
	return (m_light.getBrightness() - (m_white + m_black) / 2) * range / (m_white - m_black);
}
void ETLinePos::SetBlack(int value)
{
	m_black = value;
}
void ETLinePos::SetWhite(int value)
{
	m_white = value;
}

}
