#include "ETBalanceRunner.h"
#include "Motor.h"
#include "GyroSensor.h"
#include "Nxt.h"

extern "C" {
#include "balancer.h"
}

namespace ecrobot{

ETBalanceRunner::ETBalanceRunner(Motor& motorL, Motor& motorR, GyroSensor& gyro, Nxt& nxt)
	: m_motorL(motorL), m_motorR(motorR), m_gyro(gyro), m_nxt(nxt),
	m_bInitialized(false), m_gyrooffset(590), m_bException(false), m_msec(0)
{
}
ETBalanceRunner::~ETBalanceRunner(void)
{
}
void ETBalanceRunner::Run(int forward, int turn)
{
	if(!m_bInitialized){
		balance_init();
		m_motorL.reset();
		m_motorR.reset();
		m_bInitialized = true;
	}
	S8 r,l;
	balance_control(forward,0,m_gyro.get(),m_gyrooffset,m_motorL.getCount(),m_motorR.getCount(),m_nxt.getBattMv(),&l,&r);
	JudgeException(l,r);
	if(IsException()){
		Stop();
		return;
	}
	l = l + turn;
	r = r - turn;
	if(100 < l){
		r = r + (l - 100);
		l = 100;
	}else if(r < -100){
		l = l + (r - (-100));
		r = -100;
	}
	m_motorL.setPWM(l);
	m_motorR.setPWM(r);
}
bool ETBalanceRunner::IsException() const
{
	return m_bException;
}
void ETBalanceRunner::Stop()
{
	m_motorL.setPWM(0);
	m_motorR.setPWM(0);
}
void ETBalanceRunner::Reset()
{
	m_bInitialized = false;
	m_bException = false;
	m_msec = 0;
}
void ETBalanceRunner::SetGyroOffset(int offset)
{
	m_gyrooffset = offset;
}
void ETBalanceRunner::JudgeException(int l,int r)
{
	static const int LIMIT = 2000;	/* 2[sec] */
	if((l == 100 && r == 100) || (l == -100 && r == -100)){	/* +100-100ɒt */
		if(m_msec >= LIMIT){	/* 莞ԁ}100ێO */
			m_bException = true;
		}
		else{
			m_msec += 4;	/* +4[msec] */
		}
	}else{
		m_msec = 0;
	}
}

}
