require 'test_helper'

class ExifsControllerTest < ActionController::TestCase
  setup do
    @exif = exifs(:one)
  end

  test "should get index" do
    get :index
    assert_response :success
    assert_not_nil assigns(:exifs)
  end

  test "should get new" do
    get :new
    assert_response :success
  end

  test "should create exif" do
    assert_difference('Exif.count') do
      post :create, exif: @exif.attributes
    end

    assert_redirected_to exif_path(assigns(:exif))
  end

  test "should show exif" do
    get :show, id: @exif.to_param
    assert_response :success
  end

  test "should get edit" do
    get :edit, id: @exif.to_param
    assert_response :success
  end

  test "should update exif" do
    put :update, id: @exif.to_param, exif: @exif.attributes
    assert_redirected_to exif_path(assigns(:exif))
  end

  test "should destroy exif" do
    assert_difference('Exif.count', -1) do
      delete :destroy, id: @exif.to_param
    end

    assert_redirected_to exifs_path
  end
end
