// ----------------------------------------------------------------------------
// markItUp!
// ----------------------------------------------------------------------------
// Copyright (C) 2008 Jay Salvat
// http://markitup.jaysalvat.com/
// ----------------------------------------------------------------------------
myWikiSettings = {
    nameSpace:          "wiki", // Useful to prevent multi-instances CSS conflict
    //previewTemplatePath: '~/templates/preview.html',
    //previewInWindow: 'width=800, height=600, resizable=yes, scrollbars=yes',
    previewAutoRefresh: true,
    previewPosition: 'before',
    previewParser: function(content) {
        var converter = new Wiki.Formatter();
        return converter.format(content);
    },
    previewStyleUrls: $Tiempo.BaseStyles,
    previewOuterElement: '<div class="post"><div class="entry"></div></div>',
    previewBodyCss: { fontSize: "small", },
    previewRunWithStart: true,
    //onEnter: {keepDefault:false, replaceWith:'<br />\n'},
    onShiftEnter:       {keepDefault:false, replaceWith:'\n\n'},
    markupSet:  [
        {name:'Heading 1', key:'1', openWith:'* ', placeHolder:'Your title here...' },
        {name:'Heading 2', key:'2', openWith:'** ', placeHolder:'Your title here...' },
        {name:'Heading 3', key:'3', openWith:'*** ', placeHolder:'Your title here...' },
        {separator:'---------------' },
        {name:'Horizontal', key:"H", openWith:'----' },
        {separator:'---------------' },
        {name:'Bold', key:'B', openWith:"'''", closeWith:"'''"},
        {name:'Italic', key:'I', openWith:"''", closeWith:"''"},
        {name:'Stroke through', key:'S', openWith:'%%', closeWith:'%%'},
        {name:'Subscript', openWith:'__', closeWith:'__'},
        {separator:'---------------' },
        {name:'Bulleted list', openWith:'(!(- |!|-)!)'},
        {name:'Numeric list', openWith:'(!(+ |!|+)!)'},
        {separator:'---------------' },
        {name:'Picture', key:'P', replaceWith:'[[Image:[![Url:!:http://]!]|[![name]!]]]'},
        {name:'Link', key:'L', openWith:'[[![Link]!] ', closeWith:']', placeHolder:'Your text to link here...' },
        {name:'Url', openWith:'[[![Url:!:http://]!] ', closeWith:']', placeHolder:'Your text to link here...' },
        {separator:'---------------' },
        {name:'Quotes', openWith:'(!(> |!|>)!)'},
        {name:'Code', openWith:'(!(<source lang="[![Language:!:php]!]">|!|<pre>)!)', closeWith:'(!(</source>|!|</pre>)!)'},
        {separator:'---------------' },
        //{name:'Preview', call:'preview', className:'preview'}
    ]
}
