# encoding: utf-8
Tiempo::Application.routes.draw do

  root :to => 'home#index'

  devise_for :users, :controllers => { :omniauth_callbacks => "users/omniauth_callbacks" }

  post 'users/edit/icon', :to => 'usericon#create'
  post 'users/edit/icon_local', :to => 'usericon#create_from_local'

  #devise
  get 'archives/index', :to => 'archives#index', :as => :user_root

  resources :publish, :only => [:index, :show] do
    get 'page/:page', :action => :index, :on => :collection
  end

  resources :archives, :only => [:index] do
    get 'page/:page', :action => :index, :on => :collection
  end

  resources :public_gallery, :only => [:index] do
    get 'page/:page', :action => :index, :on => :collection
  end

  resources :posts do
    get 'page/:page', :action => :index, :on => :collection
    get 'preview', :action => :preview, :on => :collection
    resources :comments, :only => [:destroy, :create] do
    end
    resources :galleries do
      get 'page/:page', :action => :index, :on => :collection, :as => :pager
    end
    resources :uploader, :only => [:index, :create] do
    end
  end

  resources :api, :only => [:preview, :user_bloglist, :bloglist, :userlist, :categorylist, :render_kml] do
    get 'bloglist/:page/:per', :action => :bloglist, :on => :collection, :as => :bloglist
    get 'user_bloglist/:id/:page/:per', :action => :user_bloglist, :on => :collection, :as => :user_bloglist
    get 'userlist/:page/:per', :action => :userlist, :on => :collection, :as => :userlist
    get 'userlist/:page/:per', :action => :userlist, :on => :collection, :as => :userlist
    get 'categorylist/:per', :action => :categorylist, :on => :collection, :as => :categorylist   
    get 'kml/:id', :action => :render_kml, :on => :collection, :as => :kml
  end

  resources :pubapi, :only => [:bloglist] do
    get 'user_bloglist/:id/:page/:per', :action => :user_bloglist, :on => :collection, :as => :user_bloglist
    get 'bloglist/:page/:per', :action => :bloglist, :on => :collection, :as => :bloglist
  end

  # The priority is based upon order of creation:
  # first created -> highest priority.

  # Sample of regular route:
  #   match 'products/:id' => 'catalog#view'
  # Keep in mind you can assign values other than :controller and :action

  # Sample of named route:
  #   match 'products/:id/purchase' => 'catalog#purchase', :as => :purchase
  # This route can be invoked with purchase_url(:id => product.id)

  # Sample resource route (maps HTTP verbs to controller actions automatically):
  #   resources :products

  # Sample resource route with options:
  #   resources :products do
  #     member do
  #       get 'short'
  #       post 'toggle'
  #     end
  #
  #     collection do
  #       get 'sold'
  #     end
  #   end

  # Sample resource route with sub-resources:
  #   resources :products do
  #     resources :comments, :sales
  #     resource :seller
  #   end

  # Sample resource route with more complex sub-resources
  #   resources :products do
  #     resources :comments
  #     resources :sales do
  #       get 'recent', :on => :collection
  #     end
  #   end

  # Sample resource route within a namespace:
  #   namespace :admin do
  #     # Directs /admin/products/* to Admin::ProductsController
  #     # (app/controllers/admin/products_controller.rb)
  #     resources :products
  #   end

  # You can have the root of your site routed with "root"
  # just remember to delete public/index.html.
  # root :to => 'welcome#index'

  # See how all your routes lay out with "rake routes"

  # This is a legacy wild controller route that's not recommended for RESTful applications.
  # Note: This route will make all actions in every controller accessible via GET requests.
  # match ':controller(/:action(/:id(.:format)))'
end
