# encoding: utf-8
class User < ActiveRecord::Base
  devise :database_authenticatable, :registerable,
         :confirmable, :lockable, :timeoutable,
         :recoverable, :rememberable, :trackable, :validatable,
         :omniauthable

  attr_accessible :email, :password, :password_confirmation, :remember_me, :nickname, :location,
                  :comment, :icon, :exifable, :commentable, :publish, :style,
                  :uid, :access_token, :access_secret, :tweetable

  mount_uploader :icon, IconUploader

  acts_as_tagger

  has_many :posts
  has_many :galleries
  has_many :comments

  validates :nickname, :uniqueness => true

  after_create :set_defaulticon
  def set_defaulticon
    self.icon.store!(File.open("#{Rails.root}/app/assets/images/icon/user01.png"))
    self.save!
  end

end
