# encoding: utf-8
class Q
  extend ActiveModel::Naming
  include ActiveModel::Conversion

  def initialize(params = {})
    @params = params || {}
  end

  def [](key)
    @params[key.to_sym]
  end

  def []=(key, value)
    @params[key.to_sym] = value
  end

  def persisted?
    false
  end

  def respond_to?(name, priv=false)
    true
  end

  def method_missing(name, *args)
    if name.to_s.ends_with?('=')
      @params[name.to_s.chomp('=').to_sym] = *args[0]
    else
      @params[name.to_sym]
    end
  end

  def to_s
    @params.to_s
  end

  def to_query_string
    kvs = @params.map do |k, v|
      "q[#{URI.encode(k.to_s)}]=#{URI.encode(v.to_s)}"
    end
    if @params.length == 0
      ''
    else
      '?' + kvs.join('&')
    end
  end

  def delete!(key)
    @params.delete key.to_sym
  end
end
