# encoding: utf-8

class Post < ActiveRecord::Base
  include ActionView::Helpers::SanitizeHelper

  attr_accessible :title, :content, :markdown, :user_id, :commentable, 
                  :publish, :category_list, :tweetable

  acts_as_commentable

  acts_as_taggable_on :tags, :categories

  default_scope :order => 'posted_at desc'
  paginates_per 5

  belongs_to :user
  has_many :galleries, :dependent => :destroy

  before_save :strip_html
  def strip_html
    raw = ''
    raw << strip_tags(self.title) if self.title
    raw << '  '
    raw << strip_tags(self.content) if self.content
    self.rawdata = raw
  end

  def snoop(request)
    self.user_ip = request.remote_ip
    self.user_agent = request.user_agent
    self.referrer = request.referrer
  end

end
