# encoding: utf-8
class Comment < ActiveRecord::Base
  include ActsAsCommentable::Comment

  belongs_to :commentable, :polymorphic => true
  default_scope :include => 'user', :order => 'created_at ASC'

  # NOTE: install the acts_as_votable plugin if you
  # want user to vote on the quality of comments.
  #acts_as_voteable

  # NOTE: Comments belong to a user
  belongs_to :user

  def snoop(request)
    self.user_ip = request.remote_ip
    self.user_agent = request.user_agent
    self.referrer = request.referrer
  end

end
