# encoding: utf-8
module UploaderHelper

  def photo_uploadify
    session_key_name = Rails.application.config.session_options[:key]
    lang = "uploadify/uploadifyLang_#{I18n.locale.to_s.gsub(/:/, '')}.js"

    %Q{

    <script type='text/javascript'>
      $(document).ready(function() {
        if (!FlashDetect.versionAtLeast(9)) {
          $("#uploadify").html('You do not have Flash Player installed or your Flash Player is too old!<br>Please install Flash Player 9 or higher.');
          $("#uploadform").show();
        }
        else {
          $("#uploadform").hide();
          $("#uploadify").uploadify({
            // Required Settings
            langFile : "#{asset_path(lang)}",
            swf : "#{asset_path('uploadify/uploadify.swf')}",
            uploader : "#{post_uploader_index_path(@post)}",
            'checkExisting'   : false,
            'folder'          : '/uploads',
            'createFolder'    : false,
            'debug'           : false,
            'auto'            : true,
            'width'           : 150,
            'height'          : 30,
            'successTimeout'  : 60,
            'cancelImage'     : "#{asset_path('uploadify/uploadify-cancel.png')}",
            'fileSizeLimit'   : 10 * 1024,
            'fileTypeExts'    : '*.jpg;*.jpeg;*.gif;*.png;*.JPG;*.JPEG;*.GIF;*.PNG',
            'fileTypeDesc'    : 'Image Files (.JPG, .GIF, .PNG)',
            'method'          : 'post',
            'multi'           : true,
            'requeueErrors'   : false,
            'queueID'         : 'file_queue',
            'queueSizeLimit'  : #{Settings.max_upload_queue},
            'removeCompleted' : true,
            'postData'        : {
              'post_id' : '#{@post.id}',
              '_http_accept': 'application/javascript',
              '#{session_key_name}' : '#{u(cookies[session_key_name])}',
              'authenticity_token'  : '#{form_authenticity_token}'
            },
            'progressData'    : 'all',

            onSelect : function(file) {
            },
            onUploadSuccess : function(file, data, response) {
              eval(data);
            },
            onUploadComplete : function(file, queue) {
            },
            onQueueComplete : function (stats) {
              $.ajax({
                type: 'get',
                data: {
                  'post_id' : '#{@post.id}',
                  '_http_accept': 'application/javascript',
                  '#{session_key_name}' : '#{u(cookies[session_key_name])}',
                  'authenticity_token'  : '#{form_authenticity_token}'
                },
                dataType: 'script',
                url: '#{post_uploader_index_path(@post)}'

              });
            },
            onUploadError : function (file, errorCode, errorMsg, errorString, queue) {
              $('#uploadify').uploadifyStop();
              alert('ファイルアップロードでエラーが発生しました。' + errorMsg);
            }
          });
        }
      });
    </script>

    }.html_safe
    #}.gsub(/[\n ]+/, ' ').strip.html_safe
  end

end
