# encoding: utf-8
class Users::OmniauthCallbacksController < Devise::OmniauthCallbacksController

  def twitter
    access_token = env["omniauth.auth"]
    
    current_user.uid = access_token['uid'].to_i
    current_user.access_token = access_token['credentials']['token']
    current_user.access_secret = access_token['credentials']['secret']
    current_user.save!
    
    flash[:notice] = I18n.t "devise.omniauth_callbacks.success", :kind => "TwitterAuth"
    redirect_to edit_user_registration_path
  rescue => err
    flash[:notice] = I18n.t "devise.omniauth_callbacks.failure", :kind => "TwitterAuth", :reason => err.message
    redirect_to edit_user_registration_path
  end
end
