# encoding: utf-8
class UsericonController < ApplicationController
  before_filter :authenticate_user!
  respond_to :js

  # クライアントからのアップロード
  def create
    image = params[:Filedata]

    @user = current_user
    @user.icon = image

    msg = nil

    if @user.save
      respond_with(@user) do |format|
        format.js { render 'callback', :location => edit_user_registration_path, :locals => { :msg => msg } }
      end
    else
      msg = I18n.t('flash.errors.format_error')
      logger.warn(msg + "\n" + image.pretty_inspect)
      respond_with(@post, @gallery) do |format|
        format.js { render 'callback', :location => edit_user_registration_path, :locals => { :msg => msg } }
      end
    end
  end

  # テンプレートからの選択
  def create_from_local
    id = params[:icon_id]
    @user = current_user
    @user.icon.store!(File.open("#{Rails.root}/app/assets/images/icon/#{id}.png"))

    msg = nil

    if @user.save
      respond_with(@user) do |format|
        format.js { render 'callback', :location => edit_user_registration_path, :locals => { :msg => msg } }
      end
    else
      msg = I18n.t('flash.errors.format_error')
      logger.warn(msg + "\n" + image.pretty_inspect)
      respond_with(@post, @gallery) do |format|
        format.js { render 'callback', :location => edit_user_registration_path, :locals => { :msg => msg } }
      end
    end
  end

end
