# encoding: utf-8
class PublicGalleryController < ApplicationController
  before_filter :authenticate_user!
  respond_to :json, :html

  def index
    @q = Q.new(params[:q])
    cond = {}

    where = ''
    where << '1 = 1 '
    if @q.image_name && @q.image_name.length > 0
      where << 'AND name like :image_name '
      cond[:image_name] = "%#{@q.image_name}%"
    end

    if @q.from && @q.from.length > 0
      where << 'AND exifs.date_time_original >= :from '
      dt = @q.from.split(/\//)
      cond[:from] = Date::new(dt[0].to_i, dt[1].to_i, dt[2].to_i)
    end

    if @q.to && @q.to.length > 0
      where << 'AND exifs.date_time_original <= :to '
      dt = @q.to.split(/\//)
      cond[:to] = Date::new(dt[0].to_i, dt[1].to_i, dt[2].to_i)
    end

    if @q.auther && @q.auther.length > 0
      where << 'AND user_id = :user_id '
      cond[:user_id] = @q.auther
    end

    if @q.make && @q.make.length > 0
      where << 'AND exifs.make like :make '
      cond[:make] = "%#{@q.make}%"
    end

    if @q.model && @q.model.length > 0
      where << 'AND exifs.model like :model '
      cond[:model] = "%#{@q.model}%"
    end

    if params[:tag]
      @q[:word] = params[:tag]
      @galleries = Gallery.tagged_with(params[:tag], :any => true).page(params[:page])
    else
      if cond.size > 0
        @galleries = Gallery.where(where, cond).page(params[:page])
      else
        @galleries = Gallery.page(params[:page])
      end
    end

    @months = Gallery.unscoped.tag_counts_on(:months, { :order => 'tags.name'})
    @models = Gallery.unscoped.tag_counts_on(:models, {:limit => Settings.max_tags, :order => 'tags.created_at desc, taggings.tags_count desc'})
    @gallery_months = @galleries.group_by { |t| t.exif.date_time_original.beginning_of_day if t.exif.date_time_original }
  end

  def show
    @gallery = Gallery.find(params[:id])
    respond_with(@gallery)
  end

end
