# encoding: utf-8
class PubapiController < ApplicationController
  respond_to :json

  # /pubapi/bloglist/:page/:per
  # 最新公開ブログのリスト
  def bloglist
    limit = Settings.max_list
    if params[:per]
      limit = params[:per].to_i
      limit = Settings.max_list if limit > Settings.max_list || limit < 1
    end

    page = 1
    if params[:page]
      page = params[:page].to_i
      page = 1 if page == 0
    end

    posts = Post.where([ "publish = ?", true ]).page(page).per(limit)
    respond_with(posts, {:include => {:user => {:only => [:id, :nickname, :icon]}}, :only => [:title, :posted_at]})
  end

  # /pubapi/bloglist/:id/:page/:per
  # 指定ユーザーの最新公開ブログのリスト
  def user_bloglist
    limit = Settings.max_list
    if params[:per]
      limit = params[:per].to_i
      limit = Settings.max_list if limit > Settings.max_list || limit < 1
    end

    page = 1
    if params[:page]
      page = params[:page].to_i
      page = 1 if page == 0
    end

    posts = Post.where( [ "user_id = ? and publish = ?", params[:id], true ]).page(page).per(limit)
    respond_with(posts, {:include => {:user => {:only => [:id, :nickname, :icon]}}, :only => [:title, :posted_at]})
  end

end
