# encoding: utf-8
class PostsController < ApplicationController

  before_filter :authenticate_user!
  respond_to :json, :html

  # GET /posts/preview
  # 編集画面プレビュ用
  def preview
    render :layout => 'preview'
  end

  # GET /posts
  # GET /posts.json
  def index
    @posts = Post.where(:user_id => current_user).page(params[:page])
    @post_months = @posts.group_by { |t| t.posted_at.beginning_of_day if t.posted_at }
  end

  # GET /posts/1
  # GET /posts/1.json
  def show
    @post = Post.find(params[:id])
    if !@post
      render_404
    else
      @galleries = Gallery.find(:all, :conditions => ["post_id = ?", @post])

      @comment = @post.comments.build
      @comment.user = current_user
      @post.comments.pop
    end
  end

  # GET /posts/new
  # GET /posts/new.json
  def new
    @post = Post.new
    current_user.publish ? @post.publish = true : @post.publish = false
    current_user.commentable ? @post.commentable = true : @post.commentable = false
    @post.editor_type = 0
    @post.tweeted = false
    @preview_path = preview_posts_path
  end

  # GET /posts/1/edit
  def edit
    # 他ユーザーによる改竄防止
    @post = Post.find(:first, :conditions => ["id = ? and user_id = ?", params[:id], current_user])
    if !@post
      render_404
    else
      @galleries = Gallery.find(:all, :conditions => ["post_id = ?", @post])
    end
    @preview_path = preview_posts_path
  end

  # POST /posts
  # POST /posts.json
  def create
    @post = Post.new(params[:post])
    
    @post.posted_at = Time.now
    @post.user = current_user
    @post.content = BlueCloth.new(@post.markdown).to_html

    @post.snoop(request)

    @comment = @post.comments.build
    @post.comments.pop

    flash[:notice] = I18n.t('flash.messages.create', :model => Post.model_name.human) if @post.save

    #delay_job
    delayedtask = Tiempo::DelayedTask.new
    delayedtask.update_tag(@post.id)
        
    if @post.publish && @post.user.tweetable
      logger.debug("posted to twitter. post_id = #{@post.id}")
      url = getPublishUrl(@post.id)
      delayedtask.blogcast_twitter(@post.id, url)
    end
    
    respond_with(@post)
  end

  # PUT /posts/1
  # PUT /posts/1.json
  def update
    # 他ユーザーによる改竄防止
    @post = Post.find(:first, :conditions => ["id = ? and user_id = ?", params[:id], current_user])
    if !@post
      render_404
    else
      if params[:post][:markdown]
        params[:post][:content]  = BlueCloth.new(params[:post][:markdown]).to_html
      end

      @post.snoop(request)

      flash[:notice] = I18n.t('flash.messages.update', :model => Post.model_name.human) if @post.update_attributes(params[:post])

      #delay_job
      delayedtask = Tiempo::DelayedTask.new
      delayedtask.update_tag(@post.id)

      if !@post.tweeted && @post.publish && @post.user.tweetable
        logger.debug("posted to twitter. post_id = #{@post.id}")
        url = getPublishUrl(@post.id)
        delayedtask.blogcast_twitter(@post.id, url)
      end
      
      respond_with(@post)
    end
  end

  # DELETE /posts/1
  # DELETE /posts/1.json
  def destroy
    # 他ユーザーによる改竄防止
    @post = Post.find(:first, :conditions => ["id = ? and user_id = ?", params[:id], current_user])
    if !@post
      render_404
    else
      flash[:notice] = I18n.t('flash.messages.delete', :model => Post.model_name.human) if @post.destroy
      respond_with(@post)
    end
  end

  private
  def getPublishUrl(id)
    path = request.base_url + publish_index_path
    return "#{path}/#{id}"
  end
  
end
