# encoding: utf-8
class HomeController < ApplicationController
  respond_to :html

  def index
    if current_user
      redirect_to :user_root
      return
    else
      @posts = Post.find(:all, :conditions => [ "publish = ?", true ], :limit => Settings.home.post_item)
      @post_months = @posts.group_by { |t| t.posted_at.beginning_of_day }
      @galleries = Gallery.find(:all, :limit => Settings.home.gallery_item)

      respond_with(@posts, @galleries)
    end
  end

end
