# encoding: utf-8
class CommentsController < ApplicationController
  before_filter :authenticate_user!
  respond_to :json, :js

  # POST /posts/1/comments
  # POST /posts/1/comments.json
  def create
    @post = Comment.find_commentable(params[:comment][:commentable_type], params[:comment][:commentable_id])

    if !@post || !@post.commentable
      render_404
    else
      @comment = @post.comments.build(params[:comment])
      @post.comments.pop
      @comment.user = current_user
      @comment.snoop(request)

      @comment.save

      respond_with(@post) do |format|
        format.js { render 'create_callback', :location => post_path(@post, :anchor => "comments") }
      end
    end

  end

  # DELETE /posts/1/comments/1
  # DELETE /posts/1/comments/1.json
  def destroy
    @post = Post.find(params[:post_id])
    @comment = Comment.find(:first, :conditions => ["id = ? and user_id = ?", params[:id], current_user])

    if !@post
      render_404
    else
      if @comment
        @comment.destroy
      end

      respond_with(@post) do |format|
        format.js { render 'destroy_callback', :location => post_path(@post), :notice => I18n.t('flash.messages.delete', :model => Comment.model_name.human) }
      end
    end

  end

end
