# encoding: utf-8
class ApplicationController < ActionController::Base
  # CSRFのチェックがRack側でおかしい、エンコードした文字とエンコード前を比べてる気がする
  #protect_from_forgery
  before_filter :set_current_parameters

  def set_current_parameters
    @current_format = params[:format]
    @current_action = action_name
    @current_controller = controller_name
  end

  def render_500(exception = nil)
    if exception
      logger.info "Rendering 500 with exception: #{exception.message}"
    end

    render :file => "#{Rails.root}/public/500.html", :status => 500, :layout => false
  end

  def render_404(exception = nil)
    if exception
      logger.info "Rendering 404 with exception: #{exception.message}"
    end

    render :file => "#{Rails.root}/public/404.html", :status => 404, :layout => false
  end

end
