/*
 * Copyright 2004,2006 The Poderosa Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 *
 * $Id: WindowManagerEx.cs,v 1.11 2006/11/03 09:17:55 okajima Exp $
 */
using System;
using System.Collections.Generic;
using System.Windows.Forms;
using System.Drawing;
using System.Text;
//using Poderosa.Document;
using Poderosa.Sessions;
using Poderosa.Commands;

using Poderosa.View;
using Poderosa.Util;

namespace Poderosa.Forms {

    //System.Windows.Forms.ControlƓAKvȂ݂̂̂𒊏o
    /// <summary>
    /// <ja>
    /// EBhE.NET Framework̃Rg[ƂĈ߂̃C^[tFCXłB
    /// </ja>
    /// <en>
    /// Interface to treat the window as a control of .NET Framework. 
    /// </en>
    /// </summary>
    public interface IPoderosaControl : IAdaptable {
        /// <summary>
        /// <ja>.NET FrameworkControlIuWFNgɕϊ܂B</ja>
        /// <en>Convert to the Control object of .NET Framework</en>
        /// </summary>
        /// <returns><ja>ϊꂽControlIuWFNg</ja><en>Converted Control object.</en></returns>
        Control AsControl();
    }

    /// <summary>
    /// <ja>
    /// EBhE.NET Framework̃tH[ƂĈ߂̃C^[tFCXłB
    /// </ja>
    /// <en>
    /// Interface to treat the window as a form of .NET Framework. 
    /// </en>
    /// </summary>
    public interface IPoderosaForm : IPoderosaControl, ICommandTarget {
        /// <summary>
        /// <ja>
        /// .NET FrameworkFormIuWFNgɕϊ܂B
        /// </ja>
        /// <en>Convert to the Form object of .NET Framework</en>
        /// </summary>
        /// <returns><ja>ϊꂽFormIuWFNg</ja><en>Converted Form object.</en></returns>
        Form AsForm();
        /// <summary>
        /// <ja>
        /// EBhE܂B
        /// </ja>
        /// <en>
        /// Close the window.
        /// </en>
        /// </summary>
        /// <returns><ja>ꂽǂ܂BɕꂽꍇACommandResult.SucceededԂ܂B</ja><en>Whether it was closed is shown. CommandResult.Succeeded is returned when close normally. </en></returns>
        /// <remarks>
        /// <ja>
        /// ZbV̏ɂẮA[U[ɕĂ悢ǂ₢킹邱Ƃł邽߁A铮삪LZ邱Ƃ܂B
        /// LZꂽǂ́A߂lŔfĂB
        /// </ja>
        /// <en>
        /// Because it can be inquired whether I may close to the user according to the processing of the session, the closing operation might be canceled. 
        /// Please judge whether to have been canceled from the return value. 
        /// </en>
        /// </remarks>
        CommandResult CancellableClose();

        //|bvAbvj[
        /// <summary>
        /// <ja>
        /// |bvAbvj[iReLXgj[j\܂B
        /// </ja>
        /// <en>
        /// Show the popup menu (context menu).
        /// </en>
        /// </summary>
        /// <param name="menus"><ja>\郁j[j[O[vłB</ja><en>It is a menu group that shows the displayed menu. </en></param>
        /// <param name="target"><ja>j[̃^[QbgłB</ja><en>It is a target of the menu. </en></param>
        /// <param name="point_screen"><ja>\ʒułB</ja><en>It is a displayed position. </en></param>
        /// <param name="flags"><ja>j[\Ƃɐ擪̍ڂIԂɂ邩ǂ̃tOł</ja><en>Flag whether to put the first item into state of selection when menu is displayed</en></param>
        void ShowContextMenu(IPoderosaMenuGroup[] menus, ICommandTarget target, Point point_screen, ContextMenuFlags flags);

        //[Uɑ΂xnBFormLĂȂXbhĂ΂邱Ƃl邱 Note: ʃC^tF[Xɕ邩H
        /// <summary>
        /// <ja>
        /// xbZ[W{bNX\܂B
        /// </ja>
        /// <en>
        /// Show the message box of warning.
        /// </en>
        /// </summary>
        /// <param name="msg"><ja>\郁bZ[WłB</ja><en>message to display</en></param>
        /// <remarks>
        /// <ja>
        /// <para>
        /// ̃\bh́AtH[LXbhȊOĂяoĂ܂܂B
        /// </para>
        /// <para>
        /// IuWFNgւ̃bN܂܌ĂяoƁÃbN̓bZ[W{bNX܂ŉ܂B
        /// </para>
        /// </ja>
        /// <en>
        /// <para>
        /// You may call this method excluding the thread to own the form. 
        /// </para>
        /// <para>
        /// However, when the lock to the object is called while had, the lock is not released until the message box is closed. 
        /// </para>
        /// </en>
        /// </remarks>
        void Warning(string msg);
        /// <summary>
        /// <ja>
        /// 񃁃bZ[W{bNX\܂B
        /// </ja>
        /// <en>
        /// Show the message box of information.
        /// </en>
        /// </summary>
        /// <param name="msg"><ja>\郁bZ[WłB</ja><en>message to display</en></param>
        /// <remarks>
        /// <ja>
        /// <para>
        /// ̃\bh́AtH[LXbhȊOĂяoĂ܂܂B
        /// </para>
        /// <para>
        /// IuWFNgւ̃bN܂܌ĂяoƁÃbN̓bZ[W{bNX܂ŉ܂B
        /// </para>
        /// </ja>
        /// <en>
        /// <para>
        /// You may call this method excluding the thread to own the form. 
        /// </para>
        /// <para>
        /// However, when the lock to the object is called while had, the lock is not released until the message box is closed. 
        /// </para>
        /// </en>
        /// </remarks>
        void Information(string msg);
        /// <summary>
        /// <ja>
        /// m͂nmnq˂郁bZ[W{bNX\܂B
        /// </ja>
        /// <en>
        /// Show the messaage box that asks "Yes" or "No".
        /// </en>
        /// </summary>
        /// <param name="msg"><ja>\郁bZ[WłB</ja><en>message to display</en></param>
        /// <returns><ja>ǂ̃{^ꂽ̂lłBm͂n̂ƂɂDialogResult.YesAmn̂ƂɂDialogResult.NoƂȂ܂B</ja><en>It is a value in which which button was pushed is shown.When DialogResult.Yes getting it at "Yes", at the time of good it becomes DialogResult.No. </en></returns>
        /// <remarks>
        /// <ja>
        /// <para>
        /// ̃\bh́AtH[LXbhȊOĂяoĂ܂܂B
        /// </para>
        /// <para>
        /// IuWFNgւ̃bN܂܌ĂяoƁÃbN̓bZ[W{bNX܂ŉ܂B
        /// </para>
        /// </ja>
        /// <en>
        /// <para>
        /// You may call this method excluding the thread to own the form. 
        /// </para>
        /// <para>
        /// However, when the lock to the object is called while had, the lock is not released until the message box is closed. 
        /// </para>
        /// </en>
        /// </remarks>
        DialogResult AskUserYesNo(string msg);
    }

    /// <summary>
    /// <ja>
    /// ReLXgj[\Ƃ̃tO܂B
    /// </ja>
    /// <en>
    /// The flag when the context menu is displayed is shown. 
    /// </en>
    /// </summary>
    [Flags]
    public enum ContextMenuFlags {
        /// <summary>
        /// <ja>
        /// \ɉ܂B
        /// </ja>
        /// <en>
        /// Do nothing when displayed.
        /// </en>
        /// </summary>
        None = 0,
        /// <summary>
        /// <ja>
        /// \ɐ擪̍ڂIꂽԂɂ܂B
        /// </ja>
        /// <en>
        /// It puts it into the state that the first item was selected when displaying it. 
        /// </en>
        /// </summary>
        SelectFirstItem = 1
    }

    /// <summary>
    /// <ja>
    /// EBhE}l[WIDłB
    /// </ja>
    /// <en>
    /// ID of Window manager.
    /// </en>
    /// </summary>
    /// <exclude/>
    public class WindowManagerConstants {
        public const string MAINWINDOWCONTENT_ID = "org.poderosa.core.window.mainWindowContent";
        public const string VIEW_FACTORY_ID = "org.poderosa.core.window.viewFactory";
        public const string VIEWFORMATEVENTHANDLER_ID = "org.poderosa.core.window.viewFormatEventHandler";
        public const string TOOLBARCOMPONENT_ID = "org.poderosa.core.window.toolbar";
        public const string MAINWINDOWEVENTHANDLER_ID = "org.poderosa.core.window.mainWindowEventHandler";
        public const string FILEDROPHANDLER_ID = "org.poderosa.core.window.fileDropHandler";

        //͋N̑iKŃZbgKv
        public static string APPLICATION_TITLE = "Poderosa";
        public static Icon DEFAULT_FORM_ICON = null;
    }

    //WindowManagerS
    /// <summary>
    /// <ja>
    /// EBhE}l[WC^[tFCXłB
    /// </ja>
    /// <en>
    /// Interface that show the window manager.
    /// </en>
    /// </summary>
    /// <remarks>
    /// <ja>
    /// <para>
    /// EBhE}l[ẂAvOCIDu<c>org.poderosa.core.window</c>vvOCŒ񋟂Ă܂B
    /// </para>
    /// <para>
    /// ̂悤<seealso cref="Poderosa.Plugins.ICoreServices">ICoreServices</seealso>oRĎ擾ł܂B
    /// </para>
    /// <code>
    /// // ICoreServices擾
    /// ICoreServices cs = (ICoreServices)PoderosaWorld.GetAdapter(typeof(ICoreServices));
    /// // IWindowManager擾
    /// IWindowManager wm = cs.WindowManager;
    /// </code>
    /// </ja>
    /// <en>
    /// <para>
    /// Window manager is offered as the plug-in with plug-in ID [<c>org.poderosa.core.window</c>].
    /// </para>
    /// <para>
    /// <ja>̂悤<seealso cref="Poderosa.Plugins.ICoreServices">ICoreServices</seealso>oRĎ擾ł܂B</ja><en>It is possible to acquire it via <seealso cref="Poderosa.Plugins.ICoreServices">ICoreServices</seealso> as follows. </en>
    /// </para>
    /// <code>
    /// // Get ICoreServices
    /// ICoreServices cs = (ICoreServices)PoderosaWorld.GetAdapter(typeof(ICoreServices));
    /// // Get IWindowManager
    /// IWindowManager wm = cs.WindowManager;
    /// </code>
    /// </en>
    /// </remarks>
    public interface IWindowManager : IAdaptable {
        /// <summary>
        /// <ja>
        /// ׂẴCEBhEzłB
        /// </ja>
        /// <en>
        /// Array that shows all the main windows.
        /// </en>
        /// </summary>
        IPoderosaMainWindow[] MainWindows { get; }
        /// <summary>
        /// <ja>
        /// ANeBuȃEBhE܂B
        /// </ja>
        /// <en>
        /// Show the active window.
        /// </en>
        /// </summary>
        IPoderosaMainWindow ActiveWindow { get; }

        /// <summary>
        /// <ja>
        /// IuWFNg̑IƃRs[ɊւANZX񋟂ISelectionServiceԂ܂B
        /// </ja>
        /// <en>
        /// ISelectionService that offers the selection of the object and the access concerning the copy is returned. 
        /// </en>
        /// </summary>
        ISelectionService SelectionService { get; }

        //PopupView쐬 : Rō쐬r[́AZbV}l[WAttachDocAndView->Activate邱Ƃŏ߂Č悤ɂȂBCreatePopupViewł͌悤ɂ͂ȂȂƂɒ
        /// <summary>
        /// <ja>
        /// |bvAbvr[쐬܂B
        /// </ja>
        /// <en>
        /// Create the popup view.
        /// </en>
        /// </summary>
        /// <param name="viewcreation"><ja>|bvAbvr[쐬ۂ̃p[^ł</ja><en>It is a parameter when the pop up view is made. </en></param>
        /// <returns><ja>쐬ꂽ|bvAbvEBhEԂ܂B</ja><en>Return the made pop up window.</en></returns>
        /// <remarks>
        /// <ja>
        /// 쐬ꂽr[́AZbV}l[Wi<seealso cref="ISessionManager">ISessionManager</seealso>j
        /// <see cref="ISessionManager.AttachDocumentAndView">AttachDocumentAndView\bh</see>ĂяoăhLgƃr[A^b`ĂA
        /// ANeBx[g邱ƂŁA߂Č悤ɂȂ܂B̃\bhō쐬ł͌悤ɂ͂Ȃ܂B
        /// </ja>
        /// <en>
        /// It comes to see the made view for the first time by the activate after session manager(<seealso cref="ISessionManager">ISessionManager</seealso>)'s <see cref="ISessionManager.AttachDocumentAndView">AttachDocumentAndView method</see> is called and the document and the view are activated. It doesn't come to see it only by making it by this method. 
        /// </en>
        /// </remarks>
        /// <exclude/>
        IPoderosaPopupWindow CreatePopupView(PopupViewCreationParam viewcreation);

        //Reload
        /// <summary>
        /// <ja>
        /// j[[h܂B
        /// </ja>
        /// <en>
        /// Reload the menu.
        /// </en>
        /// </summary>
        void ReloadMenu();
        
        //Preferenceñ[h
        /// <summary>
        /// <ja>w肵AZuɊւ郆[U[ݒliPreferencejēǍ܂B</ja>
        /// <en>User setting value (Preference) concerning the specified assembly is read again. </en>
        /// </summary>
        /// <param name="preference"><ja>ēǍICoreServicePreference</ja><en>ICoreServicePreference to read again.</en></param>
        /// <overloads>
        /// <summary>
        /// <ja>
        /// [U[ݒliPreferencejēǍ܂B
        /// </ja>
        /// <en>
        /// User setting value (Preference) is read again. 
        /// </en>
        /// </summary>
        /// </overloads>
        void ReloadPreference(ICoreServicePreference preference);

        /// <summary>
        /// <ja>
        /// [U[ݒliPreferencejēǍ܂B
        /// </ja>
        /// <en>
        /// User setting value (Preference) is read again. 
        /// </en>
        /// </summary>
        void ReloadPreference();

        //Added for Bellagio
        void AddMainWindowMenu(string position_id, string extension_point_name, string text);

        void RefreshToolBar();
    }

    //AvŜɊ֌WAsystem.Windows.Forms
    /// <summary>
    /// 
    /// </summary>
    /// <exclude/>
    public interface IWinFormsService : IAdaptable {
        //Timer Support
        ITimerSite CreateTimer(int interval, TimerDelegate callback);

        //Drag & Drop
        object GetDraggingObject(IDataObject data, Type required_type);
        void BypassDragEnter(Control target, DragEventArgs args);
        void BypassDragDrop(Control target, DragEventArgs args);
    }

    //event handler
    public interface IMainWindowEventHandler : IAdaptable {
        void OnFirstMainWindowLoaded(IPoderosaMainWindow window);
        void OnMainWindowLoaded(IPoderosaMainWindow window);
        void OnMainWindowUnloaded(IPoderosaMainWindow window);
        void OnLastMainWindowUnloaded(IPoderosaMainWindow window);
        bool AskCancelClosingLastWindow(IPoderosaMainWindow window);
    }

    //File Drop : t@CȊOƂ͂܂Ȃ낤lȂB̂Ƃ͂܂ʂ̃C^tF[XŁB
    public interface IFileDropHandler : IAdaptable {
        bool CanAccept(ICommandTarget target, string[] filenames);
        void DoDropAction(ICommandTarget target, string[] filenames);
    }

    /// <summary>
    /// 
    /// </summary>
    /// <exclude/>
    public interface IViewManagerFactory : IAdaptable {
        IViewManager Create(IPoderosaMainWindow parent);
        IViewFactory DefaultViewFactory { get; set; }
    }

    /// <summary>
    /// <ja>
    /// PoderosãCEBhEC^[tFCXłB
    /// </ja>
    /// <en>
    /// Interface that show the main window of Poderosa.
    /// </en>
    /// </summary>
    /// <remarks>
    /// <ja>
    /// j[c[o[ĂяoR}hł́A^[Qbg̓CEBhEłB̂GetAdapter\bhĂяoƂŁAIPoderosaMainWindowւƕϊł܂B
    /// <code>
    /// // <var>target</var>̓R}hɈnꂽ^[QbgłƑz肵܂B
    /// IPoderosaMainWindow window = 
    ///     (IPoderosaMainWindow)target.GetAdapter(typeof(IPoderosaMainWindow));
    /// </code>
    /// ̓EBhE}l[Wi<seealso cref="IWindowManager">IWindowManager</seealso>j<see cref="IWindowManager.ActiveWindow">ActiveWindowvpeB</see>
    /// gāAANeBuȃEBhE擾邱Ƃł܂B
    /// <code>
    /// // cs<seealso cref="Poderosa.Plugins.ICoreServices">ICoreServices</seealso>ĂƑz肵܂B
    /// IPoderosaMainWindow mainwin = cs.WindowManager.ActiveWindow;
    /// </code>
    /// </ja>
    /// <en>
    /// In the command called from the menu and the toolbar, the target is the main window. Therefore, it is possible to convert it into IPoderosaMainWindow by calling the GetAdapter method. 
    /// <code>
    /// // It is assumed that <var>target</var> is a target handed over to the command. 
    /// IPoderosaMainWindow window = 
    ///     (IPoderosaMainWindow)target.GetAdapter(typeof(IPoderosaMainWindow));
    /// </code>
    /// Or, an active window can be acquired by using window manager(<seealso cref="IWindowManager">IWindowManager</seealso>)'s <see cref="IWindowManager.ActiveWindow">ActiveWindow property</see>. 
    /// <code>
    /// // cs is assumed that <seealso cref="Poderosa.Plugins.ICoreServices">ICoreServices</seealso> is shown. 
    /// IPoderosaMainWindow mainwin = cs.WindowManager.ActiveWindow;
    /// </code>
    /// </en>
    /// </remarks>
    public interface IPoderosaMainWindow : IPoderosaForm {
        /// <summary>
        /// <ja>
        /// r[}l[WԂ܂B
        /// </ja>
        /// <en>
        /// Return the view manager.
        /// </en>
        /// </summary>
        IViewManager ViewManager {
            get;
        }
        
        /// <summary>
        /// <ja>
        /// hLg^uIuWFNgԂ܂B
        /// </ja>
        /// <en>
        /// Return the object which show the document tab.
        /// </en>
        /// </summary>
        IDocumentTabFeature DocumentTabFeature {
            get;
        }
        /// <summary>
        /// <ja>
        /// c[o[IuWFNgԂ܂B
        /// </ja>
        /// <en>
        /// Return the object which show the toolbar.
        /// </en>
        /// </summary>
        IToolBar ToolBar {
            get;
        }

        /// <summary>
        /// <ja>
        /// Xe[^Xo[IuWFNgԂ܂B
        /// </ja>
        /// <en>
        /// Return the object which show the status bar.
        /// </en>
        /// </summary>
        IPoderosaStatusBar StatusBar {
            get;
        }

        /// <summary>
        /// <ja>
        /// ŌɃANeBuɂȂr[Ԃ܂B
        /// </ja>
        /// <en>
        /// Return the view that last active.
        /// </en>
        /// </summary>
        IContentReplaceableView LastActivatedView {
            get;
        }
    }

    /// <summary>
    /// <ja>
    /// |bvAbvEBhEC^[tFCXłB
    /// </ja>
    /// <en>
    /// Interface that shows pop up window.
    /// </en>
    /// </summary>
    public interface IPoderosaPopupWindow : IPoderosaForm {
        /// <summary>
        /// <ja>
        /// |bvAbvEBhẼr[܂B
        /// </ja>
        /// <en>
        /// The view in the pop up window is shown. 
        /// </en>
        /// </summary>
        IPoderosaView InternalView {
            get;
        }
        /// <summary>
        /// <ja>
        /// Xe[^XXV܂B
        /// </ja>
        /// <en>
        /// Update the status.
        /// </en>
        /// </summary>
        void UpdateStatus();
    }


    //TabBar
    /// <summary>
    /// <ja>
    /// CEBhẼhLg^u܂B
    /// </ja>
    /// <en>
    /// The document tab in the main window is shown. 
    /// </en>
    /// </summary>
    /// <remarks>
    /// <ja>
    /// ̃C^[tFCX́A<seealso cref="IPoderosaMainWindow">IPoderosaMainWindow</seealso>
    /// <see cref="IPoderosaMainWindow.DocumentTabFeature">DocumentTabFeaturevpeB</see>
    /// 擾ł܂B
    /// </ja>
    /// <en>
    /// This interface can be got from the <see cref="IPoderosaMainWindow.DocumentTabFeature">
    /// DocumentTabFeature property</see> of <seealso cref="IPoderosaMainWindow">IPoderosaMainWindow</seealso>. 
    /// </en>
    /// </remarks>
    public interface IDocumentTabFeature : IAdaptable {
        /// <summary>
        /// <ja>
        /// hLgǉ܂B
        /// </ja>
        /// <en>
        /// Add the document
        /// </en>
        /// </summary>
        /// <param name="document"><ja>ǉhLgłB</ja><en>Document to add.</en></param>
        void Add(IPoderosaDocument document);
        /// <summary>
        /// <ja>
        /// hLg폜܂B
        /// </ja>
        /// <en>
        /// Remove the document
        /// </en>
        /// </summary>
        /// <param name="document"><ja>폜hLgłB</ja><en>Document to remove.</en></param>
        void Remove(IPoderosaDocument document);
        /// <summary>
        /// <ja>
        /// hLgXV܂B
        /// </ja>
        /// <en>
        /// Update the document
        /// </en>
        /// </summary>
        /// <param name="document"><ja>XVhLgłB</ja><en>Document to be update.</en></param>
        void Update(IPoderosaDocument document);
        /// <summary>
        /// <ja>
        /// hLgANeBuɂ܂B
        /// </ja>
        /// <en>
        /// Activate the document
        /// </en>
        /// </summary>
        /// <param name="document"><ja>ANeBuɂhLgłB</ja><en>Document to active.</en></param>
        void Activate(IPoderosaDocument document);
        /// <summary>
        /// <ja>
        /// ANeBuȃhLgԂ܂B
        /// </ja>
        /// <en>
        /// Return the active document.
        /// </en>
        /// </summary>
        IPoderosaDocument ActiveDocument { get; }

        /// <summary>
        /// <ja>
        /// hLg̐Ԃ܂B
        /// </ja>
        /// <en>
        /// Return the conut of the document.
        /// </en>
        /// </summary>
        int DocumentCount { get; }
        /// <summary>
        /// <ja>
        /// wʒũhLgԂ܂B
        /// </ja>
        /// <en>
        /// Return the document at a specified position.
        /// </en>
        /// </summary>
        /// <param name="index"><ja>擾hLg̃CfbNXʒułB</ja><en>It is an index position of the document that wants to be got. </en></param>
        /// <returns><ja>hLg΂̃hLgAhLgȂꍇɂnull߂܂B</ja><en>Null returns in the document when there is no document if there is a document. </en></returns>
        IPoderosaDocument GetAtOrNull(int index);
        /// <summary>
        /// <ja>
        /// w肵hLg̃CfbNXʒuԂ܂B
        /// </ja>
        /// <en>
        /// Return the index position of the specified document.
        /// </en>
        /// </summary>
        /// <param name="document"><ja>CfbNXʒum肽hLg</ja><en>Document that wants to know index position</en></param>
        /// <returns><ja>hLg΂̃hLgʒuBhLgȂꍇɂ-1߂܂B</ja><en>It is the document position if there is a document. -1 returns when the document is not found. </en></returns>
        int IndexOf(IPoderosaDocument document);

        //^u֌W
        int TabRowCount { get; }
        void SetTabRowCount(int count);
    }

    //StatusBar
    /// <summary>
    /// <ja>
    /// Xe[^Xo[܂B
    /// </ja>
    /// <en>
    /// The status bar is shown. 
    /// </en>
    /// </summary>
    public interface IPoderosaStatusBar {
        /// <summary>
        /// <ja>
        /// Xe[^Xo[̃eLXgݒ肵܂B
        /// </ja>
        /// <en>
        /// The text of the status bar is set. 
        /// </en>
        /// </summary>
        /// <param name="msg"><ja>ݒ肷eLXg</ja><en>Text to set.</en></param>
        void SetMainText(string msg);
        /// <summary>
        /// <ja>Xe[^Xo[̃ACRݒ肵܂B</ja><en>Set the icon of the status bar.</en>
        /// </summary>
        /// <param name="icon"><ja>ݒ肷ACR</ja><en>Icon to set.</en></param>
        void SetStatusIcon(Image icon);
    }


    //Timer Suppoer
    /// <summary>
    /// 
    /// </summary>
    /// <exclude/>
    public delegate void TimerDelegate();

    /// <summary>
    /// 
    /// </summary>
    /// <exclude/>
    public interface ITimerSite {
        void Close();
    }

    /// <summary>
    /// <ja>
    /// ܂B
    /// </ja>
    /// <en>
    /// The language is shown. 
    /// </en>
    /// </summary>
    [EnumDesc(typeof(Language))]
    public enum Language {
        /// <summary>
        /// <ja>
        /// p</ja>
        /// <en>
        /// English</en>
        /// </summary>
        [EnumValue(Description="Enum.Language.English")]
        English,
        /// <summary>
        /// <ja>{</ja>
        /// <en>Japanese</en>
        /// </summary>
        [EnumValue(Description="Enum.Language.Japanese")]
        Japanese
    }


    /// <exclude/>
    public interface IWindowPreference {
        int WindowCount { get; }
        //Window
        string WindowPositionAt(int index);
        string WindowSplitFormatAt(int index);
        string ToolBarFormatAt(int index);
        int TabRowCountAt(int index);
    }

    //̃AZuPreference
    /// <summary>
    /// <ja>
    /// ̃AZuPreference܂B
    /// </ja>
    /// <en>
    /// The Preference in this assembly is shown.
    /// </en>
    /// </summary>
    /// <exclude/>
    public interface ICoreServicePreference {
        //S̋
        bool ShowsToolBar { get; set; }
        Keys ViewSplitModifier { get; set; }
        int CaretInterval { get; set; }
        bool AutoCopyByLeftButton { get; set; }

        //GUI
        int SplitLimitCount { get; }

        //IύX\
        Language Language { get; set; }
    }

    //PopupView쐬p[^
    /// <summary>
    /// <ja>
    /// PopupView쐬ۂ̃p[^ƂȂIuWFNgłB
    /// </ja>
    /// <en>
    /// Object that becomes parameter when PopupView is made.
    /// </en>
    /// </summary>
    /// <remarks>
    /// <ja>
    /// ̃p[^́A<seealso cref="IWindowManager">IWindowManager</seealso>
    /// <see cref="IWindowManager.CreatePopupView">CreatePopupView\bh</see>̈ƂĎg܂B
    /// </ja>
    /// <en>
    /// This parameter is used as an argument of the <see cref="IWindowManager.CreatePopupView">CreatePopupView method</see> of <seealso cref="IWindowManager">IWindowManager</seealso>. 
    /// </en>
    /// </remarks>
    /// <exclude/>
    public class PopupViewCreationParam {
        private IViewFactory _viewFactory;
        private Size _initialSize;
        private bool _ownedByCommandTargetWindow;
        private bool _showInTaskBar;

        public PopupViewCreationParam(IViewFactory factory) {
            _viewFactory = factory;
            _initialSize = new Size(300, 300);
        }

        public IViewFactory ViewFactory {
            get {
                return _viewFactory;
            }
            set {
                _viewFactory = value;
            }
        }
        public Size InitialSize {
            get {
                return _initialSize;
            }
            set {
                _initialSize = value;
            }
        }
        public bool OwnedByCommandTargetWindow {
            get {
                return _ownedByCommandTargetWindow;
            }
            set {
                _ownedByCommandTargetWindow = value;
            }
        }
        public bool ShowInTaskBar {
            get {
                return _showInTaskBar;
            }
            set {
                _showInTaskBar = value;
            }
        }
    }


}
