using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;

namespace Travis.Forms {
    //XN[o[zXeBOB炵CxgoȂALargeChandê悤ȃvpeB̊ȗ_
    //H/BScrollBar̗gȂ߁AControl͔hȂBRg[ƂĎgꍇAsControlg
    public class TravisScrollBar {
        //XN[o[Ŝ̋ƂĂȂ̂A
        //  Maximum - LargeChange + 1  [U̐ݒłValue̍őlł邱

        private int _viewSize;
        private int _totalSize;
        private bool _valueChangeBlock;
        private ScrollBar _scrollBar;

        public event EventHandler ScrollValueUIChanged;

        public TravisScrollBar(ScrollBar sb, DockStyle dc) {
            _scrollBar = sb;
            _scrollBar.Dock = dc;
            _scrollBar.ValueChanged += new EventHandler(OnValueChanged);
        }

        public Control AsControl {
            get {
                return _scrollBar;
            }
        }

        public int ViewSize {
            get {
                return _viewSize;
            }
        }
        public int TotalSize {
            get {
                return _totalSize;
            }
        }

        public int ScrollPosition {
            get {
                if(_totalSize <= _viewSize)
                    return 0;
                else
                    return _scrollBar.Value;
            }
        }
        //I[̒l
        public int ScrollEndPosition {
            get {
                if(_totalSize <= _viewSize)
                    return _totalSize-1;
                else
                    return _scrollBar.Value + _viewSize - 1;
            }
        }
        public int ScrollMaximum {
            get {
                if(_totalSize <= _viewSize)
                    return 0;
                else
                    return _totalSize - _viewSize;
            }
        }
        public bool ScrollAllVisible {
            get {
                return _totalSize <= _viewSize;
            }
        }


        private void OnValueChanged(object sender, EventArgs e) {
            if(!_valueChangeBlock) {
                //Debug.WriteLine("OnValueChange " + _scrollBar.Value);
                if(this.ScrollValueUIChanged!=null)
                    this.ScrollValueUIChanged(this, e);
            }
        }

        //Stotalsizêviewsize܂Ō邱ƂłƂݒ
        public void SetRange(int viewsize, int totalsize) {
            Debug.Assert(totalsize >= 0);
            Debug.Assert(viewsize >= 0);

            int prev_value = this.ScrollPosition;
            bool prev_latest = prev_value == this.ScrollMaximum; //E[ɂĂB AllVisiblêƂ͏trueɂȂ̂Œ

            //̂ƍőlݒ肵ƂValue  totalsize - viewsizeł邩A
            //totalsize - viewsize = Maximum - viewsize + 1A܂Maximum = totalsize-1
            _viewSize = viewsize;
            _totalSize = totalsize;
            _valueChangeBlock = true;

            if(totalsize <= viewsize) { //S
                _scrollBar.Enabled = false;
                _scrollBar.Value = 0;
            }
            else {
                _scrollBar.Enabled = true;
                _scrollBar.Maximum = totalsize-1;
                _scrollBar.LargeChange = viewsize;
            }

            //Ƃƍől炻ێAłȂΒlۑ
            if(prev_latest)
                SetValueToMaximum();
            else if(!this.ScrollAllVisible)
                _scrollBar.Value = Math.Min(prev_value, this.ScrollMaximum);
                
            _valueChangeBlock = false;
        }

        public void SetValueToMaximum() {
            if(!this.ScrollAllVisible) {
                _valueChangeBlock = true;
                _scrollBar.Value = _totalSize - _viewSize;
                _valueChangeBlock = false;
            }
        }
        public void SetValueToMaximumWithEvent() {
            if(!this.ScrollAllVisible) {
                _scrollBar.Value = _totalSize - _viewSize;
            }
        }
        public void SetScrollPosition(int value) {
            Debug.Assert(value>=0);
            Debug.Assert(value<=this.ScrollMaximum);
            if(!this.ScrollAllVisible) {
                _valueChangeBlock = true;
                _scrollBar.Value = value;
                _valueChangeBlock = false;
            }
        }
        public void SetScrollPositionWithEvent(int value) {
            Debug.Assert(value>=0);
            Debug.Assert(value<=this.ScrollMaximum);
            if(!this.ScrollAllVisible) {
                _scrollBar.Value = value;
            }
        }
        //E[̒lw肵ăZbg
        public void SetScrollPositionByRight(int value) {
            Debug.Assert(value>=0);
            Debug.Assert(value< _totalSize);
            if(!this.ScrollAllVisible) {
                value = value - _viewSize + 1;
                if(value<0) value = 0;
                _valueChangeBlock = true;
                _scrollBar.Value = value;
                _valueChangeBlock = false;
            }
        }
        public void Dispose() {
            _scrollBar.Dispose();
        }
    }

    public class TravisHScrollBar : TravisScrollBar {
        public TravisHScrollBar()
            : base(new HScrollBar(), DockStyle.Bottom) {
        }
    }
    public class TravisVScrollBar : TravisScrollBar {
        public TravisVScrollBar()
            : base(new VScrollBar(), DockStyle.Right) {
        }
    }
}
