﻿/*
 * Copyright (c) 2008  Lagarto Technology, Inc.
 * 
 * $Id$
 * $DateTime$
 * 
 */
#if UNITTEST
using System;
using NUnit.Framework;
using System.Reflection;
using System.Security.Permissions;
using System.Drawing;
using System.Windows.Forms;

namespace Travis.ObjectPeepHole {
    [TestFixture]
    public class ObjectPeepHoleBuilderTests {

        [Test]
        public void Property() {
            TestTarget obj = new TestTarget("qwerty");
            ITesterProperty tester = (ITesterProperty)new PeepHoleBuilder(typeof(TestTarget), typeof(ITesterProperty)).CreateAccessor(obj);
            string name = tester.Name;
            Assert.AreEqual("qwerty", name);
            tester.Name = "zzz";
            Assert.AreEqual("zzz", tester.Name);
        }
        [Test]
        public void PropertyBox() {
            TestTarget obj = new TestTarget("qwerty");
            ITesterPropertyBox tester = (ITesterPropertyBox)new PeepHoleBuilder(typeof(TestTarget), typeof(ITesterPropertyBox)).CreateAccessor(obj);
            tester.Rect = new Rectangle(10, 20, 30, 40);
            Assert.AreEqual(new Rectangle(10, 20, 30, 40), tester.Rect);
        }
        [Test]
        public void NoArg() {
            TestTarget obj = new TestTarget("qwerty");
            ITesterNoArg tester = (ITesterNoArg)new PeepHoleBuilder(typeof(TestTarget), typeof(ITesterNoArg)).CreateAccessor(obj);
            Assert.AreEqual("qwertyqwerty", tester.NoArg());
            //Assert.AreEqual(300, tester.Method2(3));
        }
        [Test]
        public void ConcatString() {
            TestTarget obj = new TestTarget("qwerty");
            ITesterArgs tester = (ITesterArgs)new PeepHoleBuilder(typeof(TestTarget), typeof(ITesterArgs)).CreateAccessor(obj);
            Assert.AreEqual("qwertyAAA", tester.ConcatString1("AAA"));
            Assert.AreEqual("qwertyAAABBB", tester.ConcatString2("AAA", "BBB"));
        }
        [Test]
        public void Void() {
            TestTarget obj = new TestTarget("");
            ITesterVoid tester = (ITesterVoid)new PeepHoleBuilder(typeof(TestTarget), typeof(ITesterVoid)).CreateAccessor(obj);
            tester.Void();
        }
        [Test]
        public void Box() {
            TestTarget obj = new TestTarget("qqq");
            ITesterBox tester = (ITesterBox)new PeepHoleBuilder(typeof(TestTarget), typeof(ITesterBox)).CreateAccessor(obj);
            Assert.AreEqual(7, tester.Box1(4));
            Assert.AreEqual(15, tester.Box2(3, 4));

            //rectangle
            Assert.AreEqual(new Rectangle(10, 10, 40, 40), tester.Box3(new Rectangle(10, 10, 20, 20)));
        }
        [Test]
        public void Ref() {
            int n = 6;
            TestTarget obj = new TestTarget("abc");
            ITesterRef tester = (ITesterRef)new PeepHoleBuilder(typeof(TestTarget), typeof(ITesterRef)).CreateAccessor(obj);
            tester.Ref1(ref n);
            Assert.AreEqual(12, n);

            string r;
            tester.Ref2(out r);
            Assert.AreEqual("abcabc", r);
        }
        [Test]
        public void Enum() {
            TestTarget obj = new TestTarget("abc");
            ITesterEnum tester = (ITesterEnum)new PeepHoleBuilder(typeof(TestTarget), typeof(ITesterEnum)).CreateAccessor(obj);
            TestEnum e = TestEnum.V0;
            Assert.AreEqual(TestEnum.V1, tester.Enum(e));
        }

        [Test]
        public void StaticProperty() {
            TestTarget obj = new TestTarget("qwerty");
            ITesterPropertyStatic tester = (ITesterPropertyStatic)new PeepHoleBuilder(typeof(TestTarget), typeof(ITesterPropertyStatic)).CreateAccessor(obj);
            Assert.AreEqual(99, tester.StaticField);
        }
        [Test]
        public void StaticMethod() {
            TestTarget obj = new TestTarget("");
            IStaticMethod tester = (IStaticMethod)new PeepHoleBuilder(typeof(TestTarget), typeof(IStaticMethod)).CreateAccessor(obj);
            Assert.AreEqual(200, tester.StaticMethod(101));
        }
        [Test]
        public void TargetEvent() {
            EventTestTarget obj = new EventTestTarget();
            EventArgs args1 = new EventArgs();
            bool called = false;
            obj.TestEvent += delegate(object sender, EventArgs args) {
                called = true;
                Assert.AreSame(obj, sender);
                Assert.AreSame(args1, args);
            };
            ITargetEventFire tester = (ITargetEventFire)new PeepHoleBuilder(typeof(EventTestTarget), typeof(ITargetEventFire)).CreateAccessor(obj);
            tester.FireTestEvent(args1);
            Assert.IsTrue(called);

            called = false;
            tester.FireTestEvent(obj, args1); //unuse implicit sender
            Assert.IsTrue(called);
        }
        [Test]
        public void ButtonEvent() {
            EventTestTarget obj = new EventTestTarget();
            EventArgs args1 = new EventArgs();
            bool called = false;
            obj._button.Click += delegate(object sender, EventArgs args) {
                called = true;
                Assert.AreSame(obj._button, sender);
                Assert.AreSame(args1, args);
            };
            IButtonEventFire tester = (IButtonEventFire)new PeepHoleBuilder(typeof(EventTestTarget), typeof(IButtonEventFire)).CreateAccessor(obj);
            tester.FireButton_Click(args1);
            Assert.IsTrue(called);

            called = false;
            tester.FireButton_Click(obj._button, args1); //unuse implicit sender
            Assert.IsTrue(called);
        }
        [Test]
        public void TreeViewEvent() {
            EventTestTarget obj = new EventTestTarget();
            NodeLabelEditEventArgs args1 = new NodeLabelEditEventArgs(null);
            bool called = false;
            obj._treeView.AfterLabelEdit += delegate(object sender, NodeLabelEditEventArgs args) {
                called = true;
                Assert.AreSame(obj._treeView, sender);
                Assert.AreSame(args1, args);
            };
            ITreeViewEventFire tester = (ITreeViewEventFire)new PeepHoleBuilder(typeof(EventTestTarget), typeof(ITreeViewEventFire)).CreateAccessor(obj);
            tester.FireTreeView_AfterLabelEdit(args1);
            Assert.IsTrue(called);

            called = false;
            tester.FireTreeView_AfterLabelEdit(obj._treeView, args1); //unuse implicit sender
            Assert.IsTrue(called);
        }

        public void ILTestStruct(ref Rectangle rc1, out Rectangle rc2) {
            int n = rc1.Height;
            object q = rc1;
            rc2 = rc1;
            Rectangle rc3 = (Rectangle)q;
        }
    }

    public interface ITesterProperty {
        string Name { get; set; }
    }
    public interface ITesterPropertyBox {
        Rectangle Rect { get; set; }
    }
    public interface ITesterPropertyStatic {
        int StaticField { get; }
    }
    public interface ITesterNoArg {
        string NoArg();
    }
    public interface ITesterArgs {
        string ConcatString1(string a);
        string ConcatString2(string a,string b);
    }
    public interface ITesterVoid {
        void Void();
    }
    public interface ITesterBox {
        int Box1(int i);
        int Box2(int i, int j);
        Rectangle Box3(Rectangle r);
    }
    public interface ITesterRef {
        void Ref1(ref int x);
        void Ref2(out string n);
    }
    public interface ITesterEnum {
        TestEnum Enum(TestEnum v);
    }
    public interface IStaticMethod {
        int StaticMethod(int a);
    }


    public enum TestEnum {
        V0, V1
    }
    public class TestTarget {
        private string _name   ;
        private static int _staticField;
        //private Rectangle _rect;

        public TestTarget(string name) {
            _name = name;
            _staticField = 99;
        }

        private string NoArg() {
            return _name+_name;
        }
        private string ConcatString1(string a) {
            return _name+a;
        }
        private string ConcatString2(string a, string b) {
            return _name+a+b;
        }
        private void Void() {
        }

        private int Box1(int i) {
            return _name.Length + i;
        }
        private int Box2(int i, int j) {
            return _name.Length + i * j;
        }
        private Rectangle Box3(Rectangle r) {
            return new Rectangle(r.X, r.Y, r.Width*2, r.Height*2);
        }

        private void Ref1(ref int x) {
            x = x * 2;
        }
        private void Ref2(out string x) {
            x = _name + _name;
        }

        private TestEnum Enum(TestEnum v) {
            return (TestEnum)(v+1);
        }
        private static int StaticMethod(int n) {
            return _staticField + n;
        }

    }

    public interface ITargetEventFire {
        void FireTestEvent(EventArgs args);
        void FireTestEvent(object sender, EventArgs args);
    }
    public interface IButtonEventFire {
        void FireButton_Click(EventArgs args);
        void FireButton_Click(object sender, EventArgs args);
    }
    public interface ITreeViewEventFire {
        void FireTreeView_AfterLabelEdit(NodeLabelEditEventArgs e);
        void FireTreeView_AfterLabelEdit(object sender, NodeLabelEditEventArgs e);
    }

    public class EventTestTarget {
        //events
        public event EventHandler TestEvent;
        public Button _button; //key使用のイベント
        public TreeView _treeView; //field使用のイベント

        public EventTestTarget() {
            _button = new Button();
            _treeView = new TreeView();
        }

        private void FireEvent() {
            TestEvent(this, new EventArgs());
        }
    }
}
#endif
