/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Travis/FileUtil.cs#3 $
 * $DateTime$
 * 
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;
using System.IO;

namespace Travis.IO {
    public class FileUtil {
        public static byte[] ReadAllFile(string filename) {
            FileInfo fi = new FileInfo(filename);
            int len = (int)fi.Length;
            if(len > 0x10000000) throw new IOException("too big file");

            return ReadFileHead(filename, len);
        }
        public static byte[] ReadFileHead(string filename, int len) {
            byte[] buf = new byte[len];
            FileStream fs = new FileStream(filename, FileMode.Open);
            try {
                int read = 0;
                while(read < len) {
                    read += fs.Read(buf, read, len - read);
                }
                Debug.Assert(read==len);
                return buf;
            }
            finally {
                fs.Close();
            }

        }
        //t@C̓eSǂŕƂĕԂB܂łt@CɎgׂł͂Ȃ
        public static string ReadAllFileAsString(string filename) {
            return Encoding.Default.GetString(ReadAllFile(filename));
        }

        public static byte[] ReadAllStream(Stream strm, int len) {
            byte[] buf = new byte[len];
            int read = 0;
            while(read < len) {
                read += strm.Read(buf, read, len - read);
            }
            Debug.Assert(read==len);
            return buf;
        }

    }


}
