/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Ordering/OrderingPlugin.cs#16 $
 * $DateTime: 2008/05/14 13:05:12 $
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.IO;

using Poderosa.Plugins;
using Poderosa.Commands;
using Poderosa.Forms;

using Bellagio.Common;

[assembly: PluginDeclaration(typeof(Bellagio.Ordering.OrderingPlugin))]

namespace Bellagio.Ordering {

    [PluginInfo(ID=OrderingPlugin.PLUGIN_ID, Version=BellagioVersionInfo.PLUGIN_VERSION, Author=BellagioVersionInfo.AUTHOR_NAME, Dependencies="jp.co.lagarto.tactico.chart")]
    public class OrderingPlugin : PluginBase {
        public const string PLUGIN_ID = "jp.co.lagarto.tactico.ordering";

        private static OrderingPlugin _instance;
        public static OrderingPlugin Instance {
            get {
                return _instance;
            }
        }

        private OrderingToolBar _toolBar;
        private OrderingCommands _commands;

        private ICommandManager _commandManager;
        private static IconList _orderingIcons;

        public override void InitializePlugin(IPoderosaWorld poderosa) {
            base.InitializePlugin(poderosa);
            _instance = this;

            ICoreServices cs = (ICoreServices)poderosa.GetAdapter(typeof(ICoreServices));

            _commandManager = cs.CommandManager;
            
            _commands = new OrderingCommands(_commandManager);
            _toolBar = new OrderingToolBar();
            poderosa.PluginManager.FindExtensionPoint(WindowManagerConstants.TOOLBARCOMPONENT_ID).RegisterExtension(_toolBar);

            IExtensionPoint panel = poderosa.PluginManager.FindExtensionPoint("org.poderosa.optionpanel");
            panel.RegisterExtension(new OrderingOptionPanelExtension());
            panel.RegisterExtension(new OrderingAndPoisitionOptionPanelExtension());
            //{BellagioPluginGeneralOptionPanelo^ׂA͍Ō̃plƂĕ\Ăق̂łڂĂœo^Ă܂B
            panel.RegisterExtension(new Bellagio.Environment.GeneralOptionPanelExtension());

        }

        public OrderingCommands Commands {
            get {
                return _commands;
            }
        }

        public static IconList OrderingIcons {
            get {
                if(_orderingIcons==null) _orderingIcons = new IconList("Bellagio.Ordering.Icons", "Ordering", 32, 32);
                return _orderingIcons;
            }
        }
        /*
        public static IconList OrderingFormSmallIcons {
            get {
                if(_orderingFormSmallIcons==null) _orderingFormSmallIcons = new IconList("Bellagio.Ordering.Icons", "OrderFormSmallButtons", 16, 16);
                return _orderingFormIcons;
            }
        }
        */
    }

}
