/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Forms/ValueTranslation.cs#8 $
 * $DateTime: 2007/12/28 19:23:38 $
 * l̐wIϊBliWցAȂǁBOmegaChartR
 */
using System;
using System.Collections.Generic;
using System.Text;

namespace Bellagio.Forms {

    public abstract class AbstractValueTranslator {
        protected double _a;
        protected double _b;

        public AbstractValueTranslator(double a, double b) {
            _a = a;
            _b = b;
        }
        public double A {
            get {
                return _a;
            }
        }
        public double B {
            get {
                return _b;
            }
        }
        public abstract double Translate(double x);
        public abstract double Inverse(double y);
    }

    //y = ax + b ̕ϊ
    public class LinearTranslator : AbstractValueTranslator {
        public LinearTranslator(double a, double b)
            : base(a, b) {
        }
        public void Set(double a, double b) {
            _a = a;
            _b = b;
        }
        public void Set(LinearTranslator src) {
            _a = src._a;
            _b = src._b;
        }

        public override double Translate(double x) {
            return _a * x + _b;
        }
        public override double Inverse(double y) {
            return (y - _b) / _a;
        }

        //0Z␸x͂܂CɂAP
        public static LinearTranslator Solve(double x1, double y1, double x2, double y2) {
            double a = (y1 - y2) / (x1 - x2);
            return new LinearTranslator(a, y1 - a * x1);
        }
        public static LinearTranslator SolveUpsideDown(double x1, double y1, double x2, double y2) {
            double a = -(y1 - y2) / (x1 - x2);
            return new LinearTranslator(a, y1 - a * x2);
        }
    }

    // y = a * log(x) + b
    public class LogTranslation : AbstractValueTranslator {
        public LogTranslation(double a, double b)
            : base(a, b) {
        }
        public override double Translate(double x) {
            // {oȂǂ͂ݏoĂg~O
            if(x < 1)
                x = 1;
            return _a * Math.Log(x) + _b;
        }
        public override double Inverse(double y) {
            return Math.Exp((y - _b) / _a);
        }
        public static LogTranslation Solve(double x1, double y1, double x2, double y2) {
            // ̓̕g~O
            if(x2 < 1) {
                y2 = LinearTranslator.Solve(x1, y1, x2, y2).Translate(1);
                x2 = 1;
            }

            double a = (y1 - y2) / Math.Log(x1 / x2);
            double b = y1 - a * Math.Log(x1);

            return new LogTranslation(a, b);
        }
        public static LogTranslation SolveUpsideDown(double x1, double y1, double x2, double y2) {
            // ̓̕g~O
            if(x2 < 1) {
                y2 = LinearTranslator.Solve(x1, y1, x2, y2).Translate(1);
                x2 = 1;
            }

            double a = -(y1 - y2) / Math.Log(x1 / x2);
            double b = y1 - a * Math.Log(x2);

            return new LogTranslation(a, b);
        }
    }
}
