/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/FigureBoard/ItemDrawing.cs#9 $
 * $DateTime: 2008/02/22 14:41:12 $
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;
using System.Diagnostics;

using Bellagio.Drawing;
using Bellagio.Values;

namespace Bellagio.FigureBoard {
    //FigureBoard̗vf̕`ɊւNX
    //͔rIPȂ̂SettingñNXƂ܂Ƃ߂Ă܂
    public class FigureBoardItemDrawingSettings {
        public SmartColor borderColor;    //gF

        public SmartColor labelBackColor; //ȉxɂ
        public SmartColor labelColor;
        public Font labelFont;

        public SmartColor priceBackColor;
        public SmartColor priceColor;
        public SmartColor diffPlusColor;
        public SmartColor diffMinusColor;
        public Font priceFont;
        public Font diffFont;

        public float priceHeight;
        public float labelHeight;
        public float diffOffset;
        public float textLeft;
        public float textMoveHeight;
        public float textMargin;

        public float borderWidth = 1;

        public FigureBoardItemDrawingSettings() {
            borderColor.Set(Color.Gray);
            labelBackColor.Set(Color.MediumSeaGreen);
            labelColor.Set(Color.FromArgb(208, 255, 208));
            labelFont = new Font("MS UI Gothic", 10, FontStyle.Regular);
            priceBackColor.Set(Color.FromArgb(63, 88, 75));
            priceColor.Set(Color.White);
            priceFont = new Font("Courier", 9, FontStyle.Regular);
            diffPlusColor.Set(Color.Chartreuse);
            diffMinusColor.Set(Color.Red);
            diffFont = new Font("Courier", 9, FontStyle.Bold);

            textLeft = 2;
            textMoveHeight = 4;
            textMargin = 2;

        }

        public void CreateByGraphics(Graphics g) {
            SizeF l = g.MeasureString("A", labelFont);
            SizeF p = g.MeasureString("88888.00", priceFont);
            labelHeight = (l.Height+textMargin*2);
            priceHeight = (p.Height+textMargin*2);
            diffOffset = textLeft + p.Width + 8;
        }


    }


    public class FigureBoardItemDrawing {
        private FigureBoardItemDrawingSettings _settings;

        public FigureBoardItemDrawing() {
            _settings = new FigureBoardItemDrawingSettings();
        }

        public FigureBoardItemDrawingSettings Settings {
            get {
                return _settings;
            }
        }

        //progress01̒lŁAAj[V̐isx
        public void Draw(Graphics g, FigureBoardItem value, PointF pos, float width, float progress) {
            Pen borderPen = new Pen(_settings.borderColor.col, _settings.borderWidth);

            g.FillRectangle(_settings.labelBackColor.B, new RectangleF(pos.X+1, pos.Y+1, width-1, _settings.labelHeight-1));
            g.DrawRectangle(borderPen, pos.X, pos.Y, width, _settings.labelHeight);
            g.DrawString(value.Label, _settings.labelFont, _settings.labelColor.B, pos.X+_settings.textLeft, pos.Y+_settings.textMargin);

            g.FillRectangle(_settings.priceBackColor.B, new RectangleF(pos.X+1, pos.Y+_settings.labelHeight+1, width-1, _settings.priceHeight-1));
            g.DrawRectangle(borderPen, pos.X, pos.Y+_settings.labelHeight, width, _settings.priceHeight);

            borderPen.Dispose();

            double current_value = value.CurrentValue;
            string price = Double.IsNaN(current_value)? "-" : String.Format("{0,8:N2}", current_value); // 8 ͉ςłׂH

            float text_mod = (1-progress)*_settings.textMoveHeight;
            Color price_color = DrawingUtil.ProportionalColor(_settings.priceBackColor.col, _settings.priceColor.col, progress);
            SolidBrush price_br = new SolidBrush(price_color);
            g.DrawString(price, _settings.priceFont, price_br, pos.X+_settings.textLeft, pos.Y+_settings.labelHeight+_settings.textMargin-text_mod);
            price_br.Dispose();

            double diff = value.CurrentSubValue;
            if(!Double.IsNaN(diff)) {
                Color diff_color = DrawingUtil.ProportionalColor(_settings.priceBackColor.col, diff>=0? _settings.diffPlusColor.col : _settings.diffMinusColor.col, progress);
                SolidBrush diff_br = new SolidBrush(diff_color);
                g.DrawString(diff>=0? String.Format("+{0:N2}", diff) : String.Format("{0:N2}", diff),
                    _settings.diffFont, diff_br, pos.X+_settings.diffOffset, pos.Y+_settings.labelHeight+_settings.textMargin-text_mod);
                diff_br.Dispose();
                /*
                if(diff >= 0)
                    _diffPlusBrush.DrawText(g, String.Format("+{0:N2}", diff), animation_prog, diffFont, pos.X+diffOffset, pos.Y+labelHeight+_textMargin-text_mod);
                else
                    _diffMinusBrush.DrawText(g, String.Format("{0:N2}", diff), animation_prog, diffFont, pos.X+diffOffset, pos.Y+labelHeight+_textMargin-text_mod);
                 */
            }
        }
    }
}
