﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;
using System.Windows.Forms;
using System.Drawing;

using Bellagio.Forms;
using Bellagio.Values;
using Poderosa;

namespace Bellagio.ExternalData {
    public class ExternalDataStats : Form {
        private Label[] _statusTexts;
        private Button _okButton;
        private Button _updateAllButton;

        public ExternalDataStats() {
            FormUtil.AdjustStyleForModalDialog(this);
            this.Text = "スクリーニング/売買検証用外部データ";

            _updateAllButton = new Button();
            _updateAllButton.Text = "すべて更新";
            _updateAllButton.Click += new EventHandler(OnUpdateAll);

            _okButton = FormUtil.CreateOKButton();
            _okButton.Click += new EventHandler(OnOK);

            int y = 8;
            List<Label> statusTexts = new List<Label>();
            if(ExternalDataPlugin.Instance.ProviderHosts.Count==0) {
                _updateAllButton.Enabled = false;
                Label t = FormUtil.CreateLabelVT("有効な外部データソースはありません。\nこれは各種オーダーメイドサービス専用の機能です");
                t.Size = new Size(300, 48);
                t.Location = new Point(8, y);
                this.Controls.Add(t);
                y += 64;
            }
            else {
                foreach(ExternalDataHostBase host in ExternalDataPlugin.Instance.ProviderHosts) {
                    Label t = FormUtil.CreateLabelVT(host.Description);
                    t.Size = new Size(96, 19);
                    t.Location = new Point(8, y);
                    Label s = FormUtil.CreateLabelVT(FormatStatusText(host));
                    s.Size = new Size(192, 19);
                    s.Location = new Point(104, y);
                    this.Controls.Add(t);
                    this.Controls.Add(s);

                    y += 32;
                    statusTexts.Add(s);
                }
            }

            _updateAllButton.Location = new Point(128, y);
            _okButton.Location = new Point(216, y);
            this.Controls.Add(_updateAllButton);
            this.Controls.Add(_okButton);
            this.ClientSize = new Size(304, y+32);

            _statusTexts = statusTexts.ToArray();
        }

        private void OnOK(object sender, EventArgs args) {
            this.Close();
        }
        private void OnUpdateAll(object sender, EventArgs args) {
            try {
                _updateAllButton.Enabled = false;
                ExternalDataPlugin.Instance.ResetAll(delegate(ExternalDataHostBase dh, string msg) { UpdateStatusTexts(); });
                _updateAllButton.Enabled = true;
                BUtil.ShowInformationMessageBox("更新が完了しました");
                UpdateStatusTexts();
            }
            catch(Exception ex) {
                RuntimeUtil.ReportException(ex);
            }
        }
        private void UpdateStatusTexts() {
            Debug.Assert(BUtil.IsExecutingInMainThread); //LoadStatusDelegateからここに来ることもあるが、メインスレッドで実行していることを確認。
            int i = 0;
            foreach(ExternalDataHostBase host in ExternalDataPlugin.Instance.ProviderHosts) {
                _statusTexts[i++].Text = FormatStatusText(host);
            }
        }

        private string FormatStatusText(ExternalDataHostBase host) {
            if(host.ElementCount==0)
                return "データなし";
            else
                return String.Format("{0}まで取得済(全{1}件)", BDate.FormatYYMMDD(host.LastDataDate), host.ElementCount);
        }
    }
}
