/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Data/MarketUtil.cs#16 $
 * $DateTime: 2008/05/14 13:05:12 $
 * 
 * s̒萔Ɋւ
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;

using Poderosa.Util;

using BTime=Bellagio.Values.BTime;
using BDate=Bellagio.Values.BDate;

namespace Bellagio.Data {
    [EnumDesc(typeof(StockExchange))]
    public enum StockExchange {
        [EnumValue(Description="")]
        None, 
        [EnumValue(Description="w")]
        B, //wAבւȂ
        
        [EnumValue(Description="")]
        T,
        [EnumValue(Description="")]
        O,
        [EnumValue(Description="JQ")]
        J,

        [EnumValue(Description="HC")]
        Hercules, //GMOŗLȂA[Ȍ`

        //}Ci[Ȃ̂̓tl[
        [EnumValue(Description="")]
        Nagoya,
        [EnumValue(Description="")]
        Fukuoka,
        [EnumValue(Description="D")]
        Sapporo,
        
        [EnumValue(Description="PTS")]
        PTS
    }

    //s̉̋敪 ɂLȒl͈قȂ
    [EnumDesc(typeof(StockExchangeSubType))]
    public enum StockExchangeSubType {
        [EnumValue(Description="N/A")]
        None,
        [EnumValue(Description="")]
        Generic,
        [EnumValue(Description="ꕔ")]
        Ichibu,
        [EnumValue(Description="")]
        Nibu,
        [EnumValue(Description="qdhs")]
        REIT,
        [EnumValue(Description="dse")]
        ETF,

        //VsQ
        [EnumValue(Description="}U[Y")]
        Mothers,
        [EnumValue(Description="X^_[h")]
        HerculesStandard,
        [EnumValue(Description="O[X")]
        HerculesGrowth,
        [EnumValue(Description="ZgbNX")]
        Centrex,
        [EnumValue(Description="p{[h")]
        QBoard,
        [EnumValue(Description="ArVX")]
        Ambitious,
        [EnumValue(Description="mdn")]
        NEO,

    }

    [Flags]
    public enum StockProfileFlags {
        None = 0,

        F1 = 1, //f[^1/10ɂĕ\ׂ́BTOPIX敨Ȃ
        F2 = 2, //f[^1/100ɂĕ\ׂ́BoρAבւȂ
        FigureMask = F1|F2,

        Future = 8, //敨
        Option = 16, //IvV
        DerivativeMask = Future | Option,
        Currency = 32, //ʉ

        Hidden = 0x100, //ʏ͕\ȂB݂̂̐敨f[^ȂǁAɕKvȗvfY
        Combined = 0x200, //̖̃f[^ď߂ē^CvB
        Transient = 0x400, //}X^Ɋ܂܂Ȃ

        Nikkei225 = 0x800,  //oύ̗p

        IgnoreVolume = 0x1000 //of[^͂ȂĂ\Ȃ
    }
    [Flags]
    public enum StockFlags {
        None = 0,
        Foreign = 1,  //O
        MarketMake = 2, //MM

        Taisyaku=8,   //ݎؖB󔄂\
        Seido=16,      //xMpΏ
        Ippan=32,      //ʐMpΏ
        ShinyoMask=Taisyaku|Seido|Ippan,

        Obsolete=1024  //p~
    }

    //Ǝ
    [EnumDesc(typeof(MarketSectors))]
    public enum MarketSectors {
        [EnumValue(Description="s")]
        UNKNOWN,

        [EnumValue(Description="YE_")]
        FISHING,
        [EnumValue(Description="z")]
        MINING,
        [EnumValue(Description="")]
        CONSTRUCTION,
        [EnumValue(Description="Hi")]
        FOOD,

        [EnumValue(Description="@")]
        FABRIC,
        [EnumValue(Description="pvE")]
        PULP,
        [EnumValue(Description="w")]
        CHEMICAL,
        [EnumValue(Description="")]
        MEDICAL,

        [EnumValue(Description="ΖEΒY")]
        OIL,
        [EnumValue(Description="S")]
        RUBBER,
        [EnumValue(Description="KXEy")]
        CERAMIC,
        [EnumValue(Description="S|")]
        IRON,

        [EnumValue(Description="S")]
        NONEMETAL,
        [EnumValue(Description="")]
        METAL,
        [EnumValue(Description="@B")]
        MACHINE,
        [EnumValue(Description="dC@")]
        ELECTRIC,

        [EnumValue(Description="Ap@")]
        FREIGHTER_MACHINE,
        [EnumValue(Description="")]
        PRECISIONS,
        [EnumValue(Description="")]
        MANIFUCTURING,
        [EnumValue(Description="dCEKX")]
        GAS,

        [EnumValue(Description="^")]
        LANDTRANSPORT,
        [EnumValue(Description="C^")]
        MARINETRANSPORT,
        [EnumValue(Description="^")]
        AIRTRANSPORT,
        [EnumValue(Description="q")]
        STORAGE,

        [EnumValue(Description="EʐM")]
        COMMUNICATION,
        [EnumValue(Description="")]
        TRADEFARM,
        [EnumValue(Description="")]
        RETAIL,
        [EnumValue(Description="s")]
        BANK,

        [EnumValue(Description="،")]
        SECURITY,
        [EnumValue(Description="ی")]
        INSUARANCE,
        [EnumValue(Description="Z")]
        FINANCE,
        [EnumValue(Description="sY")]
        REALESTATES,

        [EnumValue(Description="T[rX")]
        SERVICE,

    }

    public static class PublicMarketUtil {
        public static bool IsMarketOpenDate(DateTime dt) {
            if(dt.DayOfWeek==DayOfWeek.Sunday || dt.DayOfWeek==DayOfWeek.Saturday) return false;

            int y = dt.Year;
            int m = dt.Month;
            int d = dt.Day;
            if(IsHoliday(y, m, d, false))
                return false;
            else if(dt.DayOfWeek==DayOfWeek.Monday) {
                if(IsHoliday(y, m, d, true)) //j̓j
                    return false;
                else if(IsHoliday(y, m, d-1, false))
                    return false; //Uւx
            }

            return true;
        }
        public static bool IsHoliday(int year, int month, int day, bool monday) {
            //tEH͖{͔NɂႤB̃[1992N`2011N܂ł͐ƂmFς
            Debug.Assert(year>=1990 && year<=2011);
            switch(month) {
                case 1:
                    return day==1 || day==2 || day==3 || (monday && 8<=day && day<=14);
                case 2:
                    return day==11;
                case 3: {
                        int yy = year % 4;
                        if(day==20)
                            return yy==0 || yy==1;
                        else if(day==21)
                            return yy==2 || yy==3;
                        else
                            return false;
                    }
                case 4:
                    return day==29;
                case 5:
                    return (3<=day && day<=5) || (day==6 && year==2008); //2008/5/6͐U֏j̓
                case 7:
                    return monday && 15<=day && day<=21;
                case 9:
                    return (monday && 15<=day && day<=21) || day==23;
                case 10:
                    return monday && 8<=day && day<=14;
                case 11:
                    return day==3 || day==23;
                case 12:
                    return day==23 || day==31; //31͏jł͂ȂAs͋x
                default:
                    return false;
            }
        }
    }

    public static class MarketUtil {
        public static int ItaSize(Stock stock) {
            return 5;
        }
        public static int YobineIncrement(Stock stock, int price) {
            if(stock!=null && (stock.Profile is DerivativeStockProfile))
                return price + GetDerivativeYobine((DerivativeStockProfile)stock.Profile);
            else
                return YobineIncrement(price);
        }
        public static int YobineIncrement(int price) {
            if(price < 2000)
                return price+1;
            else if(price < 3000)
                return AdjustYobinePrice(price+5, 5);
            else if(price < 10000)
                return AdjustYobinePrice(price+10, 10);
            else if(price < 30000)
                return AdjustYobinePrice(price+50, 50);
            else if(price < 300000)
                return AdjustYobinePrice(price+100, 100);
            else if(price < 3000000)
                return AdjustYobinePrice(price+1000, 1000);
            else if(price < 20000000)
                return AdjustYobinePrice(price+10000, 10000);
            else if(price < 30000000)
                return AdjustYobinePrice(price+50000, 50000);
            else
                return AdjustYobinePrice(price+100000, 100000);
        }
        public static int YobineDecrement(int price) {
            if(price <= 2000)
                return price-1;
            else if(price <= 3000)
                return AdjustYobinePrice(price-5, 5);
            else if(price <= 10000)
                return AdjustYobinePrice(price-10, 10);
            else if(price <= 30000)
                return AdjustYobinePrice(price-50, 50);
            else if(price <= 300000)
                return AdjustYobinePrice(price-100, 100);
            else if(price <= 3000000)
                return AdjustYobinePrice(price-1000, 1000);
            else if(price <= 20000000)
                return AdjustYobinePrice(price-10000, 10000);
            else if(price <= 30000000)
                return AdjustYobinePrice(price-50000, 50000);
            else
                return AdjustYobinePrice(price-100000, 100000);
        }
        private static int AdjustYobinePrice(int price, int yobine) {
            return price - (price % yobine);
        }
        public static int AdjustNearestYobine(int price) {
            if(price <= 2000)
                return price;
            else if(price <= 3000)
                return AdjustYobinePrice(price+3, 5);
            else if(price <= 10000)
                return AdjustYobinePrice(price+5, 10);
            else if(price <= 30000)
                return AdjustYobinePrice(price+25, 50);
            else if(price <= 300000)
                return AdjustYobinePrice(price+50, 100);
            else if(price <= 3000000)
                return AdjustYobinePrice(price+500, 1000);
            else if(price <= 20000000)
                return AdjustYobinePrice(price+5000, 10000);
            else if(price <= 30000000)
                return AdjustYobinePrice(price+25000, 50000);
            else
                return AdjustYobinePrice(price+50000, 100000);
        }
        public static int AdjustNearestYobine(Stock stock, int price) {
            DerivativeStockProfile prof = stock==null? null : (stock.Profile as DerivativeStockProfile);
            if(prof!=null) {
                int yobine = GetDerivativeYobine(prof);
                return AdjustYobinePrice(price+yobine/2, yobine);
            }
            else
                return AdjustNearestYobine(price);
                
        }
        public static int GetDerivativeYobine(DerivativeStockProfile pf) {
            DerivativeStockProfile.BrandT br = pf.Brand;
            return br==DerivativeStockProfile.BrandT.NikkeiFuture? 10 : 5;
        }

        //悭oꂷ鎞萔 
        public static BTime time0430 = new BTime(4,30, 0);
        public static BTime time0700 = new BTime(7, 0, 0);
        public static BTime time0900 = new BTime(9, 0, 0);
        public static BTime time1100 = new BTime(11, 0, 0);
        public static BTime time1110 = new BTime(11,10, 0);
        public static BTime time1230 = new BTime(12,30, 0);
        public static BTime time1500 = new BTime(15, 0, 0);
        public static BTime time1510 = new BTime(15,10, 0);

        //Bellagioł́ACujOZbV0430~0700ɍsĂ̂Ƃăf[^擾B
        //ʂɕ\Ƃɂ͂߂1630~1900̎ɕϊĕ\BłȂƎ̏֌Ẅێ

        //O܂͌̊JnEI
        //TODO ̂܂܂Ƒ唭E[͒PɃf[^̗ȂAƂƂɂȂ
        public static BTime GetZenbaOpenTime(StockExchange m) {
            return time0900;
        }
        public static BTime GetZenbaCloseTime(StockExchange m) {
            return time1100;
        }
        public static BTime GetGobaOpenTime(StockExchange m) {
            return time1230;
        }
        public static BTime GetGobaCloseTime(StockExchange m) {
            if(m==StockExchange.T)
                return time1500;
            else if(m==StockExchange.O || m==StockExchange.Hercules)
                return time1510;
            else
                return time1500;
        }
        public static BTime GetEveningOpenTime(StockExchange m) {
            return time0430;
        }
        public static BTime GetEveningCloseTime(StockExchange m) {
            return time0700;
        }

        public static bool IsMarketOpenTime(StockExchange m, BTime time) {
            int t = time.AsInt();
            return (GetZenbaOpenTime(m).AsInt()<=t && t<=GetZenbaCloseTime(m).AsInt()) ||
                (GetGobaOpenTime(m).AsInt()<=t && t<=GetGobaCloseTime(m).AsInt());
        }

        public static bool IsFirstMarketOpenDateOfMonth(BDate date) {
            //悭P[X珈
            int day = date.Day;
            if(day>7) //8ȍ~ȂŏĂƂ͂Ȃ
                return false;
            else if(day==1)
                return true;

            int month = date.Month;
            DateTime r = date.ToDateTime().AddDays(-1);
            while(true) {
                if(r.Month==month) {
                    if(PublicMarketUtil.IsMarketOpenDate(r)) {
                        return false; //
                    }
                }
                else
                    return true;
                r = r.AddDays(-1);
            }
        }


        public static int GetSQDate(int year, int month) {
            DateTime dt = new DateTime(year, month, 8); //ŒZ̑j͂W
            while(dt.DayOfWeek!=DayOfWeek.Friday) dt = dt.AddDays(1); //j܂Ői߂
            Debug.Assert(dt.Day <= 14); //14܂łɂ͑j
            while(PublicMarketUtil.IsHoliday(dt.Year, dt.Month, dt.Day, false)) dt = dt.AddDays(-1); //jĵƂ͑Oɂ炷

            return BDate.DateTimeToInt(dt);
        }
        //߂̐敨̌𓾂BSQɐ؂ւ邱ƂɂȂ
        public static void GetNearestFutureGengetsu(int today, out int year, out int month) {
            year = today / 10000;
            month = (today % 10000) / 100;
            int day = (today % 100);

            if((month % 3)==0) { //SQ̂錎
                if(GetSQDate(year, month) <= today)
                    GetNextFutureGengetsu(ref year, ref month);
            }
            else {
                //12SQ̏ɂȂ̂ŏ̒iɂȂ
                month += 3 - (month % 3);
            }

        }
        public static void GetNextFutureGengetsu(ref int year, ref int month) {
            Debug.Assert((month % 3)==0); //3,6,9,12̂ǂꂩ
            if(month == 12) {
                year++;
                month = 3;
            }
            else
                month += 3;
        }
        public static void GetPrevFutureGengetsu(ref int year, ref int month) {
            Debug.Assert((month % 3)==0); //3,6,9,12̂ǂꂩ
            if(month == 3) {
                year--;
                month = 12;
            }
            else
                month -= 3;
        }

        //\
        public static string FormatTotalAmount(double value) {
            StringBuilder bld = new StringBuilder();
            const double chou = 1000000000000.0;
            const double oku  = 100000000.0;
            const double man  = 10000.0;

            if(value > chou) {
                bld.Append((value / chou).ToString("F3")).Append("");
            }
            else if(value >= oku * 1000.0) {
                bld.Append((value / oku).ToString("F0")).Append("");
            }
            else if(value >= oku * 100.0) {
                bld.Append((value / oku).ToString("F1")).Append("");
            }
            else if(value >= oku * 10.0) {
                bld.Append((value / oku).ToString("F2")).Append("");
            }
            else if(value >= oku) {
                bld.Append((value / oku).ToString("F2")).Append("");
            }
            else if(value >= man * 1000.0) {
                bld.Append((value / man).ToString("F0")).Append("");
            }
            else if(value >= man * 100.0) {
                bld.Append((value / man).ToString("F1")).Append("");
            }
            else if(value >= man * 10.0) {
                bld.Append((value / man).ToString("F2")).Append("");
            }
            else if(value >= man) {
                bld.Append((value / man).ToString("F2")).Append("");
            }
            else
                bld.Append(value.ToString("F0"));

            return bld.ToString();
        }
        public static string FormatUnitScale(double value) {
            //؂̂悢Ƃŕ\LƂ
            StringBuilder bld = new StringBuilder();
            const double chou = 1000000000000.0;
            const double oku  = 100000000.0;
            const double man  = 10000.0;

            if(value > chou) {
                bld.Append((value / chou).ToString("F1")).Append("");
            }
            else if(value >= oku * 10.0) {
                bld.Append((value / oku).ToString("F0")).Append("");
            }
            else if(value >= oku) {
                bld.Append((value / oku).ToString("F1")).Append("");
            }
            else if(value >= man * 10.0) {
                bld.Append((value / man).ToString("F0")).Append("");
            }
            else if(value >= man) {
                bld.Append((value / man).ToString("F1")).Append("");
            }
            else
                bld.Append(value.ToString("F0"));

            return bld.ToString();
        }
        public static bool IsMarketOpenDate(int date) {
            return PublicMarketUtil.IsMarketOpenDate(BDate.ToDateTime(date));
        }
        public static int NextMarketOpenDate(int date) {
            DateTime dt = BDate.ToDateTime(date);
            dt = dt.AddDays(1);
            while(!PublicMarketUtil.IsMarketOpenDate(dt)) dt = dt.AddDays(1);
            return BDate.DateTimeToInt(dt);
        }
        public static int PrevMarketOpenDate(int date) {
            DateTime dt = BDate.ToDateTime(date);
            dt = dt.AddDays(-1);
            while(!PublicMarketUtil.IsMarketOpenDate(dt)) dt = dt.AddDays(-1);
            return BDate.DateTimeToInt(dt);
        }

    }

    //ꂪJĂ鎞ԑсAʂ̕PʃCfNX̌vZAȂ
    public class MarketOpenTimeRange {
        private int[] _startTimes;
        private int[] _lengths;

        private MarketOpenTimeRange(int[] startTimes, int[] lengths) {
            _startTimes = startTimes;
            _lengths = lengths;
            Debug.Assert(_startTimes.Length==_lengths.Length);
        }
        public int SectionCount {
            get {
                return _startTimes.Length;
            }
        }

        public int StartTimeAt(int index) {
            return _startTimes[index];
        }
        public int EndTimeAt(int index) {
            return _startTimes[index] + _lengths[index];
        }
        public int LengthAt(int index) {
            return _lengths[index];
        }
        public int LengthAsMin(int index) {
            return _lengths[index] / 60;
        }
        public bool IsHikeTime(int time, out int section_index) {
            for(int i=0; i<_startTimes.Length; i++) {
                if(_startTimes[i] + _lengths[i] == time) {
                    section_index = i;
                    return true;
                }
            }
            section_index = -1;
            return false;
        }

        //indexł͉ZNVڂ̉CfbNX
        //傤ǂ̂Ƃ̓ZNV̒index_in_sectionɓ
        public void IndexToSection(int index, out int section_index, out int index_in_section) {
            int i=0;
            do {
                int minute_len = _lengths[i] / 60;
                if(index <= minute_len) { //̂ł傤ǈ鎞̂Ƃ͎̃ZNVɂ͓˓Ȃ
                    section_index = i;
                    index_in_section = index;
                    return;
                }
                index -= minute_len;
                i++;
                
            } while(i < _lengths.Length);

            section_index = -1;
            index_in_section = -1;
        }

        public int TimeToIndex(int time) {
            int acc_index = 0;
            for(int i=0; i<_startTimes.Length; i++) {
                if(time < _startTimes[i])
                    return acc_index;
                else if(time < _startTimes[i] + _lengths[i])
                    return acc_index + (BTime.AsMinutelyInt(time) - _startTimes[i]) / 60;

                acc_index += _lengths[i] / 60;
            }

            return acc_index;
        }


        private static MarketOpenTimeRange NORMAL;
        private static MarketOpenTimeRange OSE;
        private static MarketOpenTimeRange DERIVATIVE;


        public static MarketOpenTimeRange GetFor(Stock stock) {
            if(NORMAL==null) Init();

            if(stock.Profile is DerivativeStockProfile)
                return DERIVATIVE;
            else if(stock.Market==StockExchange.O || stock.Market==StockExchange.Hercules)
                return OSE;
            else
                return NORMAL;
        }

        private static void Init() {
            int zenba_t = MarketUtil.GetZenbaOpenTime(StockExchange.T).AsMinutelyInt();
            int goba_t = MarketUtil.GetGobaOpenTime(StockExchange.T).AsMinutelyInt();
            int goba_o_t = MarketUtil.GetGobaOpenTime(StockExchange.O).AsMinutelyInt();
            int evening_t = MarketUtil.GetEveningOpenTime(StockExchange.O).AsMinutelyInt();

            int zenba_len = (MarketUtil.GetZenbaCloseTime(StockExchange.T).AsMinutelyInt() - MarketUtil.GetZenbaOpenTime(StockExchange.T).AsMinutelyInt());
            int goba_len = (MarketUtil.GetGobaCloseTime(StockExchange.T).AsMinutelyInt() - MarketUtil.GetGobaOpenTime(StockExchange.T).AsMinutelyInt());
            int goba_o_len = (MarketUtil.GetGobaCloseTime(StockExchange.O).AsMinutelyInt() - MarketUtil.GetGobaOpenTime(StockExchange.O).AsMinutelyInt());
            int evening_len = (MarketUtil.GetEveningCloseTime(StockExchange.O).AsMinutelyInt() - MarketUtil.GetEveningOpenTime(StockExchange.O).AsMinutelyInt());

            NORMAL = new MarketOpenTimeRange(new int[] { zenba_t, goba_t }, new int[] { zenba_len, goba_len });
            OSE = new MarketOpenTimeRange(new int[] { zenba_t, goba_o_t }, new int[] { zenba_len, goba_o_len });
            DERIVATIVE = new MarketOpenTimeRange(new int[] { evening_t, zenba_t, goba_o_t }, new int[] { evening_len, zenba_len, goba_o_len });

        }
    }

}
