/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Data/ItaHistory.cs#9 $
 * $DateTime: 2007/12/28 19:23:38 $
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;

using Bellagio.Values;

namespace Bellagio.Data {
	
    //̓̃R[h@BV邩ǂ͖

    public class ItaHistory : IEnumerable<ItaSnapshot> {
        //莞ԂL悤ɂȂƃ̂LinkedListɂēKɃJbg
        private LinkedList<ItaSnapshot> _data;
        private int _maximumDuration;

        public ItaHistory() {
            _data = new LinkedList<ItaSnapshot>();
            _maximumDuration = 5*60; //ftHgłT
        }
        public int MaximumDuration {
            get {
                return _maximumDuration;
            }
            set {
                _maximumDuration = value;
            }
        }
        public void Append(ItaSnapshot t) {
            Debug.Assert(_data.Count==0 || _data.Last.Value.Time.AsInt()<t.Time.AsInt());
            _data.AddLast(t);
        }

        //莞Ԍo߂
        public void Adjust() {
            if(_data.Count <= 1) return;

            int x = _data.Last.Value.Time.AsInt() - _maximumDuration;
            while(_data.Count>0) {
                if(_data.First.Value.Time.AsInt() < x) _data.RemoveFirst();
            }
        }

        IEnumerator<ItaSnapshot> IEnumerable<ItaSnapshot>.GetEnumerator() {
            return _data.GetEnumerator();
        }

        System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator() {
            return _data.GetEnumerator();
        }
    }

    public class ItaSnapshot {
        private BTime _time;
        private Ita _ask;
        private Ita _bid;

        public ItaSnapshot(BTime time, Ita ask, Ita bid) {
            _time = time;
            _ask = ask;
            _bid = bid;
        }

        public BTime Time {
            get {
                return _time;
            }
        }
        public Ita Ask {
            get {
                return _ask;
            }
        }
        public Ita Bid {
            get {
                return _bid;
            }
        }
    }
}
