/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Data/DailyQuoteProvider.cs#13 $
 * $DateTime: 2008/05/14 13:05:12 $
 * 
 * IɎQuotẽRNV
 */
using System;
using System.IO;
using System.Diagnostics;
using System.Collections.Generic;
using System.Text;

using Poderosa;

using Bellagio.Values;
using Bellagio.Environment;
using Travis.Collections;

namespace Bellagio.Data {
    //f[^C^tF[X
    public interface IDailyDataLoader : IPrimaryStreamDataBase {
        SplitReflection DefaultSplitReflection { get; }
        void Load(Stock stock, IDailyDataWriteStream holder, DailyDataLoadOption option);
        AsyncOpResult AsyncLoad(Stock stock, IDailyDataWriteStream holder, DailyDataLoadOption option, ref string error);

        void ClearCache(Stock stock);
    }
    [Flags]
    public enum DailyDataLoadOption { //ItCłł悤ɁAIDailyDataLoaderɉĂ悢n
        None = 0,
        AllowComm = 1,  //ʐM
        AllowCache = 2, //[JLbV̓ǂݍ݂
        EveningIgnore = 4, //CujOZbV͖i敨̂ݗLj
        EveningToday = 8   //CujOZbV͓Ɋ܂߂i敨̂ݗLj ȂftHg͗Ɋ܂߂`
    }

    //f[^̏݌
    public interface IDailyDataWriteStream : IStockPrimaryDataInitializer {
        void InitializeStream(int record_count_capacity, bool reverse, bool volumeAvailable); //ʏ폇(reverse==false)ł͓t͌Â̂ZbgBt̂Ƃ͐V̂B
        void AddRecord(int date, int open, int high, int low, int close, int volume, int creditlong, int creditshort); //tSetCapacityŎw肵ƂłȂƂȂBoÔƂCompleteɂď
        //Complete,Fail̂ǂ炩͌ĂԕKv
        void Complete();
    }

    //l邩ǂ̎w
    public enum SplitReflection {
        Reflected, NotRefrected
    }

    //ETȆg
    public class DateBasedQuoteSet : StockPrimaryData {

        //̖^Cvł́APair[]gB
        //݂́A敨ƁACujOZbV֌WB
        //<Stock, null>yA̓f[^҂A<Stock, DailyData> ͎擾ςݓB
        //KvȂꍇ͂̔z񂻂̂̂nullł
        private Pair<Stock, ConcreteQuote>[] _underlyings;

        //fQ[g
        public delegate void MergeDelegate(DateBasedQuoteSet quotes);
        private MergeDelegate _mergeDelegate;

        private struct DWM { //Daily,Weekly,Monthlyg
            public Quote daily;
            public Quote weekly;
            public Quote monthly;

            public Quote GetOrCreate(Quote.QuoteUnit unit) {
                Debug.Assert(daily!=null);
                if(unit==Quote.QuoteUnit.Daily)
                    return daily;
                else if(unit==Quote.QuoteUnit.Weekly) {
                    if(weekly==null) weekly = QuoteConverter.DailyToWeekly(daily);
                    return weekly;
                }
                else if(unit==Quote.QuoteUnit.Monthly) {
                    if(monthly==null) monthly = QuoteConverter.DailyToMonthly(daily);
                    return monthly;
                }
                Debug.Assert(false);
                return null;
            }
            public void Clear() {
                daily = null;
                weekly = null;
                monthly = null;
            }
        }

        private DWM _raw;   //f[^
        private DWM _splitApplied; //̉H

        //ꎟf[^fς݂ǂ͈ł͂ȂBfς(Click)Af(DataGet)Ɨ

        public DateBasedQuoteSet(Stock stock) : base(stock) {
        }
        public DateBasedQuoteSet(Stock stock, Stock[] underlyings, MergeDelegate merger) : base(stock) {
            _underlyings = new Pair<Stock, ConcreteQuote>[underlyings.Length];
            for(int i=0; i<underlyings.Length; i++) _underlyings[i] = new Pair<Stock,ConcreteQuote>(underlyings[i], null);
            _mergeDelegate = merger;
        }

        public MergeDelegate Merger {
            get {
                return _mergeDelegate;
            }
        }
        public Pair<Stock, ConcreteQuote>[] UnderlyingQuotes {
            get {
                return _underlyings;
            }
        }
        public Stock NextTarget {
            get {
                if(_underlyings==null)
                    return _stock;
                else {
                    for(int i=0; i<_underlyings.Length; i++)
                        if(_underlyings[i].second==null) return _underlyings[i].first;
                    return null;
                }
            }
        }
        public bool AreUnderlyingsComplete {
            get {
                if(_underlyings==null) return true;
                for(int i=0; i<_underlyings.Length; i++)
                    if(_underlyings[i].second==null) return false;
                return true;
            }
        }

        //vfɂȂZbgAɃ[hׂStockԂBRv[gȂnullԂ
        public Stock SetElementDaily(Stock stock, ConcreteQuote daily) {
            if(_underlyings==null) { //P
                Debug.Assert(_stock==stock);
                this.SetCompleteDaily(daily);
                return null;
            }
            else {
                int i;
                for(i=0; i<_underlyings.Length; i++) {
                    if(stock==_underlyings[i].first) {
                        _underlyings[i].second = daily;
                        break;
                    }
                }

                Debug.Assert(i<_underlyings.Length); //I[ɂ͓Ȃ͂
                return i==_underlyings.Length-1? null : _underlyings[i+1].first;
            }
        }

        public void SetCompleteDaily(ConcreteQuote daily) {
            _raw.Clear();
            _splitApplied.Clear();
            _raw.daily = daily;
        }

        public Quote GetOrCreate(Quote.QuoteUnit unit, SplitReflection splitreflect) {
            if(_stock.Profile.SplitInfo==null || splitreflect==BellagioRoot.DateBasedQuoteProvider.GetDataLoader().DefaultSplitReflection)
                return _raw.GetOrCreate(unit);


            if(_splitApplied.daily==null) {
                SplitInfo[] si = _stock.Profile.SplitInfo;
                _splitApplied.daily = BellagioRoot.DateBasedQuoteProvider.GetDataLoader().DefaultSplitReflection==SplitReflection.Reflected?
                    QuoteConverter.InverseReflectSplit(_raw.daily, si) :
                    QuoteConverter.ReflectSplit(_raw.daily, si);
            }
            return _splitApplied.GetOrCreate(unit);
        }

        public override bool FireEventToSubscriberManager() {
            BellagioRoot.DataSubscriberManager.ReserveExecByStock(_stock, SubscribeDataKind.Daily);
            return false;
        }
        public override void FireErrorEventToSubscriberManager(string msg) {
            BellagioRoot.DataSubscriberManager.ReserveErrorByStock(_stock, SubscribeDataKind.Daily, msg);
        }
    }

    //f[^̃RNV
    //̃A^Cf[^̂݁AIntraDayTradeǗ邪ȊO͑SBʓrBf[^\z邱ƂɂȂB
    public class DateBasedQuoteProvider : StockDataProviderBaseT<DateBasedQuoteSet, AsyncDailyLoadProvider> {

        private IDailyDataLoader _dataLoader;


        public DateBasedQuoteProvider() {
        }
        public Quote GetActive(Stock stock, Quote.QuoteUnit unit, SplitReflection split) {
            DateBasedQuoteSet qs;
            qs = base.Lookup(stock);
            return qs==null? null : qs.GetOrCreate(unit, split);
        }
        public Quote DirectLoad(Stock stock, Quote.QuoteUnit unit, SplitReflection split) {
            CheckLoader();
            DateBasedQuoteSet qs = new DateBasedQuoteSet(stock);
            AsyncDailyLoadProvider p = new AsyncDailyLoadProvider(qs).SetDirectMode();

            try {
                _dataLoader.Load(stock, p, DailyDataLoadOption.AllowCache);
                return qs.GetOrCreate(unit, split);
            }
            catch(Exception ex) {
                Debug.WriteLine(ex.Message);
                Debug.WriteLine(ex.StackTrace);
                    return null;
            }
        }
        public void Clear(Stock stock) {
            _data.Remove(stock);
            //LbVt@CNAv
            _dataLoader.ClearCache(stock);
        }

        public IDailyDataLoader GetDataLoader() {
            return _dataLoader;
        }

        public bool CanOpenDailyData(Stock stock) {
            CheckLoader();
            if(_dataLoader==null) return false;

            AbstractStockProfile sp = stock.Profile;
            if((sp.Flags & StockProfileFlags.Hidden)!=StockProfileFlags.None) return false;
            if(sp.Primary==null) return false; //{肦ȂA}X^̃oO
            return true;
        }

        protected override DateBasedQuoteSet CreateValue(Stock stock) {
            //ȂĂ͂Ȃꍇ͓KXZbg
            DerivativeStockProfile dp = stock.Profile as DerivativeStockProfile;
            if(dp!=null) {
                //AŐ敨
                if(dp.ConcatinatedFuture) {
                    return new DateBasedQuoteSet(stock, GetConcatinatedFutureSources(dp.Brand), new DateBasedQuoteSet.MergeDelegate(MergeFuture));
                }
                //Preferenceŕω敨
                if(dp.EveningSessionAware==EveningSessionAware.Preference) {
                    EveningSessionAware ea = BellagioRoot.FixedPreferences.Chart.EveningSessionAware;
                    GlobalStockCollection gs = BellagioRoot.GlobalStockCollection;
                    if(ea==EveningSessionAware.Daytime)
                        return new DateBasedQuoteSet(stock, new Stock[] {
                            gs.FindDerivativeStockProfile(DerivativeStockProfile.FormatCode(dp.CodeForDataSource(), EveningSessionAware.Daytime), true).Primary },
                            new DateBasedQuoteSet.MergeDelegate(MergeOne));
                    else if(ea==EveningSessionAware.Default)
                        return new DateBasedQuoteSet(stock, new Stock[] {
                            gs.FindDerivativeStockProfile(DerivativeStockProfile.FormatCode(dp.CodeForDataSource(), EveningSessionAware.Default), true).Primary },
                            new DateBasedQuoteSet.MergeDelegate(MergeOne));
                    else { //Kv
                        return new DateBasedQuoteSet(stock, new Stock[] {
                            gs.FindDerivativeStockProfile(DerivativeStockProfile.FormatCode(dp.CodeForDataSource(), EveningSessionAware.Default), true).Primary,
                            gs.FindDerivativeStockProfile(DerivativeStockProfile.FormatCode(dp.CodeForDataSource(), EveningSessionAware.Daytime), true).Primary },
                            new DateBasedQuoteSet.MergeDelegate(MergeEveningToToday));
                    }
                }
            }
            //W̃P[X
            return new DateBasedQuoteSet(stock);
        }
        protected override AsyncDailyLoadProvider CreateInitializer(DateBasedQuoteSet value) {
            return new AsyncDailyLoadProvider(value);
        }
        protected override AsyncOpResult OpenValue(AsyncDailyLoadProvider initializer, ref string error) {
            CheckLoader();
            Stock target = initializer.QuoteSet.NextTarget;
            Debug.Assert(target!=null);
            AsyncOpResult result = BeginLoad(initializer, ref error);
            return result;
        }
        private AsyncOpResult BeginLoad(AsyncDailyLoadProvider initializer, ref string error) {
            Stock stock = initializer.QuoteSet.NextTarget;
            DailyDataLoadOption option = DailyDataLoadOption.AllowCache;
            if(BellagioRoot.DataSourceHost.CurrentStatus==DataSourceStatus.Connected ||
                BellagioRoot.DataSourceHost.CurrentStatus==DataSourceStatus.Disconnected) option |= DailyDataLoadOption.AllowComm;
            DerivativeStockProfile dp = stock.Profile as DerivativeStockProfile;
            if(dp!=null && dp.EveningSessionAware==EveningSessionAware.Daytime) option |= DailyDataLoadOption.EveningIgnore;

            return _dataLoader.AsyncLoad(stock, initializer, option, ref error);
        }
        protected override void CloseValue(Stock stock, DateBasedQuoteSet value) {
            //ɉȂĂ悢
        }

        //񓯊ɓ[hłƂʒm
        public void CompleteDailyQuoteLoading(Stock stock, DateBasedQuoteSet qs, ConcreteQuote daily) {
            Stock next;
            lock(this) {
                Debug.Assert(!BUtil.IsExecutingInMainThread); //͔񓯊̂
                Debug.Assert(qs!=null);
                next = qs.SetElementDaily(stock, daily);
            }

            if(next==null) {
                Debug.Assert(qs.AreUnderlyingsComplete);
                //KvȂ}[W
                if(qs.Merger!=null) qs.Merger(qs);


                base.CompleteLoading(qs.Stock);
            }
            else {
                string error = "";
                if(BeginLoad(new AsyncDailyLoadProvider(qs), ref error)==AsyncOpResult.Failed) //p擾
                    base.FailLoading(qs.Stock, error);
            }

        }
        public void FailDailyQuoteLoading(Stock stock, DateBasedQuoteSet qs, string message) {
            lock(this) {
                Debug.Assert(qs!=null);
                if(!BUtil.IsExecutingInMainThread)
                    base.FailLoading(qs.Stock, message); //IŝƂ͂ŉKv͂Ȃ
                BellagioRoot.DataSubscriberManager.ReserveErrorByStock(qs.Stock, SubscribeDataKind.Daily, message);
            }
        }
        public void CheckLoader() {
            if(_dataLoader==null) {
                IDailyDataLoader[] loaders = (IDailyDataLoader[])BellagioPlugin.Instance.DailyDataProviderPoint.GetExtensions();
                Debug.Assert(loaders.Length==1);
                _dataLoader = loaders[0];
            }
        }

        //}[WpXgBߌ炢炩̌̂ڂ
        private static Stock[] GetConcatinatedFutureSources(DerivativeStockProfile.BrandT t) {
            Stock[] r = new Stock[BellagioRoot.FixedPreferences.Chart.ConcatinateFutureCount];

            EveningSessionAware ea = BellagioRoot.FixedPreferences.Chart.EveningSessionAware;
            Debug.Assert(ea==EveningSessionAware.Daytime || ea==EveningSessionAware.Default); //ȊO̓T|[gĂȂ
            DerivativeStockProfile p = t==DerivativeStockProfile.BrandT.NikkeiFuture? BellagioRoot.GlobalStockCollection.CurrentLarge : BellagioRoot.GlobalStockCollection.CurrentMini;
            if(ea==EveningSessionAware.Daytime)
                p = BellagioRoot.GlobalStockCollection.FindDerivativeStockProfile(p.CodeForDataSource(), true, ea);

            int y, m;
            p.GetYearMonth(out y, out m);
            for(int i=0; i<r.Length; i++) {
                r[i] = p.Primary;
                MarketUtil.GetPrevFutureGengetsu(ref y, ref m);
                if(y==2007 && m==9) ea = EveningSessionAware.Default; //2007/9̃CujOZbV݂͑Ȃ̂ŁAftHgŃNGXgȂƃf[^Ȃ
                p = BellagioRoot.GlobalStockCollection.FindDerivativeStockProfile(DerivativeStockProfile.FormatNineCode(p.Brand, y, m), true, ea);
                Debug.Assert(p!=null);
            }
            return r;
        }

        //̐敨SQEɘA
        private static void MergeFuture(DateBasedQuoteSet qs) {
            //擪ߌł̂ڂ鏇ɕł
            //^Ԃ́AuO̖SQvu̖̍ŏItv܂łɂȂB
            ConcreteQuote result = new ConcreteQuote(Quote.QuoteUnit.Daily);
            int y, m;
            for(int i=qs.UnderlyingQuotes.Length-1; i>=0; i--) {
                DerivativeStockProfile pf = qs.UnderlyingQuotes[i].first.Profile as DerivativeStockProfile;
                Debug.Assert(pf!=null);
                ConcreteQuote q = qs.UnderlyingQuotes[i].second;
                pf.GetYearMonth(out y, out m);
                MarketUtil.GetPrevFutureGengetsu(ref y, ref m);
                int d = MarketUtil.GetSQDate(y, m);

                int di = q.FindExactly(d); //SQ烉Xg܂Ŏ^
                if(di==-1) {
                    BUtil.ShowWarningMessageBox(String.Format("{0}ɕKvȓt̃f[^^Ă܂B擾\f[^݂̂ŕ\܂B", pf.Name));
                    break;
                }

                while(di < q.Count) {
                    //{͓tdȂ͂ꉞK[h
                    Candle appending = new Candle(q.CandleAt(di));

                    Candle last = result.LastCandle;
                    if(last==null || last.Time<appending.Time) { //ꂪʏ
                        result.Add(appending);
                    }
                    else {
                        result.SetDirect(result.Count-1, appending);
                    }

                    di++;
                }
            }

            qs.SetCompleteDaily(result);
        }

        //WÂ݁Aƕ񂾃f[^CujO𓖓ɂf[^쐬
        private static void MergeEveningToToday(DateBasedQuoteSet qs) {
            //̓ + ̕W(=̓{̃CujO) - ̓̃f[^ƂȂ
            ConcreteQuote result = new ConcreteQuote(Quote.QuoteUnit.Daily);
            ConcreteQuote default_quote = qs.UnderlyingQuotes[0].second;
            ConcreteQuote daytime_quote = qs.UnderlyingQuotes[1].second;
            int daytime_index = 0;
            int default_index = default_quote.FindExactly(daytime_quote.CandleAt(0).Time) + 1;
            if(default_index==0) {
                qs.SetCompleteDaily(result);
                return; //FindExactly0
            }

            while(daytime_index < daytime_quote.Count-1 || default_index < default_quote.Count) {
                Candle today_daytime = daytime_quote.CandleAt(daytime_index);
                Candle tomorrow_def  = default_quote.CandleAt(default_index);
                Candle tomorrow_day  = daytime_quote.CandleAt(daytime_index+1);

                //int ev_high = 

                daytime_index++;
                default_index++;
            }

            qs.SetCompleteDaily(result);
        }

        //PRs[
        private static void MergeOne(DateBasedQuoteSet qs) {
            qs.SetCompleteDaily(qs.UnderlyingQuotes[0].second);
        }

    }

    //f[^̃[h{̂̑OɕKvȏs
    public class AsyncDailyLoadProvider : StockPrimaryDataInitializer, IDailyDataWriteStream {
        private DateBasedQuoteSet _target;
        private ConcreteQuote _daily;
        private Stock _stock;
        private bool _reverse;
        private bool _volumeAvailable; //oLȒlɂȂĂ邩ǂ ꕔ̎wł͖
        private bool _completed;
        private bool _directMode;

        public AsyncDailyLoadProvider(DateBasedQuoteSet target) : base(target) {
            _stock = target.NextTarget;
            _target = target;
            _daily = new ConcreteQuote(Quote.QuoteUnit.Daily, 1);
        }
        public DateBasedQuoteSet QuoteSet {
            get {
                return _target;
            }
        }
                
        public ConcreteQuote Result {
            get {
                return _daily;
            }
        }
        public override bool IsCompleted {
            get {
                return _completed;
            }
        }
        public AsyncDailyLoadProvider SetDirectMode() {
            _directMode = true;
            return this;
        }

        public void InitializeStream(int record_count, bool reverse, bool volumeAvailable) {
            _reverse = reverse;
            _volumeAvailable = volumeAvailable;
            _daily.SetCapacity(record_count);
        }

        public void AddRecord(int date, int open, int high, int low, int close, int volume, int creditlong, int creditshort) {
            _daily.Add(date, open, high, low, close, volume, creditlong, creditshort);
        }

        //PԂ̓f[^̍쐬I
        void IDailyDataWriteStream.Complete() {
            CompleteInitialization();
        }

        public override void CompleteInitialization() {
            if(_reverse) {
                //ЂԂ
                List<Candle> b = new List<Candle>(_daily.Count);
                for(int i=0; i<_daily.Count; i++)
                    b.Add(_daily.CandleAt(_daily.Count-1 - i));
                Debug.Assert(_daily.Count==b.Count);
                _daily = new ConcreteQuote(Quote.QuoteUnit.Daily, 1, b); //č쐬
            }

            //oȎ̏CBNilA߂̗LȏIl̂܂܏oOÂQ肤B
            //sf[^ЂƂłΒߏIl̏oOAȂNilƂ
            if(_volumeAvailable) { //ƂƖƂꂽꍇ͏Ȃ
                Candle last_valid = null;
                for(int i=0; i<_daily.Count; i++) {
                    Candle c = _daily.CandleAt(i);
                    if(c.Volume==0) {
                        if(last_valid==null)
                            c.Flags = CandleFlags.Nil;
                        else {
                            int v = last_valid.Close;
                            c.Set(c.BaseQuote, c.Index, c.Time, v, v, v, v, 0, CandleFlags.None);
                        }
                    }
                    else
                        last_valid = c;
                }
            }

            //o^
            _completed = true;
            if(!_directMode)
                BellagioRoot.DateBasedQuoteProvider.CompleteDailyQuoteLoading(_stock, _target, _daily);
            else
                _target.SetCompleteDaily(_daily);
        }


        //̃C^tF[X\͂ꂾȂ
        public override void FailLoading(string message) {
            if(!_directMode)
                BellagioRoot.DateBasedQuoteProvider.FailDailyQuoteLoading(_stock, _target, message);
            else
                throw new BellagioException(message);
        }

    }

}
