/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Chart/ItaGraphics.cs#12 $
 * $DateTime: 2008/02/22 14:50:30 $
 *
 * ̕`
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;
using System.Diagnostics;
using System.Windows.Forms;

using Travis.LocationOperation;
using Travis;
using Sansa.Runtime;
using Bellagio.Forms;
using Bellagio.Data;
using Bellagio.Drawing;

//̕`
namespace Bellagio.Chart {
    //TESTINFO GraphicViewer

    public class ItaGraphicsSettings : DrawingSettingsBase {
        public enum LayoutStyle {
            Legacy, //J̃c[Ɠlɒ̒liAEbid, ask
            Plain, //E㉺ɐ
            FixPricetoLeft, //iBJ̃c[ƓlAAskABidEɕԂƂɂȂ邪Ali͍[Œ
            None,
        }
        //\X^C ͐̂intpreference
        public LayoutStyle layoutStyle {
            get {
                return (LayoutStyle)layoutStyleI.V;
            }
            set {
                layoutStyleI.UnderlyingItem.AsInt().Value = (int)value;
            }
        }
        public DSInt layoutStyleI;
        public DSFont priceFont; //itHg
        public DSFont askVolumeFont; //ʃtHg
        public DSFont askVolumeDiffFont; //ʍtHg
        public DSFont bidVolumeFont; //ʃtHg
        public DSFont bidVolumeDiffFont; //ʍtHg
        public DSBrush backColor; //wiF
        public DSBrush priceColor; //iF
        public DSBrush activePriceBackColor; //ߒlwiF
        public DSBrush remarkColor; //̐F
        public DSBrush hoveredSashineColor;@//wlɃ}EXĂƂ̐F
        public DSBrush askVolumeColor; //ʐF
        public DSBrush bidVolumeColor; //ʐF
        public DSBrush volumeDiffPositiveColor; //ʑ̍̐F
        public DSBrush volumeDiffNegativeColor; //ʌ̍̐F
        public DSInt pitch; //P̕\
        public DSInt margin; //Ö̗
        public double darkEffectRatio; 

        public DSInt priceAreaWidth; //i\
        public DSInt remarkAreaWidth; //͒ƓƂɕ\̂Ƃ
        public DSInt volumeAreaWidth; //ʕ\
        public DSInt diffAreaWidth; //\

        public double animationTime; //P̓ɂ鎞ԂbŎw
        public double fadingWaitLength;  //tF[fBOAj[VɂĂ̑ҋ@

        public ItaGraphicsSettings(string id)
            : base(id) {
        }

        protected override void CreateElements() {
            //_CAOŕҏWƂAReloadPreferenceɂčXV̒l悤ɂȂĂ邽߂ɂ͕Kv
            GetFolder().AddChangeListener(BellagioRoot.FixedPreferences.Chart);

            layoutStyleI = DefineInt("layoutStyle", 0);
            priceFont = DefineFont("priceFont", DSFont.GenericFontName, 10);
            askVolumeFont = DefineFont("askVolumeFont", DSFont.GenericFontName, 10);
            askVolumeDiffFont = DefineFont("askVolumeDiffFont", DSFont.GenericFontName, 9);
            bidVolumeFont = DefineFont("bidVolumeFont", DSFont.GenericFontName, 10);
            bidVolumeDiffFont = DefineFont("bidVolumeDiffFont", DSFont.GenericFontName, 9);
            backColor = DefineBrush("backColor", Color.Black);
            pitch = DefinePositiveInt("pitch", 15);
            margin = DefineInt("margin", 3);
            animationTime = 0.4;
            fadingWaitLength = 0.3; //R
            priceAreaWidth = DefinePositiveInt("priceAreaWidth", 60);
            remarkAreaWidth = DefinePositiveInt("remarkAreaWidth", 15);
            volumeAreaWidth = DefinePositiveInt("volumeAreaWidth", 60);
            diffAreaWidth = DefineInt("diffAreaWidth", 80);
            askVolumeColor = DefineBrush("askVolumeColor", Color.SkyBlue);
            bidVolumeColor = DefineBrush("bidVolumeColor", Color.Tomato);
            priceColor = DefineBrush("priceColor", Color.Yellow);
            activePriceBackColor = DefineBrush("activePriceBackColor", Color.DarkOliveGreen);
            remarkColor = DefineBrush("remarkColor", Color.Red);
            volumeDiffPositiveColor = DefineBrush("volumeDiffPositiveColor", Color.LightCyan);
            volumeDiffNegativeColor = DefineBrush("volumeDiffNegativeColor", Color.LightPink);
            darkEffectRatio = 0.6;
            hoveredSashineColor = DefineBrush("hoveredSashineColor", Color.DarkOliveGreen);
        }

        public void AssertValid() {
            //ZbĝׂZbgĂ邱ƂmF
            Debug.Assert(priceFont!=null);
            Debug.Assert(askVolumeFont!=null);
            Debug.Assert(askVolumeDiffFont!=null);
        }
    }

    //LayoutStylePreferenceł͂ȂZbVƂɕς肤悤ɂȂ̂ŕ
    public class ItaLayoutParam {
        private ItaGraphicsSettings.LayoutStyle layoutStyle;
        private ItaGraphicsSettings _s;

        public ItaLayoutParam(ItaGraphicsSettings s) {
            _s = s;
            layoutStyle = s.layoutStyle;
        }

        public ItaGraphicsSettings.LayoutStyle LayoutStyle {
            get {
                return layoutStyle;
            }
            set {
                layoutStyle = value;
            }
        }

        public int totalWidth {
            get {
                if(layoutStyle==ItaGraphicsSettings.LayoutStyle.Legacy)
                    return _s.priceAreaWidth.V + (_s.remarkAreaWidth.V + _s.volumeAreaWidth.V) * 2;
                else
                    return _s.priceAreaWidth.V + _s.remarkAreaWidth.V + _s.volumeAreaWidth.V + _s.diffAreaWidth.V;
            }
        }
        //eGAXWX^CʂɎ擾 ԂlDrawStringUtil.ClippedɓnׂłA`̍[ł邱ƂE[ł邱Ƃ
        public int PriceAreaX(AskBid ab) {
            return (layoutStyle==ItaGraphicsSettings.LayoutStyle.Legacy? _s.remarkAreaWidth.V + _s.volumeAreaWidth.V : 0) + _s.priceAreaWidth.V/2;
        }
        public int RemarkAreaX(AskBid ab) {
            if(layoutStyle==ItaGraphicsSettings.LayoutStyle.Legacy)
                return ab==AskBid.Ask? _s.volumeAreaWidth.V + _s.remarkAreaWidth.V : _s.volumeAreaWidth.V + _s.remarkAreaWidth.V+_s.priceAreaWidth.V;
            else if(layoutStyle==ItaGraphicsSettings.LayoutStyle.Plain)
                return _s.priceAreaWidth.V;
            else
                return ab==AskBid.Ask? _s.priceAreaWidth.V : _s.priceAreaWidth.V + _s.diffAreaWidth.V;
        }
        public LRAlign RemarkAreaAlign(AskBid ab) {
            return (layoutStyle==ItaGraphicsSettings.LayoutStyle.Legacy && ab==AskBid.Ask)? LRAlign.Right : LRAlign.Left;
        }
        public int VolumeAreaX(AskBid ab) {
            if(layoutStyle==ItaGraphicsSettings.LayoutStyle.Legacy)
                return ab==AskBid.Ask? _s.volumeAreaWidth.V : _s.volumeAreaWidth.V+_s.remarkAreaWidth.V+_s.priceAreaWidth.V+_s.remarkAreaWidth.V;
            else if(layoutStyle==ItaGraphicsSettings.LayoutStyle.Plain)
                return _s.priceAreaWidth.V + _s.remarkAreaWidth.V;
            else
                return ab==AskBid.Ask? _s.priceAreaWidth.V+_s.remarkAreaWidth.V : _s.priceAreaWidth.V + _s.diffAreaWidth.V + _s.remarkAreaWidth.V;
        }
        public LRAlign VolumeAreaAlign(AskBid ab) {
            return (layoutStyle==ItaGraphicsSettings.LayoutStyle.Legacy && ab==AskBid.Ask)? LRAlign.Right : LRAlign.Left;
        }
        public int VolumeDiffAreaX(AskBid ab) {
            if(layoutStyle==ItaGraphicsSettings.LayoutStyle.Legacy)
                return ab==AskBid.Ask? _s.volumeAreaWidth.V+_s.remarkAreaWidth.V+_s.priceAreaWidth.V : _s.volumeAreaWidth.V+_s.remarkAreaWidth.V;
            else if(layoutStyle==ItaGraphicsSettings.LayoutStyle.Plain)
                return _s.priceAreaWidth.V + _s.remarkAreaWidth.V + _s.volumeAreaWidth.V;
            else
                return ab==AskBid.Ask? _s.priceAreaWidth.V+_s.remarkAreaWidth.V+_s.volumeAreaWidth.V : _s.priceAreaWidth.V+_s.diffAreaWidth.V;
        }
        public LRAlign VolumeDiffAreaAlign(AskBid ab) {
            if(layoutStyle==ItaGraphicsSettings.LayoutStyle.Plain)
                return LRAlign.Left;
            else
                return ab==AskBid.Ask? LRAlign.Left : LRAlign.Right;
        }

    }


    public class ItaGraphics : ViewContentGraphics {

        private ItaGraphicsSettings _settings;
        private ItaLayoutParam _layoutParam;

        private ItaMotion _askMotion;
        private ItaMotion _bidMotion;
        private bool _darkEffect; //Oł͈Â
        private bool _coverHoveredSashine; //}EX̏Ăwl͂ރGtFNg邩ǂBwlNbNŎgp
        private bool _enableOrderCount; //̕\IvV
        private BRect _bound;

        public ItaGraphics(Control control, IPlatformBridge platform, ItaGraphicsSettings settings, ItaLayoutParam lp) : base(platform, control) {
            _layoutParam = lp;
            _settings = settings;
            _bound = new BRect();
            _rectangleOperator = new RectangleOperatorBuilder()
                .ProbeBRect(_bound).Finish();
        }
        public ItaGraphicsSettings Settings {
            get {
                return _settings;
            }
        }
        public BRect Bound {
            get {
                return _bound;
            }
        }
        public bool CoverHoveredSashine {
            get {
                return _coverHoveredSashine;
            }
            set {
                _coverHoveredSashine = value;
            }
        }
        public bool EnableOrderCount {
            get {
                return _enableOrderCount;
            }
            set {
                _enableOrderCount = value;
            }
        }
        public ItaMotion AskMotion {
            get {
                return _askMotion;
            }
        }
        internal void StartItaMotion(RealtimeIta ita) {
            //OAʋCzA݂Ƃ͈Â߂̕\
            bool dark = false;
            Sashine sa = ita.Ask.SashineAt(0);
            Sashine sb = ita.Ask.SashineAt(0);
            dark = (sa.Visible && (sa.Remark==SashineRemark.TokuKehai || sa.Remark==SashineRemark.Yorimae)) ||
                   (sb.Visible && (sb.Remark==SashineRemark.TokuKehai || sb.Remark==SashineRemark.Yorimae));
            StartItaMotion(ita.AskMotion, ita.BidMotion, dark);
        }
        public void StartItaMotion(ItaMotion ask, ItaMotion bid, bool darkEffect) {
            _askMotion = ask;
            _bidMotion = bid;
            _darkEffect = darkEffect;

            base.DataUpdateDirect();
            _dataAnimationTimer.Initialize();
        }
        protected override void OnEndAnimation() {
            base.OnEndAnimation();
            _askMotion.ClearPriceMotion();
            _bidMotion.ClearPriceMotion();
        }
                
        public override void Dispose() {
        }

        protected override void BuildScaleInfo() {
        }
        protected override void InvalidateForDataAnimationTick() {
            InvalidateRect(_bound);
        }

        //WΉwlԂBȂnull
        public SashineMotion HitTest(Point pt) {
            Rectangle rc = _bound.Value;
            if(_askMotion!=null && rc.Contains(pt)) {

                for(int i=0; i<_askMotion.Size; i++) {
                    SashineMotion m = _askMotion.MotionAt(i);
                    if(PaintRequired(m) && IntRange(CalcTop(AskBid.Ask, m), _settings.pitch.V, pt.Y)) return m;
                }
                for(int i=0; i<_bidMotion.Size; i++) {
                    SashineMotion m = _bidMotion.MotionAt(i);
                    if(PaintRequired(m) && IntRange(CalcTop(AskBid.Bid, m), _settings.pitch.V, pt.Y)) return m;
                }
            }
            return null;
        }
        private static bool IntRange(int a, int w, int v) {
            return a <= v && v < a+w;
        }

        //łĖ{̕`R[h
        private bool _hoverEffectPainted;
        public override void Paint(Graphics g, Rectangle clip) {
            //`悷܂łɂ̓ZbgĂȂƂ
            Debug.Assert(_settings!=null);
            _settings.AssertValid();
            
            if(_askMotion==null || _bound.IsEmpty) return;

            PaintHeader(g);

            _hoverEffectPainted = false; //̎wlɈ݂͂̃yCgĂ܂Ȃ߂̃K[h
            for(int i=0; i<_askMotion.Size; i++) {
                SashineMotion m = _askMotion.MotionAt(i);
                if(PaintRequired(m)) PaintSashine(g, AskBid.Ask, m);
            }
            for(int i=0; i<_bidMotion.Size; i++) {
                SashineMotion m = _bidMotion.MotionAt(i);
                if(PaintRequired(m)) PaintSashine(g, AskBid.Bid, m);
            }
        }
        private void PaintHeader(Graphics g) {
            int top = _bound.Top + 2;
            int left = _bound.CenterX - _layoutParam.totalWidth/2;
            DrawStringUtil.Clipped(g, "i", _settings.priceFont.F, _settings.priceColor.B, _bound.Value, left+_layoutParam.PriceAreaX(AskBid.Ask), top, LRAlign.Center);
            if(_layoutParam.LayoutStyle!=ItaGraphicsSettings.LayoutStyle.Plain) {
                string vs = _enableOrderCount? "()" : "";
                DrawStringUtil.Clipped(g, vs, _settings.askVolumeFont.F, _settings.askVolumeColor.B, _bound.Value, left+_layoutParam.VolumeAreaX(AskBid.Ask), top, _layoutParam.VolumeAreaAlign(AskBid.Ask));
                vs = _enableOrderCount? "()" : "";
                DrawStringUtil.Clipped(g, vs, _settings.bidVolumeFont.F, _settings.bidVolumeColor.B, _bound.Value, left+_layoutParam.VolumeAreaX(AskBid.Bid), top, _layoutParam.VolumeAreaAlign(AskBid.Bid));
            }
            else { //ЂƂoȂ
                string vs = _enableOrderCount? "()" : "";
                DrawStringUtil.Clipped(g, vs, _settings.askVolumeFont.F, _settings.askVolumeColor.B, _bound.Value, left+_layoutParam.VolumeAreaX(AskBid.Ask), top, _layoutParam.VolumeAreaAlign(AskBid.Ask));
            }
        }

        private bool PaintRequired(SashineMotion m) {
            switch(m.Action) {
                case SashineAction.Move:
                    return true;
                case SashineAction.ScrollOut:
                    return _dataAnimationTimer.IsActive();
                case SashineAction.ScrollIn:
                    return true;
                case SashineAction.FadeIn:
                    return _dataAnimationTimer.value()>_settings.fadingWaitLength;
                case SashineAction.FadeOut:
                    return _dataAnimationTimer.value()<1-_settings.fadingWaitLength;
                default:
                    return false;
            }
        }
        //xuVŎš͈Ȗ
        private void PaintSashine(Graphics g, AskBid ab, SashineMotion m) {
            Point mouse = _container.PointToClient(Control.MousePosition);
            int top = CalcTop(ab, m);
            Brush br = null;
            
            if(_coverHoveredSashine && !_hoverEffectPainted && IntRange(_bound.Left, _bound.Width, mouse.X) && IntRange(top, _settings.pitch.V, mouse.Y)) {
                using(Pen p = new Pen(_settings.hoveredSashineColor.col)) {
                    RoundRectUtil.Draw(g, p, new Rectangle(_bound.Left+3, top-1, _bound.Width-6, _settings.pitch.V-1), 5);
                    _hoverEffectPainted = true;
                }
            }

            //Clip̓wb_̂Ps
            Rectangle clip = _bound.Value;
            clip.Y += _settings.pitch.V;
            clip.Height -= _settings.pitch.V;

            //i
            int left = _bound.CenterX - _layoutParam.totalWidth/2;
            if(_settings.priceAreaWidth.V!=0) {
                if(m.PriceEffect==SashinePriceEffect.None) {
                    br = new SolidBrush(CalcPriceColor(m));
                    DrawStringUtil.Clipped(g, FormatPriceString(m.Sashine.Price), _settings.priceFont.F, br, clip, left+_layoutParam.PriceAreaX(ab), top, LRAlign.Center);
                }
                else {
                    string price_string = FormatPriceString(m.Sashine.Price);
                    SizeF psz = g.MeasureString(price_string, _settings.priceFont.F);
                    Rectangle r = new Rectangle(left+_layoutParam.PriceAreaX(ab)-2-(int)psz.Width/2, top, (int)psz.Width+4, _settings.pitch.V);
                    br = new SolidBrush(CalcPriceBackColor(m));
                    RoundRectUtil.Fill(g, br, r, 3);
                    br.Dispose();
                    br = new SolidBrush(CalcPriceColor(m));
                    DrawStringUtil.Clipped(g, price_string, _settings.priceFont.F, br, clip, left+_layoutParam.PriceAreaX(ab), top, LRAlign.Center);
                }

                br.Dispose();
            }

            //
            if(_settings.remarkAreaWidth.V!=0) { //ƌ͓̈gBXy[Xߖ̂߁BɉΌ͏ɏȗ
                if(m.Sashine.Remark!=SashineRemark.None) {
                    br = new SolidBrush(CalcRemarkColor(m));
                    DrawStringUtil.Clipped(g, FormatRemarkString(m.Sashine.Remark), _settings.priceFont.F, br, clip, left+_layoutParam.RemarkAreaX(ab), top, _layoutParam.RemarkAreaAlign(ab));
                    br.Dispose();
                }
            }

            //
            if(_settings.volumeAreaWidth.V!=0) {
                br = new SolidBrush(CalcVolumeColor(ab, m));
                int vib_effect = (m.PriceMotion==SashinePriceMotion.Tick && _dataAnimationTimer.IsActive())? VibrationEffect() : 0;

                DrawStringUtil.Clipped(g, FormatVolumeString(m), ab==AskBid.Ask? _settings.askVolumeFont.F : _settings.bidVolumeFont.F, br, clip, left+vib_effect+_layoutParam.VolumeAreaX(ab), top, _layoutParam.VolumeAreaAlign(ab));
                br.Dispose();

                //Diff
                if(m.Action==SashineAction.Move && m.Diff!=0 && _dataAnimationTimer.IsActive() && BellagioRoot.FixedPreferences.Chart.EnableItaDiff) {
                    string t = m.Diff>0? "+"+m.Diff.ToString() : m.Diff.ToString();
                    Font f = ab==AskBid.Ask? _settings.askVolumeDiffFont.F : _settings.bidVolumeDiffFont.F;
                    int offset = (int)(_dataAnimationTimer.value() * 8);

                    if(_layoutParam.VolumeDiffAreaAlign(ab)==LRAlign.Right)
                        left -= offset;
                    else
                        left += offset;

                    Color dc = CalcDiffColor(m);
                    Brush db = new SolidBrush(dc);
                    DrawStringUtil.Clipped(g, t, f, db, clip, left+_layoutParam.VolumeDiffAreaX(ab), top, _layoutParam.VolumeDiffAreaAlign(ab));
                    db.Dispose();
                }
            }

        }

        private int CalcTop(AskBid ab, SashineMotion m) {
            int d = CalcDestSashineIndex(m);
            if(!_dataAnimationTimer.IsActive()) return IndexToTop(ab, d);

            int s = CalcSrcSashineIndex(m);
            if(s==d)
                return IndexToTop(ab, s);
            else
                return DrawingUtil.ProportionalInt(IndexToTop(ab, s), IndexToTop(ab, d), _dataAnimationTimer.value());
        }
        private int CalcSrcSashineIndex(SashineMotion m) {
            if(m.Action==SashineAction.ScrollIn)
                return _askMotion.ItaSize;
            else
                return m.SrcIndex;
        }
        private int CalcDestSashineIndex(SashineMotion m) {
            if(m.Action==SashineAction.ScrollOut)
                return _askMotion.ItaSize;
            else
                return m.DestIndex;
        }
        private int IndexToTop(AskBid ab, int index) {
            //ォAwb_Aask̍~Abid̏
            int m = _askMotion.ItaSize; //TCYBbidĂȂ
            if(ab==AskBid.Ask)
                return _bound.Top + _settings.pitch.V + _settings.margin.V + (m-1 - index) * _settings.pitch.V;
            else
                return _bound.Top + _settings.pitch.V + _settings.margin.V + (m + index) * _settings.pitch.V;
        }



        private Color CalcPriceColor(SashineMotion m) {
            Color target = _darkEffect?
                DrawingUtil.ProportionalColor(_settings.backColor.col, _settings.priceColor.col, _settings.darkEffectRatio) :
                _settings.priceColor.col;

            if(m.Action==SashineAction.FadeIn)
                return DrawingUtil.ProportionalColor(_settings.backColor.col, target, FadeInProgress());
            else if(m.Action==SashineAction.FadeOut)
                return DrawingUtil.ProportionalColor(_settings.backColor.col, target, FadeOutProgress());
            else
                return target;
        }
        private Color CalcPriceBackColor(SashineMotion m) {
            switch(m.PriceEffect) {
                case SashinePriceEffect.Active:
                    return _settings.activePriceBackColor.col;
                case SashinePriceEffect.FadeIn:
                    return DrawingUtil.ProportionalColor(_settings.backColor.col, _settings.activePriceBackColor.col, FadeInProgress());
                case SashinePriceEffect.FadeOut:
                    return DrawingUtil.ProportionalColor(_settings.backColor.col, _settings.activePriceBackColor.col, FadeOutProgress());
                default:
                    return _settings.backColor.col;
            }
        }

        private Color CalcVolumeColor(AskBid ab, SashineMotion m) {
            Color c = ab==AskBid.Ask? _settings.askVolumeColor.col : _settings.bidVolumeColor.col;
            c = _darkEffect? DrawingUtil.ProportionalColor(_settings.backColor.col, c, _settings.darkEffectRatio) : c;
            if(m.Action==SashineAction.FadeIn)
                return DrawingUtil.ProportionalColor(_settings.backColor.col, c, FadeInProgress());
            else if(m.Action==SashineAction.FadeOut)
                return DrawingUtil.ProportionalColor(_settings.backColor.col, c, FadeOutProgress());
            else
                return c;
        }
        private Color CalcRemarkColor(SashineMotion m) {
            Color target = _darkEffect? DrawingUtil.ProportionalColor(_settings.backColor.col, _settings.remarkColor.col, _settings.darkEffectRatio) : _settings.remarkColor.col;
            if(m.Action==SashineAction.FadeIn)
                return DrawingUtil.ProportionalColor(_settings.backColor.col, target, FadeInProgress());
            else if(m.Action==SashineAction.FadeOut)
                return DrawingUtil.ProportionalColor(_settings.backColor.col, target, FadeOutProgress());
            else
                return target;
        }
        /*
        private Color CalcOrderCountColor(SashineMotion m) {
            Color target = _darkEffect? DrawingUtil.ProportionalColor(_settings.backColor.col, _settings.orderCountColor.col, _settings.darkEffectRatio) : _settings.orderCountColor.col;
            if(m.Action==SashineAction.FadeIn)
                return DrawingUtil.ProportionalColor(_settings.backColor.col, target, FadeInProgress());
            else if(m.Action==SashineAction.FadeOut)
                return DrawingUtil.ProportionalColor(_settings.backColor.col, target, FadeOutProgress());
            else
                return target;
        }
        */
        //TODO vZ͎Z̓ӂƂƂ낾
        private Color CalcDiffColor(SashineMotion m) {
            Color c = m.Diff>0? _settings.volumeDiffPositiveColor.col : _settings.volumeDiffNegativeColor.col;
            if(_darkEffect) c = DrawingUtil.ProportionalColor(_settings.backColor.col, c, _settings.darkEffectRatio);

            Debug.Assert(_dataAnimationTimer.value() <= 1.0);
            if(_dataAnimationTimer.value()<0.8)
                return c;
            else if(_dataAnimationTimer.value()<1)
                return DrawingUtil.ProportionalColor(c, _settings.backColor.col, (_dataAnimationTimer.value()-0.8)*5);
            else
                return _settings.backColor.col;
        }
        private int VibrationEffect() {
            int v = _dataAnimationTimer.IsActive()? (int)Math.Floor(_dataAnimationTimer.value()*16) : 0; //PTCNWŁAQTCN삳̂16
            return GraphicEffectUtil.LinearZigZag(8, v, 2);
        }

        //ŏfadeingWaitLength܂ł͂OǍ^C}Pɑ܂łɒlPɂȂ
        private double FadeInProgress() {
            double w = _settings.fadingWaitLength;
            if(_dataAnimationTimer.value() < w)
                return 0;
            else
                return (_dataAnimationTimer.value()-w) / (1-w);
        }
        private double FadeOutProgress() {
            double w = _settings.fadingWaitLength;
            if(_dataAnimationTimer.value() > w)
                return 0;
            else
                return (-_dataAnimationTimer.value()+1-w) / (1-w);
        }
        private string FormatPriceString(int value) {
            return value.ToString();
        }
        private string FormatVolumeString(SashineMotion m) {
            if(m.Sashine.Volume==0) return "      -";

            string t = m.Sashine.Volume.ToString();
            //킹
            StringBuilder b = new StringBuilder();
            if(t.Length < 7) {
                for(int i=0; i<7-t.Length; i++) b.Append(' ');
            }
            b.Append(t);

            if(_enableOrderCount) {
                b.Append('(');
                t = m.Sashine.OrderCount.ToString();
                if(t.Length < 4) {
                    for(int i=0; i<4-t.Length; i++) b.Append(' ');
                }
                b.Append(t).Append(')');
            }

            return b.ToString();
        }
        private string FormatOrderCountString(int value) {
            string t = value.ToString();
            //킹 TODO StringUtilցII
            if(t.Length < 4) {
                StringBuilder b = new StringBuilder();
                for(int i=0; i<4-t.Length; i++) b.Append(' ');
                b.Append(t);
                return b.ToString();
            }
            else
                return t;
        }
        private string FormatRemarkString(SashineRemark r) {
            switch(r) {
                case SashineRemark.Yorimae: return "O";
                case SashineRemark.Hike: return "";
                case SashineRemark.Chuu: return "";
                case SashineRemark.TokuKehai: return "";
            }
            return "";
        }
    }
}
