using System;
using System.Collections.Generic;
using System.Text;

namespace Sansa.Runtime {
    //Modification Allowed during Enumeration
    public class MAECollection<T> {
        private LinkedList<T> _data;
        private T[] _array;
        private bool _modified;

        public MAECollection() {
            _data = new LinkedList<T>();
            _array = new T[10];
        }

        public int Count {
            get {
                return _data.Count;
            }
        }
        public void Add(T elem) {
            _data.AddLast(elem);
            _modified = true;
        }
        public void Remove(T elem) {
            _data.Remove(elem);
            _modified = true;
        }
        public bool Contains(T elem) {
            return _data.Contains(elem);
        }
        public void PrepareEnum(out T[] result, out int length) {
            if(_modified) {
                int l = _data.Count;
                while(l < _data.Count) l *= 2;
                if(l > _array.Length) _array = new T[l];
                
                int count = 0;
                foreach(T t in _data) _array[count++] = t;
                
                _modified = false;
            }

            result = _array;
            length = _data.Count;
        }
    }
}
