using System;
using System.Diagnostics;

namespace Sansa.Runtime {
    public class IntTimer : AbstractTimer {

        private int _initial;
        private int _final;
        private int _length; //񂩂ēB邩
        private int _step; //݂stepB0_length܂ł̒lƂ
        private int _value;

        public IntTimer(IPlatformBridge bridge, ITimerDownstream handler)
            : base(bridge, handler) {
        }

        public void reset(int sleep, int interval, int initial, int final_, int length, bool loop) {
            Debug.Assert(length>0);
            base.resetBase(sleep, interval, loop);
            _initial = initial;
            _final = final_;
            _length = length;
            _step = 0;
            _value = _initial;
        }
        public int InitialValue {
            get {
                return _initial;
            }
        }
        public int FinalValue {
            get {
                return _final;
            }
        }
        
        public void reset(int initial, int final_) {
            reset(0, 1, initial, final_, Math.Abs(final_-initial), false);
        }
        public void reset(int initial, int final_, int length) {
            reset(0, 1, initial, final_, length, false);
        }

        protected override bool stepValue() {
            _step++;
            //1ł̒l̑ (final-initial)/length. ľܓɂȂ悤
            int d = _final > _initial? _length/2 : -_length/2; //ľܓp
            _value = _initial + ((_final - _initial) * _step + d) / _length;
            return _step==_length;
        }
        protected override void stepToLast() {
            _step = _length;
            _value = _final;
        }
        protected override void stepToFirst() {
            _step = 0;
            _value = _initial;
        }

        public virtual int value() {
            return _value;
        }

    }
}