using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;

namespace Travis {
    public enum Corners {
        TopLeft,
        TopRight,
        BottomLeft,
        BottomRight
    }
    //E̕w
    public enum LRAlign {
        Left, Center, Right
    }

    //Graphics.DrawStringgĂ낢WvZZbgɂȂ
    public static class DrawStringUtil {
        public static void Clipped(Graphics g, string text, Font f, Brush b, Rectangle clip, int x, int y) {
            RectangleF t = g.ClipBounds;
            g.SetClip(clip);
            g.DrawString(text, f, b, x, y);
            g.SetClip(t);
        }
        public static void Clipped(Graphics g, string text, Font f, Brush b, Rectangle clip, int x, int y, LRAlign align) {
            RectangleF t = g.ClipBounds;
            g.SetClip(clip);
            if(align==LRAlign.Left)
                g.DrawString(text, f, b, x, y);
            else {
                float w = g.MeasureString(text, f).Width;
                g.DrawString(text, f, b, x - (int)(align==LRAlign.Right? w : w/2), y);
            }
            g.SetClip(t);
        }
        //ĂW̒_ɂȂ悤ɕ`悷
        public static void MiddleCenter(Graphics g, string text, Font f, Brush b, int x, int y) {
            SizeF sz = g.MeasureString(text, f);
            g.DrawString(text, f, b, x-sz.Width/2, y-sz.Height/2);
        }
        public static void MiddleLeft(Graphics g, string text, Font f, Brush b, Rectangle rect) {
            SizeF sz = g.MeasureString(text, f);
            g.DrawString(text, f, b, new RectangleF(rect.Left, rect.Top + ((float)rect.Height-sz.Height)/2, rect.Width, sz.Height));
        }
        public static void MiddleLeft(Graphics g, string text, Font f, Brush b, int x, int y) {
            SizeF sz = g.MeasureString(text, f);
            g.DrawString(text, f, b, (float)x, ((float)y) - sz.Height/2);
        }
        //Nbv
        public static void MiddleLeftWithClip(Graphics g, string text, Font f, Brush b, int x, int y, int width) {
            SizeF sz = g.MeasureString(text, f);
            Rectangle clip = new Rectangle(x, y-(int)sz.Height/2, width, (int)sz.Height);
            RectangleF t = g.ClipBounds;
            g.SetClip(clip);
            g.DrawString(text, f, b, (float)x, ((float)y) - sz.Height/2);
            g.SetClip(t);
        }
        public static void MiddleRight(Graphics g, string text, Font f, Brush b, Rectangle rect) {
            SizeF sz = g.MeasureString(text, f);
            g.DrawString(text, f, b, new RectangleF(rect.Right - sz.Width, rect.Top + ((float)rect.Height-sz.Height)/2, sz.Width, sz.Height));
        }
        public static void MiddleRight(Graphics g, string text, Font f, Brush b, int x, int y) {
            SizeF sz = g.MeasureString(text, f);
            g.DrawString(text, f, b, ((float)x) - sz.Width, ((float)y) - sz.Height/2);
        }

        /*
        public static void DrawStringToRight(Graphics g, string s, Font f, Brush b, ref int x, int y) {
            SizeF szf = g.MeasureString(s, f);
            g.DrawString(s, f, b, x, y);
            x += (int)szf.Width;
        }
        */
        //pĕʂ̕`ߍWԂ
        public static void MiddleLeft(Graphics g, string s, Font f, Brush b, ref int x, int y) {
            SizeF szf = g.MeasureString(s, f);
            g.DrawString(s, f, b, x, y - szf.Height/2);
            x += (int)szf.Width;
        }
        public static void MiddleRight(Graphics g, string s, Font f, Brush b, ref int x, int y) {
            SizeF sz = g.MeasureString(s, f);
            g.DrawString(s, f, b, ((float)x) - sz.Width, ((float)y) - sz.Height/2);
            x = x - (int)sz.Width;
        }
        //(x,y)ɕ`ĉE[x
        public static void ToRight(Graphics g, string s, Font f, Brush b, ref int x, int y) {
            SizeF szf = g.MeasureString(s, f);
            g.DrawString(s, f, b, x, y);
            x += (int)szf.Width;
        }
        //(x,y)EɂȂ悤ɕ`č[
        public static void ToLeft(Graphics g, string s, Font f, Brush b, ref int x, int y) {
            SizeF sz = g.MeasureString(s, f);
            g.DrawString(s, f, b, ((float)x) - sz.Width, y);
            x = x - (int)sz.Width;
        }

        // (x,y)`` corner ł悤Ȉʒuɏ
        public static void OnCorner(Graphics g, string text, Font f, Brush b, int x, int y, Corners corner) {
            OnCorner(g, text, f, b, x, y, corner, null);
        }
        //̉o[W(nullŐȂ)
        public static void OnCorner(Graphics g, string text, Font f, Brush b, int x, int y, Corners corner, Pen pen) {
            SizeF sz = g.MeasureString(text, f);
            float fx = (corner==Corners.TopLeft || corner==Corners.BottomLeft)? (float)x : x - sz.Width;
            float fy = (corner==Corners.TopLeft || corner==Corners.TopRight)? (float)y : y - sz.Height;
            g.DrawString(text, f, b, fx, fy);
            if(pen!=null)
                g.DrawLine(pen, fx, fy+sz.Height, fx+sz.Width, fy+sz.Height);
        }
        public static float GetFontHeight(Font f, Graphics g) {
            return g.MeasureString("A", f).Height;
        }

        //؂グ
        public static int GetFontHeightAsInt(Font f, Graphics g) {
            return (int)Math.Ceiling(g.MeasureString("A", f).Height);
        }
    }
}
