﻿/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id$
 * $DateTime$
 * 
 * スクリーニングと自動売買検証のオプション
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;
using System.Windows.Forms;
using System.Drawing;

using Bellagio.Chart;
using Bellagio.Forms;
using Bellagio.Values;
using Travis.LocationOperation;
using Poderosa.Usability;
using Poderosa.Preferences;

namespace Bellagio.Screening {
    public class ScreeningAndAutoTradingOptionPanelExtension : IOptionPanelExtension {
        private ScreeningAndAutoTradingOptionPanel _panel;

        public string Caption {
            get {
                return "売買検証";
            }
        }

        public System.Drawing.Image Icon {
            get {
                return BellagioRoot.CommonIcons.LargeSessions.GetBitmap(2);
            }
        }

        public string[] PreferenceFolderIDsToEdit {
            get {
                return new string[] { "tactico.screening" };
            }
        }

        public Panel ContentPanel {
            get {
                return _panel;
            }
        }

        public void InitiUI(IPreferenceFolder[] values) {
            if(_panel==null) _panel = new ScreeningAndAutoTradingOptionPanel();
            _panel.InitUI(values[0]);
        }

        public bool Commit(IPreferenceFolder[] values) {
            return _panel.Commit(values[0]);
        }

        public void Dispose() {
            if(_panel!=null) _panel.Dispose();
        }

    }

    public class ScreeningAndAutoTradingOptionPanel : Panel {
        private Label _maximumDateLengthLabel;
        private TextBox _maximumDateLengthBox;
        private Label _maximumDateLengthLabel2;
        private Label _autoTradingDateDisplayLabel;
        private ComboBox _autoTradingDateDisplayBox;
        private Label _chartSchemaForScreeningResultActivationLabel;
        private ComboBox _chartSchemaForScreeningResultActivationBox;
        private CheckBox _MMFQuoteAutoUpdateBox;

        public ScreeningAndAutoTradingOptionPanel() {
            int x1 = 8, x2 = 264;
            int w1 = x2 - 8;
            int h1 = 19;
            int y = 8;
            
            _maximumDateLengthLabel = FormUtil.CreateLabel("スクリーニング/自動売買検証で有効な最大日数");
            _maximumDateLengthBox = new TextBox();
            _maximumDateLengthLabel.Location = new Point(x1, y+2);
            _maximumDateLengthLabel.Size = new Size(w1, h1);
            _maximumDateLengthBox.Location = new Point(x2, y);
            _maximumDateLengthBox.Size = new Size(80, h1);

            y += h1;
            _maximumDateLengthLabel2 = FormUtil.CreateLabel("(数値を大きくすると長期の検証が可能になりますが,\nメモリ消費量が増大します)");
            _maximumDateLengthLabel2.Location = new Point(x1, y);
            _maximumDateLengthLabel2.Size = new Size(w1, 36);
            
            y += 48;
            _autoTradingDateDisplayLabel = FormUtil.CreateLabel("自動売買検証の結果一覧での日付表示");
            _autoTradingDateDisplayLabel.Location = new Point(x1, y);
            _autoTradingDateDisplayLabel.Size = new Size(w1, h1);
            _autoTradingDateDisplayBox = FormUtil.CreateComboBox("条件成立時", "取引時");
            _autoTradingDateDisplayBox.Location = new Point(x2, y);
            _autoTradingDateDisplayBox.Size = new Size(104, h1);

            y+= 28;
            _chartSchemaForScreeningResultActivationLabel = FormUtil.CreateLabel("スクリーニング/自動売買検証結果をクリック\nしたとき開くチャート");
            _chartSchemaForScreeningResultActivationLabel.Location = new Point(x1, y+2);
            _chartSchemaForScreeningResultActivationLabel.Size = new Size(w1, h1+16);
            _chartSchemaForScreeningResultActivationBox = FormUtil.CreateComboBox();
            _chartSchemaForScreeningResultActivationBox.Location = new Point(x2, y+8);
            _chartSchemaForScreeningResultActivationBox.Size = new Size(104, h1);

            y+= 44;
            _MMFQuoteAutoUpdateBox = new CheckBox();
            _MMFQuoteAutoUpdateBox.Text = "日足データ更新時にデータベースを自動作成する(&B)\n(チェックするとスクリーニング等での事前処理が不要になりますが、日々のデータ更新がやや遅くなります)";
            _MMFQuoteAutoUpdateBox.Location = new Point(x1, y);
            _MMFQuoteAutoUpdateBox.Size = new Size(400, h1+32);


            this.Controls.AddRange(new Control[] {
                _maximumDateLengthLabel, _maximumDateLengthBox, _maximumDateLengthLabel2, _autoTradingDateDisplayLabel, _autoTradingDateDisplayBox, _chartSchemaForScreeningResultActivationLabel, _chartSchemaForScreeningResultActivationBox , _MMFQuoteAutoUpdateBox});
        }

        private string[] _dailyChartIDs;
        public void InitUI(IPreferenceFolder f) {
            ScreeningPreferences pr = ScreeningPlugin.Instance.Preferences;

            List<ChartSchema> schemas = new List<ChartSchema>();
            BellagioRoot.SchemaRoot.CollectStaticChartSchema(schemas);
            int count = 0;
            int selected = -1;
            List<string> dailyChartIDs = new List<string>();
            string current_daily_chart = f.ChildAt(pr.ChartSchemaForScreeningResultActivationItem.Index).AsItem().AsString().Value;
            foreach(ChartSchema sc in schemas) {
                if(sc.ChartUnit==Quote.QuoteUnit.Daily) {
                    dailyChartIDs.Add(sc.FullID);
                    _chartSchemaForScreeningResultActivationBox.Items.Add(sc.description.ParseMandatoryString());
                    if(sc.FullID==current_daily_chart) selected = count;
                    count++;
                }
            }
            _dailyChartIDs = dailyChartIDs.ToArray();
            _chartSchemaForScreeningResultActivationBox.SelectedIndex = selected;

            _maximumDateLengthBox.Text = f.ChildAt(pr.MaximumDailyDataLengthItem.Index).AsItem().AsInt().Value.ToString();
            _autoTradingDateDisplayBox.SelectedIndex =
                (int)Poderosa.ParseUtil.ParseEnum<AutoTradingDateDisplay>(f.ChildAt(pr.AutoTradingDateDisplayItem.PreferenceItem.Index).AsItem().AsString().Value, AutoTradingDateDisplay.Condition);

            _MMFQuoteAutoUpdateBox.Checked = f.ChildAt(pr.MMFQuoteAutoUpdateItem.Index).AsItem().AsBool().Value;
        }

        public bool Commit(IPreferenceFolder f) {
            ScreeningPreferences pr = ScreeningPlugin.Instance.Preferences;
            int maxlen;
            if(!Int32.TryParse(_maximumDateLengthBox.Text, out maxlen)) {
                BUtil.ShowWarningMessageBox(this, "数値を指定してください");
                return false;
            }

            f.ChildAt(pr.MaximumDailyDataLengthItem.Index).AsItem().AsInt().Value = maxlen;
            f.ChildAt(pr.AutoTradingDateDisplayItem.PreferenceItem.Index).AsItem().AsString().Value = 
                ((AutoTradingDateDisplay)_autoTradingDateDisplayBox.SelectedIndex).ToString();
            f.ChildAt(pr.ChartSchemaForScreeningResultActivationItem.Index).AsItem().AsString().Value =
                _dailyChartIDs[_chartSchemaForScreeningResultActivationBox.SelectedIndex];

            f.ChildAt(pr.MMFQuoteAutoUpdateItem.Index).AsItem().AsBool().Value = _MMFQuoteAutoUpdateBox.Checked;
            return true;
        }
    }

}
