/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Ordering/TradeNotificationDrawing.cs#10 $
 * $DateTime: 2008/02/22 14:12:23 $
 * 
 * ʒm̕`
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;
using System.Drawing.Imaging;
using System.Drawing.Text;
using System.Diagnostics;

using Poderosa;

using Bellagio.Values;
using Bellagio.Drawing;
using Travis;
using Travis.LocationOperation;

namespace Bellagio.Ordering {
    //ɖAEɏڍׁAŜɑ傫liƐʁAƂ̂{CAEg

    public class TradeNotificationDrawingSettings : DrawingSettingsBase {
        public DSInt orderAreaHeight; //㕔̖̍
        public DSInt tradeAreaHeight; //ʁEP\
        public DSInt descriptionAreaWidth; //ʗ
        public DSInt stockAreaWidth; //
        public DSInt conditionAreaWidth; //

        public DSFont stockFont; //\tHg
        public DSFont labelFont; //ڃtHg
        public DSFont numberFont; //ltHg
        public DSFont tradeFont; //ʁEP\tHg
        public DSFont tradeNumberFont; //ʁEPltHg
        public DSInt numberFontYOffset; //ltHgCAEg
        public DSInt tradeNumberFontYOffset; //ltHgCAEg

        public DSBrush backColor; //wiF
        public DSPenStyle frameColor; //g̐F
        public DSPenStyle delimiterColor; //tB[h؂̐F
        public DSBrush labelColor; //W̃xF
        public DSBrush genbutsuColor;    //̐F
        public DSBrush shinnyoColor;     //Mp̐F
        public DSBrush buyColor; //tF
        public DSBrush sellColor; //tF
        public DSBrush numberColor; //lF

        public TradeNotificationDrawingSettings(string id)
            : base(id) {
        }

        protected override void CreateElements() {
            orderAreaHeight = DefinePositiveInt("orderAreaHeight", 40);
            tradeAreaHeight = DefinePositiveInt("tradeAreaHeight", 52);
            descriptionAreaWidth = DefinePositiveInt("descriptionAreaWidth", 64);
            stockAreaWidth = DefinePositiveInt("stockAreaWidth", 200);
            conditionAreaWidth = DefinePositiveInt("conditionAreaWidth", 120);

            stockFont = DefineFont("stockFont", DSFont.GenericFontName, 10.5F);
            labelFont = DefineFont("labelFont", DSFont.GenericFontName, 10.5F);
            numberFont = DefineFont("numberFont", DSFont.GenericFontName, 10.5F);
            tradeFont = DefineFont("tradeFont", DSFont.GenericFontName, 16);
            tradeNumberFont = DefineFont("tradeNumberFont", "OCR A Std", 18, FontStyle.Bold);
            numberFontYOffset = DefineInt("numberFontYOffset", 0);
            tradeNumberFontYOffset = DefineInt("tradeNumberFontYOffset", -4);

            backColor = DefineBrush("backColor", Color.Black);

            frameColor = DefinePenStyle("frameColor", Color.DarkOliveGreen, BPenStyle.DashStyle.Dot, 1);
            delimiterColor = DefinePenStyle("delimiterColor", Color.DarkOliveGreen, BPenStyle.DashStyle.Dot, 1);
            labelColor = DefineBrush("labelColor", Color.White);
            buyColor = DefineBrush("buyColor", Color.Red);
            sellColor = DefineBrush("sellColor", Color.LightBlue);
            genbutsuColor = DefineBrush("genbutsuColor", Color.FromArgb(0xe0, 0xff, 0xff));
            shinnyoColor = DefineBrush("shinnyoColor", Color.FromArgb(0xfe, 0xff, 0xe0));

            numberColor = DefineBrush("numberColor", Color.Gold);
        }
    }

    public class TradeNotificationDrawing {
        private TradeNotificationDrawingSettings _settings;
        private SubSettings _subSettings;
        private TradeOrderItem _orderItem;
        private TradeOrderItem.Element _tradeElement;
        private IOrderItemFormatter _formatter;
        /*
        private Bitmap _priceBitmap;
        private Bitmap _volumeBitmap;
        private BlurFilter[] _priceBlurFilters;
        private BlurFilter[] _volumeBlurFilters;
        */
        //SettingsvZ\Ȃ̂LbV
        private class SubSettings {
            public BRect frameRect;
            public BRect descriptionRect;
            public BRect stockRect;
            public BRect timeRect;
            public BRect conditionRect;
            public BRect tradeRect;

            public SubSettings() {
                frameRect = new BRect();
                descriptionRect = new BRect();
                stockRect = new BRect();
                timeRect = new BRect();
                conditionRect = new BRect();
                tradeRect = new BRect();
            }

        }

        public TradeNotificationDrawing() {
        }
        public const int MaxAnimationStep = 12; //݂̃Aj[V

        public TradeNotificationDrawingSettings DrawingSettings {
            get {
                return _settings;
            }
            set {
                _settings = value;
                _subSettings = null;
            }
        }
        //̒lςƂ͂ĂԁBxĂׂΉxłDrawĂׂ悤ɂȂ
        public void SetOrderItem(TradeOrderItem item, TradeOrderItem.Element elem, IOrderItemFormatter formatter, Rectangle rect) {
            if(_subSettings==null) CreateSubSettings(rect);

            _formatter = formatter;
            _orderItem = item;
            _tradeElement = elem;
            /*
            const int blur_margin_w = 5;
            const int blur_margin_h = 13;
            const int unit_char_width = 35; //'~' ''̒Pʕ\p̕
            const int batsu_width = 10; //~̕


            const int margin = 10;
            int width = _priceBitmap.Width + _volumeBitmap.Width + margin;
            int height = _priceBitmap.Height;
            Rectangle r = _subSettings.tradeRect.Value;
            _subSettings.tradePriceRect = new Rectangle(r.Left + (r.Width-width)/2, r.Top + (r.Height-height)/2 + 3, _priceBitmap.Width, _priceBitmap.Height);
            _subSettings.tradeVolumeRect = new Rectangle(_subSettings.tradePriceRect.Right + margin, _subSettings.tradePriceRect.Top, _volumeBitmap.Width, _volumeBitmap.Height);
            */
            //_subSettings.tradeResultRect = new Rectangle(_subSettings.tradeVolumeRect.Right + 10, _subSettings.tradeRect.Top, 50, _volumeBitmap.Height);

            //CreateBlurFilters(ref _priceBlurFilters, _priceBitmap.Size, BlurFilter.Mode.BlurToBack, 0);
            //CreateBlurFilters(ref _volumeBlurFilters, _volumeBitmap.Size, BlurFilter.Mode.BlurToBack, 0);
        }

        public void Draw(Graphics g, int step) {
            try {
                Debug.Assert(_subSettings!=null);
                int delimiter_margin = 3;
                Rectangle r;

                //g
                Pen delimiter_pen = _settings.delimiterColor.P;
                Pen frame_pen = _settings.delimiterColor.P;
                RoundRectUtil.Draw(g, frame_pen, _subSettings.frameRect.Value, 4);
                //f~^
                r = _subSettings.stockRect.Value;
                g.DrawLine(delimiter_pen, r.Left, r.Top+delimiter_margin, r.Left, r.Bottom-delimiter_margin);
                g.DrawLine(delimiter_pen, r.Right, r.Top+delimiter_margin, r.Right, r.Bottom-delimiter_margin);
                r = _subSettings.tradeRect.Value;
                g.DrawLine(delimiter_pen, r.Left + delimiter_margin, r.Top, r.Right-delimiter_margin, r.Top);

                // 1/4
                int q_pitch = _subSettings.stockRect.Height/4; 

                //tort
                DrawStringUtil.MiddleCenter(g, _formatter.FormatOrderDealTypeCategory(_orderItem.DealType), _settings.stockFont.F, _orderItem.DealType==OrderDealType.Genbutsu? _settings.genbutsuColor.B : _settings.shinnyoColor.B, _subSettings.descriptionRect.CenterX, _subSettings.descriptionRect.CenterY-q_pitch);
                DrawStringUtil.MiddleCenter(g, _formatter.FormatTradeDescription(_orderItem.DealType, _orderItem.LongShort, _orderItem.NewOrClose), _settings.stockFont.F, _orderItem.IsBuying? _settings.buyColor.B : _settings.sellColor.B, _subSettings.descriptionRect.CenterX, _subSettings.descriptionRect.CenterY+q_pitch);

                //R[hƖO
                DrawStringUtil.MiddleLeftWithClip(g, _orderItem.Stock.Profile.Code, _settings.labelFont.F, _settings.labelColor.B, _subSettings.stockRect.Left, _subSettings.stockRect.Top + q_pitch, _subSettings.stockRect.Width);
                string name = _orderItem.Stock.Profile.Name;
                Font f = name.Length>5? _settings.labelFont.F : _settings.stockFont.F;
                DrawStringUtil.MiddleLeftWithClip(g, name, f, _settings.labelColor.B, _subSettings.stockRect.Left, _subSettings.stockRect.CenterY + q_pitch, _subSettings.stockRect.Width);

                //EwlE
                int x = _subSettings.conditionRect.Left;
                int y = _subSettings.conditionRect.Top;
                DrawStringUtil.ToRight(g, _formatter.FormatOrderCondition(_orderItem.Condition), _settings.labelFont.F, _settings.labelColor.B, ref x, y);
                if(OrderingUtil.IsSashineRequired(_orderItem.Condition)) {
                    x += 5;
                    DrawStringUtil.ToRight(g, _orderItem.AdjustPriceI(_orderItem.Sashine).ToString("N0"), _settings.numberFont.F, _settings.numberColor.B, ref x, y + _settings.numberFontYOffset.V);
                    DrawStringUtil.ToRight(g, "~", _settings.labelFont.F, _settings.labelColor.B, ref x, y);
                }

                //ƂATextContrast͂ÔقNAA12ƂƐׂ


                //PEʂ̓Aj[VB
                Debug.Assert(step < MaxAnimationStep);

                const int batsu_width = 30;
                string price_str = _orderItem.AdjustPriceI(_tradeElement.Price).ToString("N0");
                SizeF price_size = g.MeasureString(price_str, _settings.tradeNumberFont.F);
                string volume_str = _tradeElement.Volume.ToString("N0");
                SizeF volume_size = g.MeasureString(volume_str, _settings.tradeNumberFont.F);
                SizeF char_size = g.MeasureString("~", _settings.tradeFont.F);
                float total_width = price_size.Width + volume_size.Width + char_size.Width*2 + batsu_width; //2{"~"""̕A30́~}[W

                Brush number_br = new SolidBrush(DrawingUtil.ProportionalColor(_settings.backColor.col, _settings.numberColor.col, step / 12.0));
                Brush label_br  = new SolidBrush(DrawingUtil.ProportionalColor(_settings.backColor.col, _settings.labelColor.col, step / 12.0));
                Pen batsu_pen = new Pen(DrawingUtil.ProportionalColor(_settings.backColor.col, _settings.labelColor.col, step / 12.0), 2);

                x = _subSettings.tradeRect.CenterX - (int)(total_width/2);
                y = _subSettings.tradeRect.CenterY - (int)(price_size.Height/2) + 11 - step;

                DrawStringUtil.ToRight(g, price_str, _settings.tradeNumberFont.F, number_br, ref x, y + _settings.tradeNumberFontYOffset.V);
                DrawStringUtil.ToRight(g, "~", _settings.tradeFont.F, label_br, ref x, y);

                //~
                Rectangle batsu_rect = new Rectangle(x+10, y+6, 10, 10);
                g.DrawLine(batsu_pen, batsu_rect.Left, batsu_rect.Top, batsu_rect.Right, batsu_rect.Bottom);
                g.DrawLine(batsu_pen, batsu_rect.Left, batsu_rect.Bottom, batsu_rect.Right, batsu_rect.Top);
                x += batsu_width;

                DrawStringUtil.ToRight(g, volume_str, _settings.tradeNumberFont.F, number_br, ref x, y + _settings.tradeNumberFontYOffset.V);
                DrawStringUtil.ToRight(g, _orderItem.Stock.Profile.VolumeUnitString, _settings.tradeFont.F, label_br, ref x, y);

                number_br.Dispose();
                label_br.Dispose();
            }
            catch(Exception ex) {
                RuntimeUtil.ReportException(ex);
            }
        }

        private void CreateSubSettings(Rectangle rect) {

            Debug.Assert(_settings!=null);
            _subSettings = new SubSettings();
            //_subSettings.frameRect.Set(rect.Left, rect.Top, _settings.descriptionAreaWidth+_settings.stockAreaWidth+_settings.conditionAreaWidth, _settings.orderAreaHeight+_settings.tradeAreaHeight);
            _subSettings.frameRect.Set(rect);
            RectOp op = new RectangleOperatorBuilder()
                .SplitFixed(SplitDir.Top, _settings.orderAreaHeight.V)
                    .SplitFixed(SplitDir.Left, _settings.descriptionAreaWidth.V).ProbeBRect(_subSettings.descriptionRect).CloseBranch()
                    .SplitFixed(SplitDir.Left, _settings.stockAreaWidth.V).ProbeBRect(_subSettings.stockRect).CloseBranch()
                    .SplitFixed(SplitDir.Top, _settings.orderAreaHeight.V/2).ProbeBRect(_subSettings.timeRect).CloseBranch().ProbeBRect(_subSettings.conditionRect)
                .CloseBranch().ProbeBRect(_subSettings.tradeRect)
                .Finish();
            op.Rect(_subSettings.frameRect.Value);

        }
        private void CreateBlurFilters(ref BlurFilter[] result, Size sz, BlurFilter.Mode mode, uint backcolor) {
            result = new BlurFilter[4];
            result[0] = new BlurFilter(sz.Width, sz.Height, 11, 11, 1, 3.0, 1);
            result[1] = new BlurFilter(sz.Width, sz.Height, 11, 11, 1, 2.5, 1);
            result[2] = new BlurFilter(sz.Width, sz.Height, 11, 11, 1, 2.0, 1);
            result[3] = new BlurFilter(sz.Width, sz.Height, 11, 11, 1, 1.5, 1);
            for(int i=0; i<result.Length; i++)
                result[i].SetMode(mode, backcolor);
        }
    }
}
