/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Chart/SpecialIndicatorPaint.cs#6 $
 * $DateTime: 2007/12/28 19:23:38 $
 */
using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Drawing;
using System.Diagnostics;

using Bellagio.Forms;
using Bellagio.Common;

//ȃCWP[^`sB݂͈ڂ̉_̂݁B
//RuntimeIndicatorۗLIuWFNg
namespace Bellagio.Chart {
    public interface ISpecialIndicatorPaint {
        string Name { get; }
        void AddElement(RuntimeIndicatorElement element, IndicatorDefinition.Element source);
        bool IsAssociated(RuntimeIndicatorElement element);
        void CheckComplete(); //ݒ肪ƂmFBRuntimeIndicatorSet̊m莞ɌĂ΂Bُ킪ΗO𓊂
        void Draw(IChartDataSource data, ChartDrawing chart, Graphics g, ref CHARTPOSITION position, ref CHARTPOSITION left, int x1); //x͑̈vZ\
    }

    internal static class SpecialIndicatorPaintLib {
        private static List<ISpecialIndicatorPaint> _items;
        static SpecialIndicatorPaintLib() {
            _items = new List<ISpecialIndicatorPaint>();
            _items.Add(new IchimokuKumo()); //ڋύt\̉_B݂͂ꂾ
        }

        public static ISpecialIndicatorPaint GetFromName(string name) {
            if(name=="ڋύt\̉_")
                return new IchimokuKumo();
            throw new BellagioException(String.Format("{0} ͕sK؂ł", name));
        }
    }

    public class IchimokuKumo : ISpecialIndicatorPaint {
        private RuntimeIndicatorElement _spanA;
        private RuntimeIndicatorElement _spanB;

        public IchimokuKumo() {
            _spanA = null;
            _spanB = null;
        }

        public string Name {
            get {
                return "ڋύt\̉_";
            }
        }

        public void AddElement(RuntimeIndicatorElement element, IndicatorDefinition.Element source) {
            string id = source.id.ParseOptionalString("");
            if(id=="sXp`")
                _spanA = element;
            else if(id=="sXpa")
                _spanB = element;
        }

        public void CheckComplete() {
            //`aAddElementŗĂ邱ƂmFAʏ`~
            if(_spanA==null || _spanB==null)
                throw new BellagioException("sXpo^Ă܂");
        }

        public bool IsAssociated(RuntimeIndicatorElement element) {
            return _spanA==element || _spanB==element;
        }

        //lp`̉EXWĂ
        public void Draw(IChartDataSource data, ChartDrawing chart, Graphics g, ref CHARTPOSITION position, ref CHARTPOSITION left, int x) {
            if(!_spanA.Visible || !_spanB.Visible) return;

            double va1 = data.GetIndicatorValue(_spanA, position);
            double vb1 = data.GetIndicatorValue(_spanB, position);
            if(Double.IsNaN(va1) || Double.IsNaN(vb1)) return;
            double va0 = data.GetIndicatorValue(_spanA, left);
            double vb0 = data.GetIndicatorValue(_spanB, left);
            if(Double.IsNaN(va0) || Double.IsNaN(vb0)) return;
            
            LinearTranslator tr = chart.ChartScaleInfo.PriceTrnanslator;
            if(tr==null) return;

            int candle_pitch = chart.ChartDrawingSettings.candlePitch;
            int hc = candle_pitch / 2;
            int x0 = x - candle_pitch + hc;
            int x1 = x + hc;
            int ya0 = (int)tr.Translate(va0);
            int yb0 = (int)tr.Translate(vb0);
            int ya1 = (int)tr.Translate(va1);
            int yb1 = (int)tr.Translate(vb1);

            //܂łŎlp`m
            if(va0>=vb0 && va1>=vb1) //A
                PaintKumo(g, _spanA.BPenStyle.color, x0, ya0, x1, ya1, x1, yb1, x0, yb0);
            else if(va0<=vb0 && va1<=vb1) //B
                PaintKumo(g, _spanB.BPenStyle.color, x0, yb0, x1, yb1, x1, ya1, x0, ya0);
            else { //BRp`Q`B߂ǂȂ
                double r = (double)(Math.Abs(ya0-yb0)) / (double)(Math.Abs(ya0-yb0)+Math.Abs(ya1-yb1)); //z銄
                int cx = x1 - (int)((double)chart.ChartDrawingSettings.candlePitch*(1-r));
                int cy = (int)(ya1*r + ya0*(1-r));
                if(va0 >= vb0) {
                    PaintKumo3(g, _spanA.BPenStyle.color, cx, cy, x0, ya0, x0, yb0);
                    PaintKumo3(g, _spanB.BPenStyle.color, cx, cy, x1, yb1, x1, ya1);
                }
                else {
                    PaintKumo3(g, _spanB.BPenStyle.color, cx, cy, x0, yb0, x0, ya0);
                    PaintKumo3(g, _spanA.BPenStyle.color, cx, cy, x1, ya1, x1, yb1);
                }
            }

        }

        private void PaintKumo(Graphics g, Color col, int x0, int y0, int x1, int y1, int x2, int y2, int x3, int y3) {
            IntPtr hdc = g.GetHdc();
            Win32.POINT[] points = new Win32.POINT[4];
            points[0].x = x0;
            points[0].y = y0;
            points[1].x = x1;
            points[1].y = y1;
            points[2].x = x2;
            points[2].y = y2;
            points[3].x = x3;
            points[3].y = y3;

            IntPtr rgn = Win32.CreatePolygonRgn(points, 4, 2); //2WINDING
            IntPtr brush = Win32.CreateSolidBrush(Win32.ToCOLORREF(col));
            Win32.FillRgn(hdc, rgn, brush);
            Win32.DeleteObject(brush);
            Win32.DeleteObject(rgn);
            g.ReleaseHdc(hdc);
        }
        //Rp`
        private void PaintKumo3(Graphics g, Color col, int x0, int y0, int x1, int y1, int x2, int y2) {
            IntPtr hdc = g.GetHdc();
            Win32.POINT[] points = new Win32.POINT[3];
            points[0].x = x0;
            points[0].y = y0;
            points[1].x = x1;
            points[1].y = y1;
            points[2].x = x2;
            points[2].y = y2;

            IntPtr rgn = Win32.CreatePolygonRgn(points, 3, 2); //2WINDING
            IntPtr brush = Win32.CreateSolidBrush(Win32.ToCOLORREF(col));
            Win32.FillRgn(hdc, rgn, brush);
            Win32.DeleteObject(brush);
            Win32.DeleteObject(rgn);
            g.ReleaseHdc(hdc);
        }
    }
}
