package noguchi.Shadowinkun;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import android.app.Activity;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Intent;
import android.media.MediaPlayer;
import android.media.MediaRecorder;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.provider.MediaStore;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.SeekBar;
import android.widget.TextView;
import android.widget.Toast;

enum RepeatMode {NONE, SEC, THIS, ALL};

public class Shadowinkun extends Activity 
	implements Button.OnClickListener,
	Button.OnTouchListener,
	MediaPlayer.OnCompletionListener,
	SeekBar.OnSeekBarChangeListener,
	CheckBox.OnCheckedChangeListener {
	
	private final int REPEAT_INTERVAL = 1000; // Used in showing progress
	private final int REPEAT_INTERVAL2 = 10; // Used in forward/rewind
	private final int DEFAULT_FORWARD_OR_REWIND_SPEED = 500;
	private final int FORWARD_OR_REWIND_ACCEL = 100;
	
	private String[] extension = { ".mp3", ".3gp", ".wav" };

    private Handler handler = new Handler();
    private Runnable runnable; // Used in showing progress
    private Runnable runnable2; // Used in forward/rewind
    private Runnable runnable3; // Used in manual mode

	public MediaRecorder mrec = null;

	private Button play1 = null;
	private Button play2 = null;
	private Button pause1 = null;
	private Button pause2 = null;
	private Button rewind1 = null;
	private Button rewind2 = null;
	private Button forward1 = null;
	private Button forward2 = null;
	private Button eject = null;
	private Button secStart = null;
	private Button secEnd = null;
	private Button repeat = null;
	
	private TextView showRecordView = null;
	private TextView secView1 = null;
	private TextView secView2 = null;
	private TextView secView3 = null;
	private TextView titleView1 = null;
	private TextView titleView2 = null;
	
	private SeekBar seekBar1 = null;
	private SeekBar seekBar2 = null;
	private boolean isSeekBarTouched1 = false;
	private boolean isSeekBarTouched2 = false;
	
	private CheckBox recordChkBox = null;
	
	private static final int REQUEST_FILESELECTOR = 0;
	
	private MediaPlayer[] mplayer;	
	private boolean[] isPlay;
	private boolean[] isPause;
	private File[] filename;
	
	private String length1 = null;
	private String length2 = null;
	
	private int forwardOrRewindSpeed = 0;
	private int forwardOrRewindPlayerIndex = 0;
	
	private long recordStartTime;
	
	private File todayFolder;
	private File audiofile;
	private boolean isRecording = false;
	
	private int startPos = -1;
	private int endPos = -1;
	RepeatMode repeatMode = RepeatMode.NONE;
	
	// Context menu
	private final static int MENU_ID_MENU1 = (Menu.FIRST + 1);

	// Manual mode
	private boolean isManual = false;
	private int pausePos = -1;
	private int nextPos = -1;
	
    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
       
        // Create work folder
    	try {
    		
    		boolean isFolderCreated = true;
	    	File sdFolder = Environment.getExternalStorageDirectory();
	    	File rootFolder = new File(sdFolder, "Shadowin-kun");
	    	if (!rootFolder.exists()) 
	    		isFolderCreated = isFolderCreated && rootFolder.mkdir();
	    	DateFormat df = new SimpleDateFormat("yyyyMMdd");
	    	String today = df.format(new Date());
	    	todayFolder = new File(rootFolder, today);
	    	if (!todayFolder.exists()) 
	    		isFolderCreated = isFolderCreated && todayFolder.mkdir();
	    	
	    	if (!isFolderCreated)
	            Toast.makeText(this, R.string.FileCreateFailed, Toast.LENGTH_LONG).show();	    		
    	}
    	catch (Exception ex)
    	{
            Toast.makeText(this, R.string.FileCreateFailed, Toast.LENGTH_LONG).show();
    	}
    	
    	getWindow().addFlags(WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON);

        // Initialize recorder and player objects
        mrec = new MediaRecorder();   
        
        mplayer = new MediaPlayer[2];
        mplayer[0] = new MediaPlayer();
        mplayer[1] = new MediaPlayer();
        
        isPlay = new boolean[2];
        isPlay[0] = false;
        isPlay[1] = false;

        isPause = new boolean[2];
        isPause[0] = false;
        isPause[1] = false;

        filename = new File[2];
        filename[0] = null;
        filename[1] = null;
        
        // Initialize buttons
        play1 = (Button)findViewById(R.id.Play01);
        play2 = (Button)findViewById(R.id.Play02);
        pause1 = (Button)findViewById(R.id.Pause01);
        pause2 = (Button)findViewById(R.id.Pause02);
        rewind1 = (Button)findViewById(R.id.Rewind01);
        rewind2 = (Button)findViewById(R.id.Rewind02);
        forward1 = (Button)findViewById(R.id.Forward01);
        forward2 = (Button)findViewById(R.id.Forward02);
        eject = (Button)findViewById(R.id.Eject01);
        secStart = (Button)findViewById(R.id.Start01);
        secEnd = (Button)findViewById(R.id.End01);
        repeat = (Button)findViewById(R.id.Repeat01);
        
        recordChkBox = (CheckBox)findViewById(R.id.CheckBox01);
        
        showRecordView = (TextView)findViewById(R.id.Recording01);
        titleView1 = (TextView)findViewById(R.id.TextView02);
        titleView2 = (TextView)findViewById(R.id.TextView03);
        	
        secView1 = (TextView)findViewById(R.id.SecView01);
        secView2 = (TextView)findViewById(R.id.SecView02);
        secView3 = (TextView)findViewById(R.id.SecView03);
        
        seekBar1 = (SeekBar)findViewById(R.id.SeekBar01);
        seekBar2 = (SeekBar)findViewById(R.id.SeekBar02);

        
        play1.setText("▶");
        play2.setText("▶");
        showRecordView.setText("");
        repeat.setText(RepeatMode.NONE.toString());
        
        // Set listeners
        play1.setOnClickListener(this);
        play2.setOnClickListener(this);
        pause1.setOnClickListener(this);
        pause2.setOnClickListener(this);

        forward2.setOnClickListener(this);
        rewind2.setOnClickListener(this);
        
        rewind1.setOnTouchListener(this);
        rewind2.setOnTouchListener(this);
        forward1.setOnTouchListener(this);
        forward2.setOnTouchListener(this);        
		pause2.setOnTouchListener(this);

        eject.setOnClickListener(this);
        secStart.setOnClickListener(this);
        secEnd.setOnClickListener(this);
        repeat.setOnClickListener(this);
        
        seekBar1.setOnSeekBarChangeListener(this);
        seekBar2.setOnSeekBarChangeListener(this);
        
        recordChkBox.setOnCheckedChangeListener(this);
        
        // Set the thread which is used to show the progress
        runnable = new Runnable() {
            @Override
            public void run() {            	
                countProgress();           
                handler.postDelayed(this, REPEAT_INTERVAL);
            }
        };
        
        // Set the thread which is used in forward/rewind
        runnable2 = new Runnable() {
            @Override
            public void run() {            	
                forwardOrRewindPosition();    
                countProgress();
                handler.postDelayed(this, REPEAT_INTERVAL2);
            }
        };
        
        // Set the thread which is used in manual mode
        runnable3 = new Runnable() {
            @Override
            public void run() {            	
                countProgress();
                handler.postDelayed(this, REPEAT_INTERVAL);
            }
        };
    }
    
    //
    // Listener for Button clicks
    //
	public void onClick(View v) {
		if (v == play1)
		{
			if (isPlay[0])
			{
				stop(0);
				play1.setText("▶");
				pause1.setText("||");
				secView1.setText("0:00 / 0:00");
				seekBar1.setProgress(0);
			}
			else
			{
				int length = play(0);
				if (length != -1)
				{
					seekBar1.setMax(length);
					isSeekBarTouched1 = false;
					length1 = getTimeString(length);
					secView1.setText("0:00 / " + length1);
					play1.setText("■");
					titleView1.setText(filename[0].getName());
				}
			}
		}
		else if (v == play2)
		{
			if (isPlay[1] || isRecording)
			{
				if (isPlay[1]) stop(1);
				if (isRecording) stopRecording();
				showRecordView.setText("");
				play2.setText("▶");
				pause2.setText("||");
				secView2.setText("0:00 / 0:00");
				seekBar2.setProgress(0);
			}
			else
			{
				// Start recording
				if (recordChkBox.isChecked()) record();	
				if (isRecording) showRecordView.setText(R.string.IsRecording);

				// Start playing
				int length = play(1);
				if (length != -1) 
				{
					seekBar2.setMax(length);
					isSeekBarTouched2 = false;
					length2 = getTimeString(length);
					secView2.setText("0:00 / " + length2);
				}
				if (isPlay[1] || isRecording) play2.setText("■");
				
				if (isManual) // When manual mode, pause just after start playing
				{
					try {
					Thread.sleep(100);
					}
					catch (Exception ex){};
					
					pause(1);
					pausePos = nextPos = mplayer[1].getCurrentPosition();
					pause2.setText(isPause[1]?"▶":"||");
				}
			}
		}
		else if (v == pause1)
		{
			pause(0);
			pause1.setText(isPause[0]?"▶":"||");
		}
		else if (v == pause2 && !isManual)
		{
			pause(1);
			pause2.setText(isPause[1]?"▶":"||");
		}
		else if (v == eject)
		{
			callFileSelector();
		}
		else if (v == repeat)
		{
			switch (repeatMode)
			{
			case NONE:
				repeatMode = RepeatMode.SEC;
				break;
			case SEC:
				repeatMode = RepeatMode.THIS;
				break;
			case THIS:
				repeatMode = RepeatMode.ALL;
				break;
			case ALL:
				repeatMode = RepeatMode.NONE;
				break;
			}
			repeat.setText(repeatMode.toString());
		}
		else if (v == secStart)
		{
			if (startPos == -1)
			{
				if (isPlay[1])
				{
					int pos = mplayer[1].getCurrentPosition();
					if (pos < endPos || endPos == -1)
					{
						startPos = pos;
						secStart.setText(getTimeString(startPos));					
					}
				}
			}
			else
			{
				startPos = -1;
				secStart.setText(R.string.secStart);
			}
		}
		else if (v == secEnd)
		{
			if (endPos == -1)
			{
				if (isPlay[1])
				{
					int pos = mplayer[1].getCurrentPosition();
					if (pos > startPos)
					{
						endPos = pos;
						secEnd.setText(getTimeString(endPos));
					}
				}
			}
			else
			{
				endPos = -1;
				secEnd.setText(R.string.secEnd);
			}
		}
		else if (v == rewind2 && isManual)
		{
			nextPos = mplayer[1].getCurrentPosition();
			mplayer[1].seekTo(pausePos);
			countProgress();
		}
		else if (v == forward2 && isManual)
		{
			mplayer[1].seekTo(nextPos);
			countProgress();			
		}
		
		// Register call back if something is played/recorded
		if (isPlay[0] || isPlay[1] || isRecording)
		{
	        handler.postDelayed(runnable, REPEAT_INTERVAL);
		}
		else
		{
			handler.removeCallbacks(runnable);
		}
	}
	
	//
	// Call fileselector intent
	//
	private void callFileSelector()
	{
		Intent intent = new Intent(Shadowinkun.this, FileSelectorActivity.class);
		intent.putExtra(FileSelectorActivity.INTENT_EXTENSION, extension);
		startActivityForResult(intent, REQUEST_FILESELECTOR);
	}
	
	//
	// Return from intents
	//
    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        // From FileSelector
    	if (requestCode == REQUEST_FILESELECTOR && resultCode == RESULT_OK)
    	{
    		filename[1] = new File(data.getExtras().getString(FileSelectorActivity.INTENT_FILEPATH ));
    		titleView2.setText(filename[1].getName());
    	}
        super.onActivityResult(requestCode, resultCode, data);
    }
    
    //
    // play
    //
    private int play(int index)
    {
    	if (filename[index] == null)
    	{
            Toast.makeText(this, R.string.NoFileGivenError, Toast.LENGTH_LONG).show();
        	return -1;
    	}
    	
		try
		{
			mplayer[index].setDataSource(filename[index].getAbsolutePath());
			mplayer[index].prepare();
			mplayer[index].start();
			
			// Set the start pos if repeatMode is SEC
			if (repeatMode == RepeatMode.SEC && index == 1)
			{
				if (startPos > 0 && startPos < mplayer[index].getDuration())
				{
					mplayer[index].seekTo(startPos);
				}
			}

			mplayer[index].setOnCompletionListener(this);
			isPlay[index] = true;
			return mplayer[index].getDuration();
		}
		catch (Exception ee)
		{
            Toast.makeText(this, R.string.palyerInitializefailed, Toast.LENGTH_LONG).show();
			isPlay[index] = false;
			return -1;
		}
    }
    
    //
    // Stop
    //
    private void stop(int index)
    {
		mplayer[index].stop();
		mplayer[index].reset();
		isPlay[index] = false;
		isPause[index] = false;
    }
    
    //
    // Pause
    //
    private void pause(int index)
    {
    	if (!isPlay[index]) return;
    	
    	if (isPause[index])
    	{
    		mplayer[index].start();
    		isPause[index] = false;
    	}
    	else
    	{
    		mplayer[index].pause();
    		isPause[index] = true;
    	}
    }
    
    //
    // Record
    //
    private void record()
    {
    	if (isRecording) return;

	    try {	    	

	        mrec.setAudioSource(MediaRecorder.AudioSource.MIC);
	        mrec.setOutputFormat(MediaRecorder.OutputFormat.THREE_GPP);
	        mrec.setAudioEncoder(MediaRecorder.AudioEncoder.AMR_NB);
	    	
	        // Use the fileName of the original sound so that it can be easy to identify it later
	        String preFix;
	        if (filename[1] == null)
	        {
	        	preFix = "None";
	        }
	        else
	        {
	        	preFix = removeFileExtension(filename[1].getName());
	        }
		    audiofile = File.createTempFile(preFix + "_", ".3gp", todayFolder);
	
	        mrec.setOutputFile(audiofile.getAbsolutePath());
	        mrec.prepare();
	        mrec.start();
	        
	        Date day = new Date();
	        recordStartTime = day.getTime();

	        isRecording = true;
    	}
        catch (IOException e)
        {
            Toast.makeText(this, R.string.palyerInitializefailed, Toast.LENGTH_LONG).show();
            isRecording = false;
        }
    }

    //
    // stop recording
    //
    private void stopRecording()
    {
        mrec.stop();
        mrec.reset();
        processaudiofile();
        isRecording = false;
        
        secView3.setText("0:00");
        showRecordView.setText("");
    }
    
    //
    // Save temporary file after recording stopped
    //
    private void processaudiofile() {
    	// Save the filename so that it can be played by player[0]
    	filename[0] = audiofile;
    	
        ContentValues values = new ContentValues(4);
        long current = System.currentTimeMillis();
            
        values.put(MediaStore.Audio.Media.TITLE, "audio" + audiofile.getName());
        values.put(MediaStore.Audio.Media.DATE_ADDED, (int) (current / 1000));
        values.put(MediaStore.Audio.Media.MIME_TYPE, "audio/3gpp");
        values.put(MediaStore.Audio.Media.DATA, audiofile.getAbsolutePath());
        ContentResolver contentResolver = getContentResolver();
        
        Uri base = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
        Uri newUri = contentResolver.insert(base, values);

        // this does not always seem to work cleanly....
        sendBroadcast(new Intent(Intent.ACTION_MEDIA_SCANNER_SCAN_FILE, newUri));
      }
    
    private void countProgress()
    {
    	if (isPlay[0])
    	{
    		int pos = mplayer[0].getCurrentPosition(); 
			if (!isSeekBarTouched1) seekBar1.setProgress(pos);
			secView1.setText(getTimeString(pos) + " / " + length1);    		
    	}
    	
    	if (isPlay[1])
    	{
    		int pos = mplayer[1].getCurrentPosition();

			if (repeatMode == RepeatMode.SEC && pos > endPos && endPos > 0)
			{
				if (startPos > 0)
					mplayer[1].seekTo(startPos);
				else
					mplayer[1].seekTo(0);					
			}
    		
    		if (!isSeekBarTouched2) seekBar2.setProgress(pos);
			secView2.setText(getTimeString(pos) + " / " + length2); 			
    	}
    	
    	if (isRecording)
    	{
            Date day = new Date();
            long now = day.getTime();
            
            int dur = (int)(now - recordStartTime);
    		secView3.setText(getTimeString(dur));
    		
    		// Blink "Recording"
    		if ((dur / 1000) % 2 == 0)
    		{
    			showRecordView.setText(R.string.IsRecording);
    		}
    		else
    		{
    			showRecordView.setText("");    			
    		}
    		
    	}
    }
    
    //
    // Generate time string (xx:xx)
    //
    private String getTimeString(int millisec)
    {
    	try {
			int sec = (millisec / 1000) % 60;
			int min = millisec / 1000 / 60;
			DecimalFormat nf1 = new DecimalFormat("0");
			DecimalFormat nf2 = new DecimalFormat("00");
			return nf1.format(min) + ":" + nf2.format(sec);
    	}
    	catch (Exception ex)
    	{
    		return "XX:XX";
    	}
    }

	@Override
	public void onCompletion(MediaPlayer mp) {
		if (mp == mplayer[0])
		{
			stop(0);
			play1.setText("▶");
			pause1.setText("||");
			secView1.setText("0:00 / 0:00");
			seekBar1.setProgress(0);
			isPlay[0] = false;
		}
		else
		{
			switch (repeatMode)
			{
			case NONE:
				stop(1);
				isPlay[1] = false;
				secView2.setText("0:00 / 0:00");
				seekBar2.setProgress(0);
				if (!isRecording)
				{
					play2.setText("▶");
				}
				break;
			case THIS:
				mplayer[1].seekTo(0);
				mplayer[1].start();
				break;
			case SEC:
				int pos = 0;
				if (startPos > 0 && startPos < mplayer[1].getDuration())
				{
					pos = startPos;
				}
				mplayer[1].seekTo(pos);
				mplayer[1].start();
				break;
			case ALL:
				stop(1);
				isPlay[1] = false;
				seekBar2.setProgress(0);				
				gotoNextSound(forward2);
				
				int length = play(1);
				if (length != -1) 
				{
					seekBar2.setMax(length);
					isSeekBarTouched2 = false;
					length2 = getTimeString(length);
					secView2.setText("0:00 / " + length2);
				}
				if (isPlay[1] || isRecording) play2.setText("■");
				break;
			}
		}		
	}

	@Override
	public void onProgressChanged(SeekBar seekBar, int progress,
			boolean fromUser) {
		// TODO Auto-generated method stub
		if (seekBar == seekBar1 && fromUser && isPlay[0])
		{
			int pos = seekBar1.getProgress();
			mplayer[0].seekTo(pos);			
		}
		if (seekBar == seekBar2 && fromUser && isPlay[1])
		{
			int pos = seekBar2.getProgress();
			mplayer[1].seekTo(pos);						
		}
	}

	@Override
	public void onStartTrackingTouch(SeekBar seekBar) {
		// TODO Auto-generated method stub
		if (seekBar == seekBar1) isSeekBarTouched1 = true;
		if (seekBar == seekBar2) isSeekBarTouched2 = true;
	}

	@Override
	public void onStopTrackingTouch(SeekBar seekBar) {
		// TODO Auto-generated method stub
		if (seekBar == seekBar1) isSeekBarTouched1 = false;
		if (seekBar == seekBar2) isSeekBarTouched2 = false;
		
	}
	
	//
	// Forward/Rewind
	//
	private void forwardOrRewindPosition()
	{
		if (isPlay[forwardOrRewindPlayerIndex])
		{
			int length = mplayer[forwardOrRewindPlayerIndex].getDuration();
			int pos = mplayer[forwardOrRewindPlayerIndex].getCurrentPosition();
			pos += forwardOrRewindSpeed;
			forwardOrRewindSpeed += (forwardOrRewindSpeed > 0 ? FORWARD_OR_REWIND_ACCEL:-FORWARD_OR_REWIND_ACCEL);
			if (pos > 0 || pos < length)
			{
				mplayer[forwardOrRewindPlayerIndex].seekTo(pos);
			}
		}
	}

	@Override
	public boolean onTouch(View arg0, MotionEvent arg1) {
		// TODO Auto-generated method stub
		
		// Handle manual mode
		if (isManual)
		{
			if(arg1.getAction() == MotionEvent.ACTION_DOWN && arg0 == pause2)
			{
				pause(1);
				pausePos = mplayer[1].getCurrentPosition();
				handler.postDelayed(runnable3, REPEAT_INTERVAL);
			}
			else if (arg1.getAction() == MotionEvent.ACTION_UP && arg0 == pause2)
			{
				pause(1);
				handler.removeCallbacks(runnable3);
			}
		}
		else if (arg0 != pause2)
		{
			// Handle Forward/Rewind
			if(arg1.getAction() == MotionEvent.ACTION_DOWN) {
				if (arg0 == forward1)
				{
					forwardOrRewindSpeed = DEFAULT_FORWARD_OR_REWIND_SPEED;
					forwardOrRewindPlayerIndex = 0;
				}
				else if(arg0 == rewind1)
				{
					forwardOrRewindSpeed = -DEFAULT_FORWARD_OR_REWIND_SPEED;
					forwardOrRewindPlayerIndex = 0;				
				}
				else if (arg0 == forward2)
				{
					forwardOrRewindSpeed = DEFAULT_FORWARD_OR_REWIND_SPEED;
					forwardOrRewindPlayerIndex = 1;				
				}
				else if (arg0 == rewind2)
				{
					forwardOrRewindSpeed = -DEFAULT_FORWARD_OR_REWIND_SPEED;
					forwardOrRewindPlayerIndex = 1;					
				}
				handler.postDelayed(runnable2, REPEAT_INTERVAL2);
			}
			else if(arg1.getAction() == MotionEvent.ACTION_UP)
			{
				handler.removeCallbacks(runnable2);
				
				// If the sound is not played, go to next/previous sound by this
				gotoNextSound(arg0);
			}
		}
		return false;
	}

	private void gotoNextSound(View arg0)
	{
		File nextFile;
		if ((arg0 == forward1 || arg0 == rewind1) && !isPlay[0] && filename[0] != null)
		{
			if (arg0 == forward1)
			{
				nextFile = findNextFile(filename[0], true);
				filename[0] = nextFile;
			}
			else if (arg0 == rewind1)
			{
				stop(0);
				nextFile = findNextFile(filename[0], false);				
				filename[0] = nextFile;
			}
			titleView1.setText(filename[0].getName());
		}
		else if ((arg0 == forward2 || arg0 == rewind2) && !isPlay[1] && filename[1] != null)
		{
			if (arg0 == forward2)
			{
				stop(1);
				nextFile = findNextFile(filename[1], true);								
				filename[1] = nextFile;
			}
			else if (arg0 == rewind2)
			{
				stop(1);
				nextFile = findNextFile(filename[1], false);				
				filename[1] = nextFile;
			}
			titleView2.setText(filename[1].getName());
			
			startPos = -1;
			secStart.setText(R.string.secStart);
			endPos = -1;
			secEnd.setText(R.string.secEnd);

		}
	}
	
	private File findNextFile(File thisFile, boolean findNext)
	{		
		File[] files = thisFile.getParentFile().listFiles();

		// ディレクトリ→大文字小文字無視で名前順になるようにソート
		Arrays.sort(files, new Comparator<File>() {
			@Override
			public int compare(File object1, File object2) {
				final boolean isdir1 = object1.isDirectory();
				final boolean isdir2 = object2.isDirectory();

				if (isdir1 ^ isdir2) {
					if (isdir1) {
						return -1;
					} else {
						return 1;
					}
				}
				return object1.getName().compareToIgnoreCase(object2.getName());
			}
		});

		// ファイルは拡張子に一致するもの、ディレクトリは全部、ArrayListに追加する
		ArrayList<File> items = new ArrayList<File>();
		for (File file : files) {
			String name = file.getName();
			String smallname = name.toLowerCase();
			for (String ext : extension) {
				if (smallname.endsWith(ext)) {
					items.add(file);
					break;
				}
			}
		}
		
		for (int i = 0 ; i < items.size() ; i++)
		{
			if (items.get(i).getName().equals(thisFile.getName()))
			{
				if (findNext && i < items.size()-1)
					return items.get(i+1);
				else if (!findNext && i > 0)
					return items.get(i-1);
			}
		}
		return thisFile;
	}	

	private static String removeFileExtension(String filename) {
		int lastDotPos = filename.lastIndexOf('.');

		if (lastDotPos == -1) {
			return filename;
		} else if (lastDotPos == 0) {
			return filename;
		} else {
			return filename.substring(0, lastDotPos);
		}
	}

	@Override
	public void onCheckedChanged(CompoundButton arg0, boolean arg1) {
		// TODO Auto-generated method stub
		if (arg1 == true)
		{
			if (isPlay[1] && !isRecording)
			{
				record();	
				if (isRecording) showRecordView.setText(R.string.IsRecording);
			}
		}
		else
		{
			if (isPlay[1] && isRecording)
			{
				stopRecording();
				showRecordView.setText("");
			}
		}
	}
	
	// Handling a menu
    @Override
    public boolean onPrepareOptionsMenu(Menu menu) {
        // Add menus
    	menu.clear();
        if (isManual)
        {
        	menu.add(Menu.NONE, MENU_ID_MENU1, Menu.NONE, getResources().getString(R.string.DisableManual));
        }
        else
        {
        	menu.add(Menu.NONE, MENU_ID_MENU1, Menu.NONE, getResources().getString(R.string.EnableManual));
        }
        return super.onPrepareOptionsMenu(menu);
    }
    
    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        boolean ret = true;
        switch (item.getItemId()) {
        default:
        	ret = super.onOptionsItemSelected(item);
        	break;
        case MENU_ID_MENU1:
        	if (isManual)
        	{
        		isManual = false;
        	}
        	else
        	{
        		isManual = true;
        	}
        	break;
        }
        return ret;
    }

}