﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using FDK.メディア;
using FDK;	// string拡張メソッド用。

namespace SST.曲
{
	public class タイトルテクスチャ : FDK.メディア.ビットマップ付きテクスチャ
	{
		public string 表示文字列 { get; set; } = null;

		public タイトルテクスチャ( string 初期文字列 ) : base( new SharpDX.Size2( 1, 1 ) )
		{
			this.表示文字列 = 初期文字列 ?? "(no title)";
		}

		protected override void Onデバイス依存リソースの作成( デバイスリソース dr )
		{
			this._テクスチャを更新する( dr );
		}

		protected override void Onデバイス依存リソースの解放( デバイスリソース dr )
		{
			// テキスト描画用リソースを解放する。
			FDK.Utilities.解放する( ref this._黒ブラシ );
			FDK.Utilities.解放する( ref this._白ブラシ );
			FDK.Utilities.解放する( ref this._テキストレイアウト );
			FDK.Utilities.解放する( ref this._テキストフォーマット );

			// ビットマップ付きテクスチャを解放する。
			base.Onデバイス依存リソースの解放( dr );
		}

		public new void 描画する( デバイスリソース dr, SharpDX.Matrix ワールド行列変換, SharpDX.RectangleF? 転送元矩形 = null )
		{
			if( this.表示文字列.Nullまたは空である() )
				return;

			// 表示文字列が変更されているなら、ここで表示ビットマップの再構築を行う。
			if( false == string.Equals( this.表示文字列, this._前回の表示文字列 ) )
				this._テクスチャを更新する( dr );

			// テクスチャを描画する。
			base.描画する( dr, ワールド行列変換, 転送元矩形 );
		}

		private float _フォントサイズpt = 30.0f;

		private string _フォント名 = "メイリオ";

		private string _前回の表示文字列 = null;

		private SharpDX.DirectWrite.TextFormat _テキストフォーマット = null;

		private SharpDX.DirectWrite.TextLayout _テキストレイアウト = null;

		private SharpDX.Direct2D1.SolidColorBrush _白ブラシ = null;

		private SharpDX.Direct2D1.SolidColorBrush _黒ブラシ = null;

		private void _テクスチャを更新する( デバイスリソース dr )
		{
			this._前回の表示文字列 = this.表示文字列;

			// すべてのリソースを解放する。
			this.Onデバイス依存リソースの解放( dr ); // base. じゃなくて this.

			if( this.表示文字列.Nullまたは空である() )
				return;

			#region " テキストフォーマット／レイアウトを作成し、表示ビットマップのサイズを計算し、ユーザ指定サイズdpx に格納する。"
			//----------------
			this._テキストフォーマット = new SharpDX.DirectWrite.TextFormat( dr.DWriteFactory, this._フォント名, this._フォントサイズpt ) {
				TextAlignment = SharpDX.DirectWrite.TextAlignment.Leading,
			};

			var 最大サイズdpx = dr.設計画面サイズdpx;
			this._テキストレイアウト = new SharpDX.DirectWrite.TextLayout(
				dr.DWriteFactory,
				this.表示文字列.Nullまたは空である() ? " " : this.表示文字列,
				this._テキストフォーマット,
				最大サイズdpx.Width,
				最大サイズdpx.Height );

			this.ユーザ指定サイズdpx = new SharpDX.Size2(
				(int) ( this._テキストレイアウト.Metrics.WidthIncludingTrailingWhitespace + 0.5f ),
				(int) ( this._テキストレイアウト.Metrics.Height + 0.5f ) );
			//----------------
			#endregion

			// ビットマップ付きテクスチャを作成する。（上で設定した ユーザ指定サイズdpx の大きさで作成される。）
			base.Onデバイス依存リソースの作成( dr );	// this. じゃなくて base.

			#region " ビットマップに文字列を描画する。"
			//----------------
			this.ビットマップへ描画する( dr, ( context, bitmap ) => {

				this._白ブラシ = new SharpDX.Direct2D1.SolidColorBrush( dr.D2DContext1, SharpDX.Color.LightGray );
				this._黒ブラシ = new SharpDX.Direct2D1.SolidColorBrush( dr.D2DContext1, SharpDX.Color.Black );

				dr.D2DContext1.Clear( SharpDX.Color.Transparent );

				dr.D2DContext1.DrawTextLayout(    // ドロップシャドウ部
					new SharpDX.Vector2( 1.0f, 1.0f ),
					this._テキストレイアウト,
					this._黒ブラシ,
					SharpDX.Direct2D1.DrawTextOptions.Clip );

				dr.D2DContext1.DrawTextLayout(    // 本体部
					new SharpDX.Vector2( 0.0f, 0.0f ),
					this._テキストレイアウト,
					this._白ブラシ,
					SharpDX.Direct2D1.DrawTextOptions.Clip );
			} );
			//----------------
			#endregion
		}
	}
}
