﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using FDK.メディア;

namespace SST.ステージ
{
	/// <summary>
	///		ドラム一式を表す Activity。表示と操作が可能。
	/// </summary>
	class ドラムセット : FDK.Activity
	{
		/// <summary>
		///		0.0:閉じる ～ 1.0:開く
		/// </summary>
		public float ハイハットの開度
		{
			get
			{
				return this._ハイハットの開度;
			}
			set
			{
				if( 1.0f < value )
					throw new OutOfMemoryException( "1.0 を超える値は設定できません。" );
				else if( 0.0f > value )
					throw new OutOfMemoryException( "負数は設定できません。" );
				else
					this._ハイハットの開度 = value;
			}
		}

		public ドラムセット()
		{
			this.子リスト.Add( this._HiHatTop = new 画像( @"$(Static)\images\DrumKit HiHat Top.png" ) );
			this.子リスト.Add( this._HiHatBottom = new 画像( @"$(Static)\images\DrumKit HiHat Bottom.png" ) );
			this.子リスト.Add( this._Snare = new 画像( @"$(Static)\images\DrumKit Snare.png" ) );
			this.子リスト.Add( this._Bass = new 画像( @"$(Static)\images\DrumKit Bass.png" ) );
			this.子リスト.Add( this._HiTom = new 画像( @"$(Static)\images\DrumKit HiTom.png" ) );
			this.子リスト.Add( this._LowTom = new 画像( @"$(Static)\images\DrumKit LowTom.png" ) );
			this.子リスト.Add( this._FloorTom = new 画像( @"$(Static)\images\DrumKit FloorTom.png" ) );
			this.子リスト.Add( this._LCymbal = new 画像( @"$(Static)\images\DrumKit LCymbal.png" ) );
			this.子リスト.Add( this._LCymbalStand = new 画像( @"$(Static)\images\DrumKit LCymbal Stand.png" ) );
			this.子リスト.Add( this._LCymbalTop = new 画像( @"$(Static)\images\DrumKit LCymbal Top.png" ) );
			this.子リスト.Add( this._RCymbal = new 画像( @"$(Static)\images\DrumKit RCymbal.png" ) );
			this.子リスト.Add( this._RCymbalStand = new 画像( @"$(Static)\images\DrumKit RCymbal Stand.png" ) );
			this.子リスト.Add( this._RCymbalTop = new 画像( @"$(Static)\images\DrumKit RCymbal Top.png" ) );
		}

		public void 進行描画する( デバイスリソース dr )
		{
			this._Bass.描画する( dr, 881f, 891f );
			this._LowTom.描画する( dr, 999f, 901f );
			this._HiTom.描画する( dr, 850f, 901f );
			this._FloorTom.描画する( dr, 1050f, 981f );
			this._Snare.描画する( dr, 741f, 988f );
			this._HiHatBottom.描画する( dr, 657f, 935f );
			this._HiHatTop.描画する( dr, 657f, ( 935f - 20f * this.ハイハットの開度 ) );
			this._RCymbalStand.描画する( dr, 1229f, 920f );
			this._RCymbal.描画する( dr, 1257f - this._RCymbal.サイズdpx.Width / 2f, 923f - this._RCymbal.サイズdpx.Height / 2f );
			this._RCymbalTop.描画する( dr, 1229f, 880f );
			this._LCymbalStand.描画する( dr, 472f, 916f );
			this._LCymbal.描画する( dr, 649f - this._LCymbal.サイズdpx.Width / 2f, 918f - this._LCymbal.サイズdpx.Height / 2f );
			this._LCymbalTop.描画する( dr, 633f, 891f );
		}

		private float _ハイハットの開度 = 1.0f;

		private FDK.メディア.画像 _HiHatTop;

		private FDK.メディア.画像 _HiHatBottom;

		private FDK.メディア.画像 _Snare;

		private FDK.メディア.画像 _Bass;

		private FDK.メディア.画像 _HiTom;

		private FDK.メディア.画像 _LowTom;

		private FDK.メディア.画像 _FloorTom;

		private FDK.メディア.画像 _LCymbal;

		private FDK.メディア.画像 _LCymbalStand;

		private FDK.メディア.画像 _LCymbalTop;

		private FDK.メディア.画像 _RCymbal;

		private FDK.メディア.画像 _RCymbalStand;

		private FDK.メディア.画像 _RCymbalTop;
	}
}
