﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using FDK.メディア;

namespace SST.ステージ.タイトル
{
	/// <remarks>
	/// 入力：
	/// 　なし
	/// 出力：
	/// 　this.現在のフェーズ ← 確定 or キャンセル
	/// </remarks>
	class タイトルステージ : SST.ステージ.ステージ
	{
		public enum フェーズ
		{
			初期状態,
			表示中,
			確定,
			キャンセル,
		}

		public フェーズ 現在のフェーズ { get; protected set; } = フェーズ.初期状態;

		public タイトルステージ()
		{
			this.子リスト.Add( this._背景画像 = new 画像( @"$(Static)\images\タイトル画面.jpg" ) );
		}

		protected override void On活性化( デバイスリソース dr )
		{
			FDK.Log.Info( "タイトルステージを開始します。" );
			this.現在のフェーズ = フェーズ.表示中;
		}

		protected override void On非活性化( デバイスリソース dr )
		{
			FDK.Log.Info( "タイトルステージを終了します。" );
		}

		public override void 進行描画する( デバイスリソース dr )
		{
			if( this.現在のフェーズ != フェーズ.表示中 )
				return;

			// 進行・描画。
			this._背景画像.描画する( dr, 0.0f, 0.0f );

			// 入力。

			StrokeStyleT.すべての入力デバイスをポーリングする();

			// Enter 押下 → 確定＆ステージ終了
			if( StrokeStyleT.キーボード入力.キーが押された( SharpDX.DirectInput.Key.Return ) )
			{
				this.現在のフェーズ = フェーズ.確定;
			}
			// Esc 押下 → キャンセル＆ステージ終了
			else if( StrokeStyleT.キーボード入力.キーが押された( SharpDX.DirectInput.Key.Escape ) )
			{
				this.現在のフェーズ = フェーズ.キャンセル;
			}
		}

		private FDK.メディア.画像 _背景画像 = null;
	}
}
