﻿using System;

namespace FDK.入力
{
	/// <summary>
	///		入力イベントデータの最小単位。全入力デバイスで共通。
	/// </summary>
	public class InputEvent
	{
		/// <summary>
		///		イベントが発生したキーのコード。
		///		値の意味はデバイスに依存する。
		/// </summary>
		public int Key { get; set; }

		/// <summary>
		///		キーが押されたのであれば true。
		///		「離された」プロパティとは排他。
		/// </summary>
		public bool 押された { get; set; }

		/// <summary>
		///		キーが離されたのであれば true。
		///		「押された」プロパティとは排他。
		/// </summary>
		public bool 離された { get; set; }

		/// <summary>
		///		このイベントが発生した時点の生パフォーマンスカウンタの値。
		/// </summary>
		public long TimeStamp { get; set; }

		/// <summary>
		///		入力されたキーの強さ。
		///		値の意味はデバイスに依存する。
		/// </summary>
		public int Velocity { get; set; }
	}
}
