﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using FDK.メディア;

namespace SST.ステージ.選曲
{
	/// <summary>
	///		曲パネルリスト（９列３行）を表示する。
	/// </summary>
	/// <remarks>
	///		静止時の可視範囲は、左右両端の１列を除いた７列３行。
	///		左右両端の列は、静止時は画面外に位置しており、左右スクロール中にのみ画面内に一部が表示される。
	///		「カーソル」は、常に、曲パネル内のいずれか１枚の曲を選択している。
	///		カーソルは、初期状態では中央の曲を選択しており、本クラスのメソッドを使って上下左右に移動することができる。
	///		カーソルが選択している曲は強調表示（視覚効果として少し拡大して表示）される。
	/// </remarks>
	class 曲パネルビュー : FDK.Activity
	{
		public 曲パネルビュー()
		{
			this.子リスト.Add( this._Nullパネルの画像 = new テクスチャ( @"$(Static)\images\選曲パネル.png" ) );
		}

		public void カーソルを上に移動する()
		{
			if( 0 < this._カーソル位置.Y )
			{
				this._カーソル位置.Y--;
			}
			else
			{
				this._カーソル位置.X--;
				this._カーソル位置.Y = 2;
			}

			// カーソルと一緒に、選択曲も移動する。
			StrokeStyleT.曲ツリー管理.前のノードを選択する();
		}

		public void カーソルを下に移動する()
		{
			if( 2 > this._カーソル位置.Y )
			{
				this._カーソル位置.Y++;
			}
			else
			{
				this._カーソル位置.X++;
				this._カーソル位置.Y = 0;
			}

			// カーソルと一緒に、選択曲も移動する。
			StrokeStyleT.曲ツリー管理.次のノードを選択する();
		}

		public void カーソルを左に移動する()
		{
			this._カーソル位置.X--;    // 制限なし

			// カーソルと一緒に、選択曲も移動する。
			StrokeStyleT.曲ツリー管理.前のノードを選択する();	// １つ左へ ＝ ３つ前へ
			StrokeStyleT.曲ツリー管理.前のノードを選択する();
			StrokeStyleT.曲ツリー管理.前のノードを選択する();
		}

		public void カーソルを右に移動する()
		{
			this._カーソル位置.X++;    // 制限なし

			// カーソルと一緒に、選択曲も移動する。
			StrokeStyleT.曲ツリー管理.次のノードを選択する();	// １つ右へ ＝ ３つ次へ
			StrokeStyleT.曲ツリー管理.次のノードを選択する();
			StrokeStyleT.曲ツリー管理.次のノードを選択する();
		}

		protected override void On活性化( デバイスリソース dr )
		{
			this._活性化した直後である = true;
		}

		protected override void On非活性化( デバイスリソース dr )
		{
		}

		public void 進行描画する( デバイスリソース dr )
		{
			// 進行。

			if( this._活性化した直後である )
			{
				this._活性化した直後である = false;
				this._横スクロール用カウンタ = new FDK.カウンタ.定間隔進行();
			}
			else
			{
				#region " カーソルの移動に伴う全パネルの横方向スクロール進行。"
				//----------------
				this._横スクロール用カウンタ.経過時間の分だけ進行する( 8, () => {

					int オフセットの加減算速度 = 1;

					#region " カーソルが中央から遠いほど速くなるよう、オフセットの加減算速度（絶対値）を計算する。"
					//------------------
					int 距離 = Math.Abs( 4 - this._カーソル位置.X );
					if( 1 >= 距離 )
						オフセットの加減算速度 = 2;
					else if( 4 >= 距離 )
						オフセットの加減算速度 = 4;
					else if( 6 >= 距離 )
						オフセットの加減算速度 = 6;
					else
						オフセットの加減算速度 = 8;
					//------------------
					#endregion

					// オフセット と カーソル位置.X を更新する。
					if( ( 4 > this._カーソル位置.X ) ||
						( ( 4 == this._カーソル位置.X ) && ( 0 > this._パネル全体のY軸回転オフセット ) ) )
					{
						#region " (A) パネルは、左から右へ、移動する。"
						//-----------------
						this._パネル全体のY軸回転オフセット += オフセットの加減算速度;

						// １列分移動した
						if( 64 <= this._パネル全体のY軸回転オフセット )
						{
							this._パネル全体のY軸回転オフセット -= 64;  // 0 付近に戻る
							this._カーソル位置.X++;
						}
						//-----------------
						#endregion
					}
					else if( ( 4 < this._カーソル位置.X ) ||
						( ( 4 == this._カーソル位置.X ) && ( 0 < this._パネル全体のY軸回転オフセット ) ) )
					{
						#region " (B) パネルは、右から左へ、移動する。"
						//-----------------
						this._パネル全体のY軸回転オフセット -= オフセットの加減算速度;

						// １列分移動した
						if( -64 >= this._パネル全体のY軸回転オフセット )
						{
							this._パネル全体のY軸回転オフセット += 64;  // 0 付近に戻る
							this._カーソル位置.X--;
						}
						//-----------------
						#endregion
					}

				} );
				//----------------
				#endregion
			}

			// 描画。

			Debug.Assert( null != StrokeStyleT.ユーザ管理?.現在選択されているユーザ?.曲ツリーのルートノード );

			var 曲リスト管理 = StrokeStyleT.曲ツリー管理;
			var 曲リスト = 曲リスト管理.現在選択されているノード?.親ノード.子ノードリスト ?? 曲リスト管理.現在の管理対象ツリー.子ノードリスト;
			var 描画する曲 = 曲リスト管理.現在選択されているノード;    // null 可
			var カーソル位置の曲 = (曲.Node) null;   // null 可

			#region " 左上隅パネルに対応する曲リストノードを検索する。"
			//-----------------
			int 現在のカーソルから左上隅までの差 = 0 - ( this._カーソル位置.X * 3 + this._カーソル位置.Y );   // 現在のカーソルの位置に、現在選択されている曲が対応するものとする。

			if( 0 < 現在のカーソルから左上隅までの差 )
			{
				// 曲リストを前方へたどる。
				for( int i = 0; i < 現在のカーソルから左上隅までの差; i++ )
					描画する曲 = 描画する曲?.次のノード;
			}
			else
			{
				// 曲リストを後方へたどる。
				for( int i = 現在のカーソルから左上隅までの差; i < 0; i++ )
					描画する曲 = 描画する曲?.前のノード;
			}
			//-----------------
			#endregion
			#region " 9×3枚の曲パネルを描画する。"
			//-----------------
			for( int i = 0; i < ( 9 * 3 ); i++ )
			{
				var パネル位置 = new SharpDX.Point( i / 3, i % 3 );

				if( パネル位置 == this._カーソル位置 )
				{
					// カーソル位置にあるパネルは後で描画するので、覚えておく。
					カーソル位置の曲 = 描画する曲;
				}
				else
				{
					this._パネルを一枚描画する( dr, 描画する曲, パネル位置, これはカーソル位置のパネルである: false );
				}

				// 次のノードへ移動。（選択ノードは移動しない。）
				描画する曲 = 描画する曲?.次のノード;
			}
			//-----------------
			#endregion
			#region " カーソル位置のパネルを描画する。"
			//-----------------
			if( ( 0 <= this._カーソル位置.X ) && ( 9 > this._カーソル位置.X ) &&
				( 0 <= this._カーソル位置.Y ) && ( 3 > this._カーソル位置.Y ) )
			{
				this._パネルを一枚描画する(
					dr,
					カーソル位置の曲,   // 先の for ループ内で取得済み。
					this._カーソル位置,
					これはカーソル位置のパネルである: true );
			}
			//-----------------
			#endregion
		}

		private const float _カーソル位置のパネルの拡大率 = 1.25f;

		private bool _活性化した直後である = false;

		private FDK.メディア.テクスチャ _Nullパネルの画像;

		private FDK.カウンタ.定間隔進行 _横スクロール用カウンタ = null;

		/// <summary>
		///		左上隅のパネルを (0,0) とした時の、カーソル位置の座標。
		///		負数も可。
		/// </summary>
		private SharpDX.Point _カーソル位置 = new SharpDX.Point( 4, 1 );
		
		/// <summary>
		///		-63～63。パネル全体の表示位置を、負数は 左 へ、正数は 右 へずらす 。（正負と左右の対応に注意。）
		/// </summary>
		/// <remarks>
		///		±64 は、パネル１列分を表すサイズ。
		/// </remarks>
		private int _パネル全体のY軸回転オフセット = 0;

		/// <summary>
		///		パネルを一枚（ノード画像とタイトル画像）を、指定したパネル位置に描画する。
		/// </summary>
		/// <param name="パネルノード">
		///		null 可。
		///	</param>
		private void _パネルを一枚描画する( デバイスリソース dr, 曲.Node パネルノード, SharpDX.Point パネル位置, bool これはカーソル位置のパネルである = false )
		{
			// 画面を見ながら直観的に調整した固定パラメータたち。
			const float 見かけの倍率 = 3.0f;
			const float パネル全体のY方向移動量dpx = +250f;    // パネル全体を少しだけ上にシフトする。
			const float パネル全体のZ方向移動量dpx = +3000f;
			const float 行間 = 1.1f;
			const float パネル間X方向角度deg = 19f;
			const float カーソルパネルの拡大率 = 1.5f;

			var Y軸回転 = SharpDX.Matrix.RotationY( SharpDX.MathUtil.DegreesToRadians( ( ( パネル位置.X - 4 ) + ( this._パネル全体のY軸回転オフセット / 64f ) ) * パネル間X方向角度deg ) );

			// Nullパネル画像を表示する。
			{
				var 拡大縮小 = SharpDX.Matrix.Scaling( SST.曲.Node.ノードの全体サイズdpx.Width, SST.曲.Node.ノードの全体サイズdpx.Height, 1f )
					* SharpDX.Matrix.Scaling( 見かけの倍率 )
					* ( ( これはカーソル位置のパネルである ) ? SharpDX.Matrix.Scaling( カーソルパネルの拡大率 ) : SharpDX.Matrix.Identity );

				var 平行移動 = SharpDX.Matrix.Translation(
					0f,
					パネル全体のY方向移動量dpx + ( 1 - パネル位置.Y ) * ( SST.曲.Node.ノードの全体サイズdpx.Height * 見かけの倍率 * 行間 ),
					パネル全体のZ方向移動量dpx );

				this._Nullパネルの画像.描画する( dr, ( 拡大縮小 * 平行移動 * Y軸回転 ) );
			}
			if( null != パネルノード )
			{
				// ノード画像を表示する。
				{
					var 拡大縮小 = SharpDX.Matrix.Scaling( パネルノード.ノードの画像領域のサイズdpx.Width, パネルノード.ノードの画像領域のサイズdpx.Height, 1f )
						* SharpDX.Matrix.Scaling( 見かけの倍率 )
						* ( ( これはカーソル位置のパネルである ) ? SharpDX.Matrix.Scaling( カーソルパネルの拡大率 ) : SharpDX.Matrix.Identity );

					var 平行移動 = SharpDX.Matrix.Translation(
						0f,
						パネル全体のY方向移動量dpx
							+ ( 1 - パネル位置.Y ) * ( SST.曲.Node.ノードの全体サイズdpx.Height * 見かけの倍率 * 行間 )
							+ ( パネルノード.ノードのタイトル領域のサイズdpx.Height / 2f ) * 見かけの倍率,
						パネル全体のZ方向移動量dpx + 1f );

					パネルノード.ノード画像を描画する( dr, ( 拡大縮小 * 平行移動 * Y軸回転 ) );
				}

				// タイトル文字列画像を表示する。
				{
					float 幅dpx = Math.Min( パネルノード.タイトル画像サイズdpx.Width, パネルノード.ノードのタイトル領域のサイズdpx.Width );	// 左右にはみ出さないよう圧縮
					var 拡大縮小 = SharpDX.Matrix.Scaling( 幅dpx, パネルノード.タイトル画像サイズdpx.Height, 1f )
						* SharpDX.Matrix.Scaling( 見かけの倍率 )
						* ( ( これはカーソル位置のパネルである ) ? SharpDX.Matrix.Scaling( カーソルパネルの拡大率 ) : SharpDX.Matrix.Identity );

					var 平行移動 = SharpDX.Matrix.Translation(
						0f,
						パネル全体のY方向移動量dpx
							+ ( 1 - パネル位置.Y ) * ( SST.曲.Node.ノードの全体サイズdpx.Height * 見かけの倍率 * 行間 )
							- ( パネルノード.ノードの画像領域のサイズdpx.Height / 2f ) * ( 見かけの倍率 * ( ( これはカーソル位置のパネルである ) ? 1.5f : 1.0f ) ),
						パネル全体のZ方向移動量dpx + 2f );

					パネルノード.タイトル画像を描画する( dr, ( 拡大縮小 * 平行移動 * Y軸回転 ) );
				}
			}
		}
	}
}
