﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;

namespace FDK.メディア
{
	/// <summary>
	///		任意個の文字を格納した一枚の画像と、それぞれの文字領域の矩形リストから、文字列を連続するD2D画像で表示する。
	/// </summary>
	public class 画像フォント : FDK.Activity
	{
		public 画像フォント( string 文字盤の画像ファイルパス, string 文字矩形リストファイルパス )
			: this( 文字盤の画像ファイルパス, new FDK.メディア.矩形リスト( 文字矩形リストファイルパス ) )
		{
		}

		public 画像フォント( string 文字盤の画像ファイルパス, FDK.メディア.矩形リスト 文字矩形リスト )
		{
			this.子リスト.Add( this._文字盤 = new 画像( 文字盤の画像ファイルパス ) );
			this._文字矩形リスト = 文字矩形リスト;
		}

		public void 描画する( デバイスリソース dr, float 左位置dpx, float 上位置dpx, string 表示文字列 )
		{
			if( 表示文字列.Nullまたは空である() )
				return;

			// 有効文字（矩形リストに登録されている文字）の矩形、文字数を抽出し、文字列全体のサイズを計算する。
			var 有効文字矩形s =
				from 文字 in 表示文字列
				where ( this._文字矩形リスト.文字列to矩形.ContainsKey( new string( new char[] { 文字 } ) ) )
				select this._文字矩形リスト.文字列to矩形[ new string( new char[] { 文字 } ) ];

			int 有効文字数 = 有効文字矩形s.Count();
			if( 0 == 有効文字数 )
				return;

			var 文字列全体のサイズdpx = SharpDX.Size2F.Empty;
			foreach( var 文字矩形 in 有効文字矩形s )
			{
				文字列全体のサイズdpx.Width += 文字矩形.Width;
				if( 文字列全体のサイズdpx.Height < 文字矩形.Height )
					文字列全体のサイズdpx.Height = 文字矩形.Height;  // 文字列全体の高さは、最大の文字高に一致。
			}

			// 描画する。
			for( int i = 0; i < 有効文字数; i++ )
			{
				var 文字矩形 = 有効文字矩形s.ElementAt( i );
				this._文字盤.描画する( dr, 左位置dpx, 上位置dpx, 転送元矩形dpx: 文字矩形 );
				左位置dpx += 文字矩形.Width;
			}
		}

		private FDK.メディア.画像 _文字盤 = null;

		private FDK.メディア.矩形リスト _文字矩形リスト = null;
	}
}
